/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.Guard;
import com.github.sommeri.less4j.core.ast.annotations.NotAstProperty;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.List;

public class GuardBinary
extends Guard {
    private Guard left;
    private Operator operator;
    private Guard right;

    public GuardBinary(HiddenTokenAwareTree token, Guard left, Operator operator, Guard right) {
        super(token);
        this.left = left;
        this.operator = operator;
        this.right = right;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public Guard getLeft() {
        return this.left;
    }

    public void setLeft(Guard left) {
        this.left = left;
    }

    public Guard getRight() {
        return this.right;
    }

    public void setRight(Guard right) {
        this.right = right;
    }

    @Override
    @NotAstProperty
    public List<? extends ASTCssNode> getChilds() {
        return ArraysUtils.asNonNullList(this.left, this.right);
    }

    @Override
    public String toString() {
        return "[" + this.left + (Object)((Object)this.operator) + this.right + "]";
    }

    @Override
    public GuardBinary clone() {
        GuardBinary result = (GuardBinary)super.clone();
        result.left = this.left == null ? null : this.left.clone();
        result.right = this.right == null ? null : this.right.clone();
        result.configureParentToAllChilds();
        return result;
    }

    @Override
    public Guard.Type getGuardType() {
        return Guard.Type.BINARY;
    }

    public static enum Operator {
        AND("and"),
        OR("or");

        private final String symbol;

        private Operator(String symbol) {
            this.symbol = symbol;
        }

        public String getSymbol() {
            return this.symbol;
        }
    }
}

