/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.utils;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import org.apache.lucene.benchmark.byTask.feeds.ContentItemsSource;
import org.apache.lucene.benchmark.byTask.feeds.DocMaker;
import org.apache.lucene.benchmark.byTask.feeds.EnwikiContentSource;
import org.apache.lucene.benchmark.byTask.feeds.NoMoreDataException;
import org.apache.lucene.benchmark.byTask.utils.Config;
import org.apache.lucene.document.Document;
import org.apache.lucene.util.IOUtils;

public class ExtractWikipedia {
    private Path outputDir;
    private int count = 0;
    static final int BASE = 10;
    protected DocMaker docMaker;

    public ExtractWikipedia(DocMaker docMaker, Path outputDir) throws IOException {
        this.outputDir = outputDir;
        this.docMaker = docMaker;
        System.out.println("Deleting all files in " + String.valueOf(outputDir));
        IOUtils.rm((Path[])new Path[]{outputDir});
    }

    public Path directory(int count, Path directory) {
        int base;
        if (directory == null) {
            directory = this.outputDir;
        }
        for (base = 10; base <= count; base *= 10) {
        }
        if (count < 10) {
            return directory;
        }
        directory = directory.resolve(Integer.toString(base / 10));
        directory = directory.resolve(Integer.toString(count / (base / 10)));
        return this.directory(count % (base / 10), directory);
    }

    public void create(String id, String title, String time, String body) throws IOException {
        Path d = this.directory(this.count++, null);
        Files.createDirectories(d, new FileAttribute[0]);
        Path f = d.resolve(id + ".txt");
        StringBuilder contents = new StringBuilder();
        contents.append(time);
        contents.append("\n\n");
        contents.append(title);
        contents.append("\n\n");
        contents.append(body);
        contents.append("\n");
        try (BufferedWriter writer = Files.newBufferedWriter(f, StandardCharsets.UTF_8, new OpenOption[0]);){
            writer.write(contents.toString());
        }
    }

    public void extract() throws Exception {
        Document doc = null;
        System.out.println("Starting Extraction");
        long start = System.currentTimeMillis();
        try {
            while ((doc = this.docMaker.makeDocument()) != null) {
                this.create(doc.get("docid"), doc.get("doctitle"), doc.get("docdate"), doc.get("body"));
            }
        }
        catch (NoMoreDataException noMoreDataException) {
            // empty catch block
        }
        long finish = System.currentTimeMillis();
        System.out.println("Extraction took " + (finish - start) + " ms");
    }

    public static void main(String[] args) throws Exception {
        Path wikipedia = null;
        Path outputDir = Paths.get("enwiki", new String[0]);
        boolean keepImageOnlyDocs = true;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("--input") || arg.equals("-i")) {
                wikipedia = Paths.get(args[i + 1], new String[0]);
                ++i;
                continue;
            }
            if (arg.equals("--output") || arg.equals("-o")) {
                outputDir = Paths.get(args[i + 1], new String[0]);
                ++i;
                continue;
            }
            if (!arg.equals("--discardImageOnlyDocs") && !arg.equals("-d")) continue;
            keepImageOnlyDocs = false;
        }
        Properties properties = new Properties();
        properties.setProperty("docs.file", wikipedia.toAbsolutePath().toString());
        properties.setProperty("content.source.forever", "false");
        properties.setProperty("keep.image.only.docs", String.valueOf(keepImageOnlyDocs));
        Config config = new Config(properties);
        EnwikiContentSource source = new EnwikiContentSource();
        ((ContentItemsSource)source).setConfig(config);
        DocMaker docMaker = new DocMaker();
        docMaker.setConfig(config, source);
        docMaker.resetInputs();
        if (Files.exists(wikipedia, new LinkOption[0])) {
            System.out.println("Extracting Wikipedia to: " + String.valueOf(outputDir) + " using EnwikiContentSource");
            Files.createDirectories(outputDir, new FileAttribute[0]);
            ExtractWikipedia extractor = new ExtractWikipedia(docMaker, outputDir);
            extractor.extract();
        } else {
            ExtractWikipedia.printUsage();
        }
    }

    private static void printUsage() {
        System.err.println("Usage: java -cp <...> org.apache.lucene.benchmark.utils.ExtractWikipedia --input|-i <Path to Wikipedia XML file> [--output|-o <Output Path>] [--discardImageOnlyDocs|-d]");
        System.err.println("--discardImageOnlyDocs tells the extractor to skip Wiki docs that contain only images");
    }
}

