/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell.commands;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.knox.gateway.shell.KnoxDataSource;
import org.apache.knox.gateway.shell.KnoxSession;
import org.apache.knox.gateway.shell.commands.AbstractKnoxShellCommand;
import org.apache.knox.gateway.shell.jdbc.JDBCUtils;
import org.codehaus.groovy.tools.shell.Groovysh;

public abstract class AbstractSQLCommandSupport
extends AbstractKnoxShellCommand {
    protected static final String KNOXDATASOURCES = "__knoxdatasources";
    protected static final String KNOXDATASOURCE = "__knoxdatasource";
    private static final Object KNOXDATASOURCE_CONNECTIONS = "__knoxdatasourceconnections";

    public AbstractSQLCommandSupport(Groovysh shell, String name, String shortcut) {
        super(shell, name, shortcut);
    }

    public AbstractSQLCommandSupport(Groovysh shell, String name, String shortcut, String desc, String usage, String help) {
        super(shell, name, shortcut, desc, usage, help);
    }

    protected Connection getConnectionFromSession(KnoxDataSource ds) {
        HashMap connections = this.getVariables().getOrDefault(KNOXDATASOURCE_CONNECTIONS, new HashMap());
        Connection conn = (Connection)connections.get(ds.getName());
        return conn;
    }

    protected Connection getConnection(KnoxDataSource ds, String user, String pass) throws SQLException, Exception {
        Connection conn = this.getConnectionFromSession(ds);
        if (conn == null) {
            conn = user != null && pass != null ? JDBCUtils.createConnection(ds.getConnectStr(), user, pass) : JDBCUtils.createConnection(ds.getConnectStr(), null, null);
            HashMap<String, Connection> connections = this.getVariables().getOrDefault(KNOXDATASOURCE_CONNECTIONS, new HashMap());
            connections.put(ds.getName(), conn);
            this.getVariables().put(KNOXDATASOURCE_CONNECTIONS, connections);
        }
        return conn;
    }

    protected void persistSQLHistory() {
        Map sqlHistories = (Map)this.getVariables().get("__knoxsqlhistory");
        KnoxSession.persistSQLHistory(sqlHistories);
    }

    protected void persistDataSources() {
        Map datasources = (Map)this.getVariables().get(KNOXDATASOURCES);
        KnoxSession.persistDataSources(datasources);
    }

    protected List<String> getSQLHistory(String dataSourceName) {
        List<String> sqlHistory = null;
        Map<String, List<String>> sqlHistories = (Map<String, List<String>>)this.getVariables().get("__knoxsqlhistory");
        if (sqlHistories == null && ((sqlHistories = this.loadSQLHistories()) == null || sqlHistories.isEmpty())) {
            sqlHistories = new HashMap<String, List<String>>();
            this.getVariables().put("__knoxsqlhistory", sqlHistories);
        }
        if ((sqlHistory = sqlHistories.get(dataSourceName)) == null) {
            sqlHistory = this.startSqlHistory(dataSourceName, sqlHistories);
        }
        return sqlHistory;
    }

    private List<String> startSqlHistory(String dataSourceName, Map<String, List<String>> sqlHistories) {
        ArrayList<String> sqlHistory = new ArrayList<String>();
        sqlHistories.put(dataSourceName, sqlHistory);
        return sqlHistory;
    }

    private Map<String, List<String>> loadSQLHistories() {
        Map<String, List<String>> sqlHistories = null;
        try {
            sqlHistories = KnoxSession.loadSQLHistories();
            if (sqlHistories != null) {
                this.getVariables().put("__knoxsqlhistory", sqlHistories);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sqlHistories;
    }

    private Map<String, KnoxDataSource> loadDataSources() {
        Map<String, KnoxDataSource> datasources = null;
        try {
            datasources = KnoxSession.loadDataSources();
            if (datasources != null) {
                this.getVariables().put(KNOXDATASOURCES, datasources);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return datasources;
    }

    protected void addToSQLHistory(String dsName, String sql) {
        List<String> sqlHistory = null;
        if (sql != null && !sql.isEmpty() && (sqlHistory = this.getSQLHistory(dsName)) != null) {
            sqlHistory.add(sql);
        }
        if (sqlHistory != null && sqlHistory.size() > 20) {
            sqlHistory.remove(0);
        }
        this.persistSQLHistory();
    }

    protected void addToSQLHistory(List<String> sqlHistory, String sql) {
        if (sql != null && !sql.isEmpty()) {
            sqlHistory.add(sql);
        }
        if (sqlHistory.size() > 20) {
            sqlHistory.remove(0);
        }
        this.persistSQLHistory();
    }

    protected void removeFromSQLHistory(String dsName) {
        Map sqlHistories = (Map)this.getVariables().get("__knoxsqlhistory");
        sqlHistories.remove(dsName);
        this.persistSQLHistory();
    }

    protected Map<String, KnoxDataSource> getDataSources() {
        Map<String, KnoxDataSource> datasources = (Map<String, KnoxDataSource>)this.getVariables().get(KNOXDATASOURCES);
        if (datasources == null) {
            datasources = this.loadDataSources();
            if (datasources != null) {
                this.getVariables().put(KNOXDATASOURCES, datasources);
            } else {
                datasources = new HashMap<String, KnoxDataSource>();
            }
        }
        return datasources;
    }

    public void closeConnections() {
        HashMap connections = this.getVariables().getOrDefault(KNOXDATASOURCE_CONNECTIONS, new HashMap());
        connections.values().forEach(connection -> {
            try {
                if (!connection.isClosed()) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        });
    }
}

