/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.intermediate;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.ldaptive.LdapUtils;
import org.ldaptive.asn1.AbstractParseHandler;
import org.ldaptive.asn1.BooleanType;
import org.ldaptive.asn1.DERParser;
import org.ldaptive.asn1.DERPath;
import org.ldaptive.asn1.OctetStringType;
import org.ldaptive.asn1.ParseHandler;
import org.ldaptive.asn1.UuidType;
import org.ldaptive.control.ResponseControl;
import org.ldaptive.intermediate.AbstractIntermediateResponse;

public class SyncInfoMessage
extends AbstractIntermediateResponse {
    public static final String OID = "1.3.6.1.4.1.4203.1.9.1.4";
    private static final int HASH_CODE_SEED = 761;
    private Type messageType;
    private byte[] cookie;
    private boolean refreshDone = true;
    private boolean refreshDeletes;
    private Set<UUID> entryUuids = new HashSet<UUID>();

    public SyncInfoMessage() {
        super(OID, null, -1);
    }

    public SyncInfoMessage(ResponseControl[] responseControls, int id) {
        super(OID, responseControls, id);
    }

    public Type getMessageType() {
        return this.messageType;
    }

    public void setMessageType(Type type) {
        this.messageType = type;
    }

    public byte[] getCookie() {
        return this.cookie;
    }

    public void setCookie(byte[] value) {
        this.cookie = value;
    }

    public boolean getRefreshDone() {
        return this.refreshDone;
    }

    public void setRefreshDone(boolean b) {
        this.refreshDone = b;
    }

    public boolean getRefreshDeletes() {
        return this.refreshDeletes;
    }

    public void setRefreshDeletes(boolean b) {
        this.refreshDeletes = b;
    }

    public Set<UUID> getEntryUuids() {
        return this.entryUuids;
    }

    public void setEntryUuids(Set<UUID> uuids) {
        this.entryUuids = uuids;
    }

    @Override
    public void decode(byte[] berValue) {
        DERParser parser = new DERParser();
        parser.registerHandler(NewCookieHandler.PATH, (ParseHandler)new NewCookieHandler(this));
        parser.registerHandler(RefreshDeleteHandler.PATH, (ParseHandler)new RefreshDeleteHandler(this));
        parser.registerHandler(RefreshDeleteCookieHandler.PATH, (ParseHandler)new RefreshDeleteCookieHandler(this));
        parser.registerHandler(RefreshDeleteDoneHandler.PATH, (ParseHandler)new RefreshDeleteDoneHandler(this));
        parser.registerHandler(RefreshPresentHandler.PATH, (ParseHandler)new RefreshPresentHandler(this));
        parser.registerHandler(RefreshPresentCookieHandler.PATH, (ParseHandler)new RefreshPresentCookieHandler(this));
        parser.registerHandler(RefreshPresentDoneHandler.PATH, (ParseHandler)new RefreshPresentDoneHandler(this));
        parser.registerHandler(SyncIdSetHandler.PATH, (ParseHandler)new SyncIdSetHandler(this));
        parser.registerHandler(SyncIdSetCookieHandler.PATH, (ParseHandler)new SyncIdSetCookieHandler(this));
        parser.registerHandler(SyncIdSetDeletesHandler.PATH, (ParseHandler)new SyncIdSetDeletesHandler(this));
        parser.registerHandler(SyncIdSetUuidsHandler.PATH, (ParseHandler)new SyncIdSetUuidsHandler(this));
        parser.parse(ByteBuffer.wrap(berValue));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SyncInfoMessage) {
            SyncInfoMessage v = (SyncInfoMessage)o;
            return LdapUtils.areEqual(this.getOID(), v.getOID()) && LdapUtils.areEqual((Object)this.messageType, (Object)v.messageType) && LdapUtils.areEqual(this.cookie, v.cookie) && LdapUtils.areEqual(this.refreshDone, v.refreshDone) && LdapUtils.areEqual(this.refreshDeletes, v.refreshDeletes) && LdapUtils.areEqual(this.entryUuids, v.entryUuids) && LdapUtils.areEqual(this.getControls(), v.getControls()) && LdapUtils.areEqual(this.getMessageId(), v.getMessageId());
        }
        return false;
    }

    public int hashCode() {
        return LdapUtils.computeHashCode(761, new Object[]{this.getOID(), this.messageType, this.cookie, this.refreshDone, this.refreshDeletes, this.entryUuids, this.getControls(), this.getMessageId()});
    }

    public String toString() {
        return String.format("[%s@%d::messageType=%s, cookie=%s, refreshDone=%s, refreshDeletes=%s, entryUuids=%s, responseControls=%s, messageId=%s]", new Object[]{this.getClass().getName(), this.hashCode(), this.messageType, LdapUtils.base64Encode(this.cookie), this.refreshDone, this.refreshDeletes, this.entryUuids, Arrays.toString(this.getControls()), this.getMessageId()});
    }

    private static class SyncIdSetUuidsHandler
    extends AbstractParseHandler<SyncInfoMessage> {
        public static final DERPath PATH = new DERPath("/CTX(3)/SET/OCTSTR");

        public SyncIdSetUuidsHandler(SyncInfoMessage message) {
            super(message);
        }

        @Override
        public void handle(DERParser parser, ByteBuffer encoded) {
            ((SyncInfoMessage)this.getObject()).getEntryUuids().add(UuidType.decode(encoded));
        }
    }

    private static class SyncIdSetDeletesHandler
    extends AbstractParseHandler<SyncInfoMessage> {
        public static final DERPath PATH = new DERPath("/CTX(3)/BOOL");

        public SyncIdSetDeletesHandler(SyncInfoMessage message) {
            super(message);
        }

        @Override
        public void handle(DERParser parser, ByteBuffer encoded) {
            ((SyncInfoMessage)this.getObject()).setRefreshDeletes(BooleanType.decode(encoded));
        }
    }

    private static class SyncIdSetCookieHandler
    extends AbstractParseHandler<SyncInfoMessage> {
        public static final DERPath PATH = new DERPath("/CTX(3)/OCTSTR");

        public SyncIdSetCookieHandler(SyncInfoMessage message) {
            super(message);
        }

        @Override
        public void handle(DERParser parser, ByteBuffer encoded) {
            byte[] cookie = OctetStringType.readBuffer(encoded);
            if (cookie != null && cookie.length > 0) {
                ((SyncInfoMessage)this.getObject()).setCookie(cookie);
            }
        }
    }

    private static class SyncIdSetHandler
    extends AbstractParseHandler<SyncInfoMessage> {
        public static final DERPath PATH = new DERPath("/CTX(3)");

        public SyncIdSetHandler(SyncInfoMessage message) {
            super(message);
        }

        @Override
        public void handle(DERParser parser, ByteBuffer encoded) {
            ((SyncInfoMessage)this.getObject()).setMessageType(Type.SYNC_ID_SET);
        }
    }

    private static class RefreshPresentDoneHandler
    extends AbstractParseHandler<SyncInfoMessage> {
        public static final DERPath PATH = new DERPath("/CTX(2)/BOOL");

        public RefreshPresentDoneHandler(SyncInfoMessage message) {
            super(message);
        }

        @Override
        public void handle(DERParser parser, ByteBuffer encoded) {
            ((SyncInfoMessage)this.getObject()).setRefreshDone(BooleanType.decode(encoded));
        }
    }

    private static class RefreshPresentCookieHandler
    extends AbstractParseHandler<SyncInfoMessage> {
        public static final DERPath PATH = new DERPath("/CTX(2)/OCTSTR");

        public RefreshPresentCookieHandler(SyncInfoMessage message) {
            super(message);
        }

        @Override
        public void handle(DERParser parser, ByteBuffer encoded) {
            byte[] cookie = OctetStringType.readBuffer(encoded);
            if (cookie != null && cookie.length > 0) {
                ((SyncInfoMessage)this.getObject()).setCookie(cookie);
            }
        }
    }

    private static class RefreshPresentHandler
    extends AbstractParseHandler<SyncInfoMessage> {
        public static final DERPath PATH = new DERPath("/CTX(2)");

        public RefreshPresentHandler(SyncInfoMessage message) {
            super(message);
        }

        @Override
        public void handle(DERParser parser, ByteBuffer encoded) {
            ((SyncInfoMessage)this.getObject()).setMessageType(Type.REFRESH_PRESENT);
        }
    }

    private static class RefreshDeleteDoneHandler
    extends AbstractParseHandler<SyncInfoMessage> {
        public static final DERPath PATH = new DERPath("/CTX(1)/BOOL");

        public RefreshDeleteDoneHandler(SyncInfoMessage message) {
            super(message);
        }

        @Override
        public void handle(DERParser parser, ByteBuffer encoded) {
            ((SyncInfoMessage)this.getObject()).setRefreshDone(BooleanType.decode(encoded));
        }
    }

    private static class RefreshDeleteCookieHandler
    extends AbstractParseHandler<SyncInfoMessage> {
        public static final DERPath PATH = new DERPath("/CTX(1)/OCTSTR");

        public RefreshDeleteCookieHandler(SyncInfoMessage message) {
            super(message);
        }

        @Override
        public void handle(DERParser parser, ByteBuffer encoded) {
            byte[] cookie = OctetStringType.readBuffer(encoded);
            if (cookie != null && cookie.length > 0) {
                ((SyncInfoMessage)this.getObject()).setCookie(cookie);
            }
        }
    }

    private static class RefreshDeleteHandler
    extends AbstractParseHandler<SyncInfoMessage> {
        public static final DERPath PATH = new DERPath("/CTX(1)");

        public RefreshDeleteHandler(SyncInfoMessage message) {
            super(message);
        }

        @Override
        public void handle(DERParser parser, ByteBuffer encoded) {
            ((SyncInfoMessage)this.getObject()).setMessageType(Type.REFRESH_DELETE);
        }
    }

    private static class NewCookieHandler
    extends AbstractParseHandler<SyncInfoMessage> {
        public static final DERPath PATH = new DERPath("/CTX(0)");

        public NewCookieHandler(SyncInfoMessage message) {
            super(message);
        }

        @Override
        public void handle(DERParser parser, ByteBuffer encoded) {
            ((SyncInfoMessage)this.getObject()).setMessageType(Type.NEW_COOKIE);
            byte[] cookie = OctetStringType.readBuffer(encoded);
            if (cookie != null && cookie.length > 0) {
                ((SyncInfoMessage)this.getObject()).setCookie(cookie);
            }
        }
    }

    public static enum Type {
        NEW_COOKIE,
        REFRESH_DELETE,
        REFRESH_PRESENT,
        SYNC_ID_SET;

    }
}

