/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Arguments for transforming HDFS Ranger service policies to Amazon S3 policies. <p> Note that it's relevant only if any of the Ranger services to be replicated contain HDFS Ranger service type and replication will be done from on-prem to S3.")
public class ApiRangerReplicationHdfsToS3Args {
    @SerializedName(value="s3BucketName")
    private String s3BucketName = null;

    public ApiRangerReplicationHdfsToS3Args s3BucketName(String s3BucketName) {
        this.s3BucketName = s3BucketName;
        return this;
    }

    @Schema(description="Amazon S3 bucket name for Ranger HDFS policies which need to be transformed to S3 policy.")
    public String getS3BucketName() {
        return this.s3BucketName;
    }

    public void setS3BucketName(String s3BucketName) {
        this.s3BucketName = s3BucketName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiRangerReplicationHdfsToS3Args apiRangerReplicationHdfsToS3Args = (ApiRangerReplicationHdfsToS3Args)o;
        return Objects.equals(this.s3BucketName, apiRangerReplicationHdfsToS3Args.s3BucketName);
    }

    public int hashCode() {
        return Objects.hash(this.s3BucketName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiRangerReplicationHdfsToS3Args {\n");
        sb.append("    s3BucketName: ").append(this.toIndentedString(this.s3BucketName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

