/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.factory;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.service.config.remote.RemoteConfigurationRegistryClientServiceFactory;
import org.apache.knox.gateway.service.config.remote.zk.ZooKeeperClientService;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.Service;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.config.client.RemoteConfigurationRegistryClientService;
import org.apache.knox.gateway.services.factory.AbstractServiceFactory;
import org.apache.knox.gateway.services.factory.AliasServiceFactory;
import org.apache.knox.gateway.services.security.AliasService;

public class RemoteRegistryClientServiceFactory
extends AbstractServiceFactory {
    private final AliasServiceFactory aliasServiceFactory = new AliasServiceFactory();

    @Override
    protected Service createService(GatewayServices gatewayServices, ServiceType serviceType, GatewayConfig gatewayConfig, Map<String, String> options, String implementation) throws ServiceLifecycleException {
        RemoteConfigurationRegistryClientService service = null;
        if (this.shouldCreateService(implementation)) {
            service = RemoteConfigurationRegistryClientServiceFactory.newInstance((GatewayConfig)gatewayConfig);
            AliasService localAliasService = (AliasService)this.aliasServiceFactory.create(gatewayServices, ServiceType.ALIAS_SERVICE, gatewayConfig, options, "");
            localAliasService.init(gatewayConfig, options);
            service.setAliasService(localAliasService);
        }
        return service;
    }

    @Override
    protected ServiceType getServiceType() {
        return ServiceType.REMOTE_REGISTRY_CLIENT_SERVICE;
    }

    @Override
    protected Collection<String> getKnownImplementations() {
        return Collections.singleton(ZooKeeperClientService.class.getName());
    }
}

