/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.part;

import java.lang.reflect.Constructor;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.ClassInfoTyped;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.annotation.FormData;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.annotation.Path;
import org.apache.juneau.http.annotation.Query;
import org.apache.juneau.httppart.HttpPartSchema;

public class PartBeanMeta<T> {
    private static final ConcurrentHashMap<Class<?>, PartBeanMeta<?>> CACHE = new ConcurrentHashMap();
    private final Class<T> type;
    private final Constructor<T> constructor;
    private final HttpPartSchema schema;

    public static <T> PartBeanMeta<T> of(Class<T> type) {
        PartBeanMeta<Object> m = CACHE.get(type);
        if (m == null) {
            m = new PartBeanMeta<T>(type);
            CACHE.put(type, m);
        }
        return m;
    }

    private PartBeanMeta(Class<T> type) {
        this.type = type;
        ClassInfoTyped ci = ClassInfo.of(type);
        this.constructor = ci.getPublicConstructor(x -> x.hasParameterTypes(String.class)).or(() -> ci.getPublicConstructor(x -> x.hasParameterTypes(Object.class))).or(() -> ci.getPublicConstructor(x -> x.hasParameterTypes(String.class, String.class))).or(() -> ci.getPublicConstructor(x -> x.hasParameterTypes(String.class, Object.class))).map(x -> x.inner()).orElse(null);
        this.schema = ci.hasAnnotation(Query.class) ? HttpPartSchema.create(Query.class, type) : (ci.hasAnnotation(FormData.class) ? HttpPartSchema.create(FormData.class, type) : (ci.hasAnnotation(Path.class) ? HttpPartSchema.create(Path.class, type) : HttpPartSchema.create(Header.class, type)));
    }

    public T construct(Object value) {
        return this.construct(null, value);
    }

    public T construct(String name, Object value) {
        if (this.constructor == null) {
            throw ThrowableUtils.unsupportedOp("Constructor for type {0} could not be found.", Utils.cn(this.type));
        }
        if (name == null) {
            name = this.schema.getName();
        }
        Class<?>[] pt = this.constructor.getParameterTypes();
        Object[] args = new Object[pt.length];
        if (pt.length == 1) {
            args[0] = pt[0] == String.class ? Utils.s(value) : value;
        } else {
            if (name == null) {
                throw ThrowableUtils.unsupportedOp("Constructor for type {0} requires a name as the first argument.", Utils.cn(this.type));
            }
            args[0] = name;
            args[1] = pt[1] == String.class ? Utils.s(value) : value;
        }
        try {
            return this.constructor.newInstance(args);
        }
        catch (Exception e) {
            throw ThrowableUtils.toRex(e);
        }
    }

    public HttpPartSchema getSchema() {
        return this.schema;
    }
}

