/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rfc3986;

import org.apache.jena.rfc3986.Chars3986;
import org.apache.jena.rfc3986.LibParseIRI;
import org.apache.jena.rfc3986.ParseErrorIRI3986;
import org.apache.jena.rfc3986.ParseIPv4Address;

public class ParseIPv6Address {
    public static void checkIPv6(CharSequence string) {
        ParseIPv6Address.checkIPv6(string, 0, string.length());
    }

    public static void checkIPv6(CharSequence string, int start, int end) {
        int length = string.length();
        if (start < 0 || end < 0 || end > length) {
            throw new IllegalArgumentException();
        }
        if (length == 0 || start >= end) {
            throw ParseErrorIRI3986.parseError(string, "Empty IPv6 address");
        }
        ParseIPv6Address.parseIPv6(string, start, end);
    }

    private static int parseIPv6(CharSequence string, int start, int end) {
        if (Chars3986.charAt(string, start) != '[' || Chars3986.charAt(string, end - 1) != ']') {
            throw ParseErrorIRI3986.parseError(string, "IPv6 (or later) address not properly delimited");
        }
        if (Chars3986.charAt(string, start + 1) == 'v') {
            return ParseIPv6Address.parseIPFuture(string, start + 2, end - 1);
        }
        int idx = ParseIPv6Address.parseIPv6Sub(string, start + 1, end - 1);
        if ((idx = ParseIPv6Address.parseIPv6OptionalZone(string, idx, end - 1)) != end - 1) {
            throw ParseErrorIRI3986.parseError(string, "Bad end of IPv6X address");
        }
        return idx;
    }

    private static int parseIPv6OptionalZone(CharSequence string, int idx, int end) {
        if (idx >= end) {
            return idx;
        }
        char chPercent = string.charAt(idx);
        if (chPercent == '%') {
            int zIdx;
            if (idx + 3 >= end) {
                throw ParseErrorIRI3986.parseError(string, "Bad IPv6 zone id");
            }
            char ch1 = string.charAt(idx + 1);
            char ch2 = string.charAt(idx + 2);
            if (ch1 != '2' || ch2 != '5') {
                throw ParseErrorIRI3986.parseError(string, "Bad IPv6 zone id (must be '%25...'");
            }
            for (zIdx = idx += 3; zIdx < end; ++zIdx) {
                char ch = string.charAt(zIdx);
                if (Chars3986.unreserved(ch) || Chars3986.isPctEncoded(ch, string, zIdx)) continue;
                throw ParseErrorIRI3986.parseError(string, "Bad character in IPv6 zone id");
            }
            if (zIdx - idx < 1) {
                throw ParseErrorIRI3986.parseError(string, "No IPv6 zone id after '%25'");
            }
            idx = zIdx;
        }
        return idx;
    }

    private static int parseIPFuture(CharSequence string, int start, int end) {
        int p = start;
        if (p >= end) {
            throw ParseErrorIRI3986.parseError(string, "Short IPFuture");
        }
        char ch = string.charAt(p);
        if (!Chars3986.isHexDigit(ch)) {
            throw ParseErrorIRI3986.parseError(string, "IPFuture: no version hexdigit");
        }
        if ((ch = string.charAt(++p)) != '.') {
            throw ParseErrorIRI3986.parseError(string, "IPFuture: no dot after version hexdigit");
        }
        ++p;
        while (p < end && (ch = string.charAt(p)) != ']' && (Chars3986.unreserved(ch) || Chars3986.subDelims(ch) || ch == ':')) {
            ++p;
        }
        if (p != end) {
            throw ParseErrorIRI3986.parseError(string, "IPFuture: extra ']'");
        }
        return p;
    }

    private static int parseIPv6Sub(CharSequence string, int start, int end) {
        char ch;
        int z;
        int x;
        int p = start;
        int h16c1 = -1;
        int h16c2 = -1;
        int h16c = 0;
        boolean b = LibParseIRI.peekFor(string, p, ':', ':');
        if (b) {
            h16c1 = h16c;
            h16c = 0;
            p += 2;
        }
        while ((x = ParseIPv6Address.ipv6_h16(string, p, end)) != p && x < end) {
            ++h16c;
            char ch2 = Chars3986.charAt(string, x);
            if (ch2 == ':') {
                h16c1 = h16c;
                h16c = 0;
            }
            p = ++x;
        }
        if (h16c1 >= 0) {
            h16c2 = h16c;
        } else {
            h16c1 = h16c;
        }
        boolean IPv4 = false;
        for (int i = 0; i < 4 && (z = p + i) < end && !Chars3986.range(ch = Chars3986.charAt(string, z), 97, 102) && !Chars3986.range(ch, 65, 70); ++i) {
            if (ch != '.') continue;
            IPv4 = true;
            break;
        }
        if (IPv4) {
            if (h16c2 == -1) {
                if (h16c1 != 6) {
                    throw ParseErrorIRI3986.parseError(string, "Malformed IPv6 address with IPv4 part [case 1]");
                }
            } else if (h16c1 + h16c2 > 4) {
                throw ParseErrorIRI3986.parseError(string, "Malformed IPv6 address with IPv4 part [case 2]");
            }
            p = x = ParseIPv6Address.ipv4(string, p, end);
        } else {
            if (h16c2 == -1) {
                if (h16c1 != 7) {
                    throw ParseErrorIRI3986.parseError(string, "Malformed IPv6 address [case 1]");
                }
            } else if (h16c2 == 0) {
                if (h16c1 > 6) {
                    throw ParseErrorIRI3986.parseError(string, "Malformed IPv6 address [case 2]");
                }
            } else if (h16c1 + h16c2 > 5) {
                throw ParseErrorIRI3986.parseError(string, "Malformed IPv6 address [case 3]");
            }
            p = x = ParseIPv6Address.ipv6_hex4(string, p, end);
        }
        return p;
    }

    private static int ipv6_h16(CharSequence string, int start, int end) {
        int p = start;
        int x = ParseIPv6Address.ipv6_hex4(string, p, end);
        if (x < 0) {
            throw ParseErrorIRI3986.parseError(string, "hex4 error at " + p);
        }
        if (x == p) {
            return p;
        }
        if (x >= end) {
            return p;
        }
        char ch1 = string.charAt(x);
        if (ch1 != ':') {
            return p;
        }
        p = ++x;
        return p;
    }

    private static int ipv6_hex4(CharSequence string, int start, int end) {
        int p = start;
        for (int i = 0; i < 4; ++i) {
            if (p + i >= end) {
                return p + i;
            }
            char ch = Chars3986.charAt(string, p + i);
            if (Chars3986.isHexDigit(ch)) continue;
            return p + i;
        }
        return p + 4;
    }

    private static int ipv4(CharSequence string, int start, int end) {
        return ParseIPv4Address.ipv4(string, start, end);
    }
}

