/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.cassandra;

import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import org.apache.james.backends.cassandra.components.CassandraDataDefinition;

public interface CassandraMailRepositoryDataDefinition {
    public static final CassandraDataDefinition MODULE = CassandraDataDefinition.builder().type("header").statement(statement -> statement.withField("headerName", DataTypes.TEXT).withField("headerValue", DataTypes.TEXT)).table("mailRepositoryKeys").comment("Per-mailRepository mail key list").statement(statement -> types -> statement.withPartitionKey("name", DataTypes.TEXT).withClusteringColumn("mailKey", DataTypes.TEXT)).table("mailRepositoryContentV2").comment("Stores the mails for a given repository. Content is stored with other blobs. This v2 version was introduced to support multiple headers for each user. The attributes are store as Json introduced in Mailet API v3.2.").statement(statement -> types -> statement.withPartitionKey("name", DataTypes.TEXT).withPartitionKey("mailKey", DataTypes.TEXT).withColumn("messageSize", DataTypes.BIGINT).withColumn("state", DataTypes.TEXT).withColumn("headerBlobId", DataTypes.TEXT).withColumn("bodyBlobId", DataTypes.TEXT).withColumn("attributes", (DataType)DataTypes.mapOf((DataType)DataTypes.TEXT, (DataType)DataTypes.TEXT)).withColumn("errorMessage", DataTypes.TEXT).withColumn("sender", DataTypes.TEXT).withColumn("recipients", (DataType)DataTypes.listOf((DataType)DataTypes.TEXT)).withColumn("remoteHost", DataTypes.TEXT).withColumn("remoteAddr", DataTypes.TEXT).withColumn("lastUpdated", DataTypes.TIMESTAMP).withColumn("perRecipientSpecificHeaders", (DataType)DataTypes.listOf((DataType)DataTypes.tupleOf((DataType[])new DataType[]{DataTypes.TEXT, DataTypes.TEXT, DataTypes.TEXT})))).build();
}

