/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.util;

import com.github.f4b6a3.uuid.util.UuidUtil;
import com.github.f4b6a3.uuid.util.internal.ByteUtil;
import com.github.f4b6a3.uuid.util.internal.NetworkUtil;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.UUID;

public final class MachineId {
    private static Long id;
    private static UUID uuid;
    private static String hexa;
    private static byte[] hash;
    private static String string;

    private MachineId() {
    }

    public static long getMachineId() {
        if (id == null) {
            id = MachineId.getMachineId(MachineId.getMachineHash());
        }
        return id;
    }

    static long getMachineId(byte[] hash) {
        return ByteUtil.toNumber(hash, 0, 8);
    }

    public static UUID getMachineUuid() {
        if (uuid == null) {
            uuid = MachineId.getMachineUuid(MachineId.getMachineHash());
        }
        return uuid;
    }

    static UUID getMachineUuid(byte[] hash) {
        long mostSigBits = ByteUtil.toNumber(hash, 0, 8);
        long leastSigBits = ByteUtil.toNumber(hash, 8, 16);
        return UuidUtil.setVersion(new UUID(mostSigBits, leastSigBits), 4);
    }

    public static String getMachineHexa() {
        if (hexa == null) {
            hexa = MachineId.getMachineHexa(MachineId.getMachineHash());
        }
        return hexa;
    }

    static String getMachineHexa(byte[] hash) {
        return ByteUtil.toHexadecimal(hash);
    }

    public static byte[] getMachineHash() {
        if (hash == null) {
            hash = MachineId.getMachineHash(MachineId.getMachineString());
        }
        return Arrays.copyOf(hash, hash.length);
    }

    static byte[] getMachineHash(String string) {
        try {
            return MessageDigest.getInstance("SHA-256").digest(string.getBytes(StandardCharsets.UTF_8));
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalError("Message digest algorithm not supported.", e);
        }
    }

    public static String getMachineString() {
        if (string == null) {
            string = NetworkUtil.getMachineString();
        }
        return string;
    }
}

