/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.extractor;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.james.mailbox.extractor.ParsedContent;
import org.apache.james.mailbox.extractor.TextExtractor;
import org.apache.james.mailbox.model.ContentType;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class JsoupTextExtractor
implements TextExtractor {
    private static final String TITLE_HTML_TAG = "title";
    private static final String NO_BASE_URI = "";
    private static final ContentType.MimeType TEXT_HTML = ContentType.MimeType.of((String)"text/html");
    private static final ContentType.MimeType TEXT_PLAIN = ContentType.MimeType.of((String)"text/plain");

    public boolean applicable(ContentType contentType) {
        if (contentType == null) {
            return false;
        }
        return contentType.mimeType().equals((Object)TEXT_HTML) || contentType.mimeType().equals((Object)TEXT_PLAIN);
    }

    public ParsedContent extractContent(InputStream inputStream, ContentType contentType) throws Exception {
        if (inputStream == null || contentType == null) {
            return ParsedContent.empty();
        }
        Charset charset = contentType.charset().orElse(StandardCharsets.UTF_8);
        if (contentType.mimeType().equals((Object)TEXT_HTML)) {
            return this.parseHtmlContent(inputStream, charset);
        }
        if (contentType.mimeType().equals((Object)TEXT_PLAIN)) {
            return this.parsePlainTextContent(inputStream, charset);
        }
        return ParsedContent.empty();
    }

    public Mono<ParsedContent> extractContentReactive(InputStream inputStream, ContentType contentType) {
        if (inputStream == null || contentType == null) {
            return Mono.just((Object)ParsedContent.empty());
        }
        Charset charset = contentType.charset().orElse(StandardCharsets.UTF_8);
        if (contentType.mimeType().equals((Object)TEXT_HTML)) {
            return Mono.fromCallable(() -> this.parseHtmlContent(inputStream, charset)).subscribeOn(Schedulers.boundedElastic());
        }
        if (contentType.mimeType().equals((Object)TEXT_PLAIN)) {
            return Mono.fromCallable(() -> this.parsePlainTextContent(inputStream, charset)).subscribeOn(Schedulers.boundedElastic());
        }
        return Mono.just((Object)ParsedContent.empty());
    }

    private ParsedContent parsePlainTextContent(InputStream inputStream, Charset charset) throws IOException {
        return ParsedContent.of((String)IOUtils.toString((InputStream)inputStream, (Charset)charset));
    }

    private ParsedContent parseHtmlContent(InputStream inputStream, Charset charset) throws IOException {
        Document doc = Jsoup.parse((InputStream)inputStream, (String)charset.name(), (String)NO_BASE_URI);
        doc.select(TITLE_HTML_TAG).remove();
        return ParsedContent.of((String)doc.text());
    }
}

