/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailet;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import org.apache.james.core.MailAddress;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;

public class LoopPrevention {
    public static final AttributeName RECORDED_RECIPIENTS_ATTRIBUTE_NAME = AttributeName.of("loop.prevention.recorded.recipients");

    public static class RecordedRecipients {
        public static final RecordedRecipients NO_RECORDED_RECIPIENTS = new RecordedRecipients(ImmutableSet.of());
        private final Set<MailAddress> recipients;

        public static RecordedRecipients fromMail(Mail mail) {
            return mail.getAttribute(RECORDED_RECIPIENTS_ATTRIBUTE_NAME).map(RecordedRecipients::fromAttribute).orElse(NO_RECORDED_RECIPIENTS);
        }

        public static RecordedRecipients fromAttribute(Attribute attribute) {
            Collection attributeValues = (Collection)attribute.getValue().getValue();
            return new RecordedRecipients(attributeValues.stream().map(Throwing.function(attributeValue -> new MailAddress((String)attributeValue.getValue()))).collect(ImmutableSet.toImmutableSet()));
        }

        public RecordedRecipients(Set<MailAddress> recipients) {
            this.recipients = recipients;
        }

        public RecordedRecipients(MailAddress ... recipients) {
            this.recipients = ImmutableSet.copyOf(recipients);
        }

        public Set<MailAddress> getRecipients() {
            return this.recipients;
        }

        public Set<MailAddress> nonRecordedRecipients(Collection<MailAddress> recipients) {
            return Sets.difference(ImmutableSet.copyOf(recipients), this.recipients);
        }

        public Set<MailAddress> nonRecordedRecipients(MailAddress ... recipients) {
            return Sets.difference(ImmutableSet.copyOf(recipients), this.recipients);
        }

        public RecordedRecipients merge(RecordedRecipients other) {
            return new RecordedRecipients((Set<MailAddress>)((Object)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(this.recipients)).addAll(other.recipients)).build()));
        }

        public RecordedRecipients merge(Collection<MailAddress> other) {
            return this.merge(new RecordedRecipients(ImmutableSet.copyOf(other)));
        }

        public RecordedRecipients merge(MailAddress ... other) {
            return this.merge(ImmutableSet.copyOf(other));
        }

        public RecordedRecipients mergeIfEmpty(MailAddress ... other) {
            if (this.recipients.isEmpty()) {
                return this.merge(ImmutableSet.copyOf(other));
            }
            return this;
        }

        public Attribute asAttribute() {
            return new Attribute(RECORDED_RECIPIENTS_ATTRIBUTE_NAME, AttributeValue.of(this.recipients.stream().map(mailAddress -> AttributeValue.of(mailAddress.asString())).collect(ImmutableList.toImmutableList())));
        }

        public void recordOn(Mail mail) {
            mail.setAttribute(this.asAttribute());
        }
    }
}

