/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class SortItem
extends Node {
    private final Expression sortKey;
    private final Ordering ordering;
    private final NullOrdering nullOrdering;

    public SortItem(Expression sortKey, Ordering ordering, NullOrdering nullOrdering) {
        super(null);
        this.ordering = ordering;
        this.sortKey = sortKey;
        this.nullOrdering = nullOrdering;
    }

    public SortItem(NodeLocation location, Expression sortKey, Ordering ordering, NullOrdering nullOrdering) {
        super(Objects.requireNonNull(location, "location is null"));
        this.ordering = ordering;
        this.sortKey = sortKey;
        this.nullOrdering = nullOrdering;
    }

    public Expression getSortKey() {
        return this.sortKey;
    }

    public Ordering getOrdering() {
        return this.ordering;
    }

    public NullOrdering getNullOrdering() {
        return this.nullOrdering;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSortItem(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.sortKey);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sortKey", (Object)this.sortKey).add("ordering", (Object)this.ordering).add("nullOrdering", (Object)this.nullOrdering).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SortItem sortItem = (SortItem)o;
        return Objects.equals(this.sortKey, sortItem.sortKey) && this.ordering == sortItem.ordering && this.nullOrdering == sortItem.nullOrdering;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.sortKey, this.ordering, this.nullOrdering});
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!SortItem.sameClass(this, other)) {
            return false;
        }
        SortItem otherItem = (SortItem)other;
        return this.ordering == otherItem.ordering && this.nullOrdering == otherItem.nullOrdering;
    }

    void serialize(ByteBuffer buffer) {
        Expression.serialize(this.sortKey, buffer);
        ReadWriteIOUtils.write((byte)((byte)this.ordering.ordinal()), (ByteBuffer)buffer);
        ReadWriteIOUtils.write((byte)((byte)this.nullOrdering.ordinal()), (ByteBuffer)buffer);
    }

    void serialize(DataOutputStream stream) throws IOException {
        Expression.serialize(this.sortKey, stream);
        ReadWriteIOUtils.write((byte)((byte)this.ordering.ordinal()), (OutputStream)stream);
        ReadWriteIOUtils.write((byte)((byte)this.nullOrdering.ordinal()), (OutputStream)stream);
    }

    public SortItem(ByteBuffer byteBuffer) {
        super(null);
        this.sortKey = Expression.deserialize(byteBuffer);
        this.ordering = Ordering.values()[ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer)];
        this.nullOrdering = NullOrdering.values()[ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer)];
    }

    public static enum Ordering {
        ASCENDING,
        DESCENDING;

    }

    public static enum NullOrdering {
        FIRST,
        LAST,
        UNDEFINED;

    }
}

