/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.window.function.value;

import org.apache.iotdb.db.queryengine.execution.operator.process.window.function.value.ValueWindowFunction;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.partition.Partition;
import org.apache.tsfile.block.column.ColumnBuilder;

public class FirstValueFunction
extends ValueWindowFunction {
    private final int channel;
    private final boolean ignoreNull;

    public FirstValueFunction(int channel, boolean ignoreNull) {
        this.channel = channel;
        this.ignoreNull = ignoreNull;
    }

    @Override
    public void transform(Partition partition, ColumnBuilder builder, int index, int frameStart, int frameEnd) {
        if (frameStart < 0) {
            builder.appendNull();
            return;
        }
        if (this.ignoreNull) {
            int pos;
            for (pos = frameStart; pos <= frameEnd && partition.isNull(this.channel, pos); ++pos) {
            }
            if (pos > frameEnd) {
                builder.appendNull();
            } else {
                partition.writeTo(builder, this.channel, pos);
            }
        } else if (partition.isNull(this.channel, frameStart)) {
            builder.appendNull();
        } else {
            partition.writeTo(builder, this.channel, frameStart);
        }
    }
}

