/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.NodeRef;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.Metadata;
import org.apache.iotdb.db.queryengine.plan.relational.planner.ir.ExpressionRewriter;
import org.apache.iotdb.db.queryengine.plan.relational.planner.ir.ExpressionTreeRewriter;
import org.apache.iotdb.db.queryengine.plan.relational.planner.ir.IrUtils;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ComparisonExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LogicalExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NotExpression;
import org.apache.tsfile.read.common.type.DoubleType;
import org.apache.tsfile.read.common.type.FloatType;
import org.apache.tsfile.read.common.type.Type;

public final class PushDownNegationsExpressionRewriter {
    public static Expression pushDownNegations(Metadata metadata, Expression expression, Map<NodeRef<Expression>, Type> expressionTypes) {
        return ExpressionTreeRewriter.rewriteWith(new Visitor(metadata, expressionTypes), expression);
    }

    private PushDownNegationsExpressionRewriter() {
    }

    private static class Visitor
    extends ExpressionRewriter<Void> {
        private final Metadata metadata;
        private final Map<NodeRef<Expression>, Type> expressionTypes;

        public Visitor(Metadata metadata, Map<NodeRef<Expression>, Type> expressionTypes) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.expressionTypes = ImmutableMap.copyOf(Objects.requireNonNull(expressionTypes, "expressionTypes is null"));
        }

        @Override
        public Expression rewriteNotExpression(NotExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            if (node.getValue() instanceof LogicalExpression) {
                LogicalExpression child = (LogicalExpression)node.getValue();
                List<Expression> predicates = IrUtils.extractPredicates(child);
                List negatedPredicates = (List)predicates.stream().map(predicate -> treeRewriter.rewrite(new NotExpression((Expression)predicate), context)).collect(ImmutableList.toImmutableList());
                return IrUtils.combinePredicates(child.getOperator().flip(), negatedPredicates);
            }
            if (node.getValue() instanceof ComparisonExpression && ((ComparisonExpression)node.getValue()).getOperator() != ComparisonExpression.Operator.IS_DISTINCT_FROM) {
                ComparisonExpression child = (ComparisonExpression)node.getValue();
                ComparisonExpression.Operator operator = child.getOperator();
                Expression left = child.getLeft();
                Expression right = child.getRight();
                Type leftType = this.expressionTypes.get(NodeRef.of(left));
                Type rightType = this.expressionTypes.get(NodeRef.of(right));
                Preconditions.checkState((leftType != null && rightType != null ? 1 : 0) != 0, (Object)"missing type for expression");
                if ((this.typeHasNaN(leftType) || this.typeHasNaN(rightType)) && (operator == ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL || operator == ComparisonExpression.Operator.GREATER_THAN || operator == ComparisonExpression.Operator.LESS_THAN_OR_EQUAL || operator == ComparisonExpression.Operator.LESS_THAN)) {
                    return new NotExpression(new ComparisonExpression(operator, treeRewriter.rewrite(left, context), treeRewriter.rewrite(right, context)));
                }
                return new ComparisonExpression(operator.negate(), treeRewriter.rewrite(left, context), treeRewriter.rewrite(right, context));
            }
            if (node.getValue() instanceof NotExpression) {
                NotExpression child = (NotExpression)node.getValue();
                return treeRewriter.rewrite(child.getValue(), context);
            }
            return new NotExpression(treeRewriter.rewrite(node.getValue(), context));
        }

        private boolean typeHasNaN(Type type) {
            return type instanceof DoubleType || type instanceof FloatType;
        }
    }
}

