/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.config;

import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.ConfigType;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.config.filter.impl.ConfigFilterChainManager;
import com.alibaba.nacos.client.config.filter.impl.ConfigRequest;
import com.alibaba.nacos.client.config.filter.impl.ConfigResponse;
import com.alibaba.nacos.client.config.http.HttpAgent;
import com.alibaba.nacos.client.config.http.MetricsHttpAgent;
import com.alibaba.nacos.client.config.http.ServerHttpAgent;
import com.alibaba.nacos.client.config.impl.ClientWorker;
import com.alibaba.nacos.client.config.impl.LocalConfigInfoProcessor;
import com.alibaba.nacos.client.config.impl.LocalEncryptedDataKeyProcessor;
import com.alibaba.nacos.client.config.utils.ContentUtils;
import com.alibaba.nacos.client.config.utils.ParamUtils;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.client.utils.ParamUtil;
import com.alibaba.nacos.client.utils.ValidatorUtils;
import com.alibaba.nacos.common.http.HttpRestResult;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import org.slf4j.Logger;

public class NacosConfigService
implements ConfigService {
    private static final Logger LOGGER = LogUtils.logger(NacosConfigService.class);
    private static final long POST_TIMEOUT = 3000L;
    private final HttpAgent agent;
    private final ClientWorker worker;
    private String namespace;
    private final String encode;
    private final ConfigFilterChainManager configFilterChainManager;

    public NacosConfigService(Properties properties) throws NacosException {
        ValidatorUtils.checkInitParam(properties);
        String encodeTmp = properties.getProperty("encode");
        this.encode = StringUtils.isBlank((String)encodeTmp) ? "UTF-8" : encodeTmp.trim();
        this.initNamespace(properties);
        this.configFilterChainManager = new ConfigFilterChainManager(properties);
        this.agent = new MetricsHttpAgent(new ServerHttpAgent(properties));
        this.agent.start();
        this.worker = new ClientWorker(this.agent, this.configFilterChainManager, properties);
    }

    private void initNamespace(Properties properties) {
        this.namespace = ParamUtil.parseNamespace(properties);
        properties.put("namespace", this.namespace);
    }

    public String getConfig(String dataId, String group, long timeoutMs) throws NacosException {
        return this.getConfigInner(this.namespace, dataId, group, timeoutMs);
    }

    public String getConfigAndSignListener(String dataId, String group, long timeoutMs, Listener listener) throws NacosException {
        String content = this.getConfig(dataId, group, timeoutMs);
        this.worker.addTenantListenersWithContent(dataId, group, content, Arrays.asList(listener));
        return content;
    }

    public void addListener(String dataId, String group, Listener listener) throws NacosException {
        this.worker.addTenantListeners(dataId, group, Arrays.asList(listener));
    }

    public boolean publishConfig(String dataId, String group, String content) throws NacosException {
        return this.publishConfig(dataId, group, content, ConfigType.getDefaultType().getType());
    }

    public boolean publishConfig(String dataId, String group, String content, String type) throws NacosException {
        return this.publishConfigInner(this.namespace, dataId, group, null, null, null, content, type);
    }

    public boolean removeConfig(String dataId, String group) throws NacosException {
        return this.removeConfigInner(this.namespace, dataId, group, null);
    }

    public void removeListener(String dataId, String group, Listener listener) {
        this.worker.removeTenantListener(dataId, group, listener);
    }

    private String getConfigInner(String tenant, String dataId, String group, long timeoutMs) throws NacosException {
        group = this.blank2defaultGroup(group);
        ParamUtils.checkKeyParam(dataId, group);
        ConfigResponse cr = new ConfigResponse();
        cr.setDataId(dataId);
        cr.setTenant(tenant);
        cr.setGroup(group);
        String content = LocalConfigInfoProcessor.getFailover(this.agent.getName(), dataId, group, tenant);
        if (content != null) {
            LOGGER.warn("[{}] [get-config] get failover ok, dataId={}, group={}, tenant={}, config={}", new Object[]{this.agent.getName(), dataId, group, tenant, ContentUtils.truncateContent(content)});
            cr.setContent(content);
            String encryptedDataKey = LocalEncryptedDataKeyProcessor.getEncryptDataKeyFailover(this.agent.getName(), dataId, group, tenant);
            cr.setEncryptedDataKey(encryptedDataKey);
            this.configFilterChainManager.doFilter(null, cr);
            content = cr.getContent();
            return content;
        }
        try {
            ConfigResponse response = this.worker.getServerConfig(dataId, group, tenant, timeoutMs);
            cr.setContent(response.getContent());
            cr.setEncryptedDataKey(response.getEncryptedDataKey());
            this.configFilterChainManager.doFilter(null, cr);
            content = cr.getContent();
            return content;
        }
        catch (NacosException ioe) {
            if (403 == ioe.getErrCode()) {
                throw ioe;
            }
            LOGGER.warn("[{}] [get-config] get from server error, dataId={}, group={}, tenant={}, msg={}", new Object[]{this.agent.getName(), dataId, group, tenant, ioe.toString()});
            content = LocalConfigInfoProcessor.getSnapshot(this.agent.getName(), dataId, group, tenant);
            LOGGER.warn("[{}] [get-config] get snapshot ok, dataId={}, group={}, tenant={}, config={}", new Object[]{this.agent.getName(), dataId, group, tenant, ContentUtils.truncateContent(content)});
            cr.setContent(content);
            String encryptedDataKey = LocalEncryptedDataKeyProcessor.getEncryptDataKeySnapshot(this.agent.getName(), dataId, group, tenant);
            cr.setEncryptedDataKey(encryptedDataKey);
            this.configFilterChainManager.doFilter(null, cr);
            content = cr.getContent();
            return content;
        }
    }

    private String blank2defaultGroup(String group) {
        return StringUtils.isBlank((String)group) ? "DEFAULT_GROUP" : group.trim();
    }

    private boolean removeConfigInner(String tenant, String dataId, String group, String tag) throws NacosException {
        group = this.blank2defaultGroup(group);
        ParamUtils.checkKeyParam(dataId, group);
        String url = "/v1/cs/configs";
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("dataId", dataId);
        params.put("group", group);
        if (StringUtils.isNotEmpty((String)tenant)) {
            params.put("tenant", tenant);
        }
        if (StringUtils.isNotEmpty((String)tag)) {
            params.put("tag", tag);
        }
        HttpRestResult<String> result = null;
        try {
            result = this.agent.httpDelete(url, null, params, this.encode, 3000L);
        }
        catch (Exception ex) {
            LOGGER.warn("[remove] error, " + dataId + ", " + group + ", " + tenant + ", msg: " + ex.toString());
            return false;
        }
        if (result.ok()) {
            LOGGER.info("[{}] [remove] ok, dataId={}, group={}, tenant={}", new Object[]{this.agent.getName(), dataId, group, tenant});
            return true;
        }
        if (403 == result.getCode()) {
            LOGGER.warn("[{}] [remove] error, dataId={}, group={}, tenant={}, code={}, msg={}", new Object[]{this.agent.getName(), dataId, group, tenant, result.getCode(), result.getMessage()});
            throw new NacosException(result.getCode(), result.getMessage());
        }
        LOGGER.warn("[{}] [remove] error, dataId={}, group={}, tenant={}, code={}, msg={}", new Object[]{this.agent.getName(), dataId, group, tenant, result.getCode(), result.getMessage()});
        return false;
    }

    private boolean publishConfigInner(String tenant, String dataId, String group, String tag, String appName, String betaIps, String content, String type) throws NacosException {
        String dataKey;
        group = this.blank2defaultGroup(group);
        ParamUtils.checkParam(dataId, group, content);
        ConfigRequest cr = new ConfigRequest();
        cr.setDataId(dataId);
        cr.setTenant(tenant);
        cr.setGroup(group);
        cr.setContent(content);
        this.configFilterChainManager.doFilter(cr, null);
        content = cr.getContent();
        String url = "/v1/cs/configs";
        HashMap<String, String> params = new HashMap<String, String>(6);
        params.put("dataId", dataId);
        params.put("group", group);
        params.put("content", content);
        params.put("type", type);
        if (StringUtils.isNotEmpty((String)tenant)) {
            params.put("tenant", tenant);
        }
        if (StringUtils.isNotEmpty((String)appName)) {
            params.put("appName", appName);
        }
        if (StringUtils.isNotEmpty((String)tag)) {
            params.put("tag", tag);
        }
        if (StringUtils.isNotEmpty((String)(dataKey = (String)cr.getParameter("encryptedDataKey")))) {
            params.put("encryptedDataKey", dataKey);
        }
        HashMap<String, String> headers = new HashMap<String, String>(1);
        if (StringUtils.isNotEmpty((String)betaIps)) {
            headers.put("betaIps", betaIps);
        }
        HttpRestResult<String> result = null;
        try {
            result = this.agent.httpPost(url, headers, params, this.encode, 3000L);
        }
        catch (Exception ex) {
            LOGGER.warn("[{}] [publish-single] exception, dataId={}, group={}, msg={}", new Object[]{this.agent.getName(), dataId, group, ex.toString()});
            return false;
        }
        if (result.ok()) {
            LOGGER.info("[{}] [publish-single] ok, dataId={}, group={}, tenant={}, config={}", new Object[]{this.agent.getName(), dataId, group, tenant, ContentUtils.truncateContent(content)});
            return true;
        }
        if (403 == result.getCode()) {
            LOGGER.warn("[{}] [publish-single] error, dataId={}, group={}, tenant={}, code={}, msg={}", new Object[]{this.agent.getName(), dataId, group, tenant, result.getCode(), result.getMessage()});
            throw new NacosException(result.getCode(), result.getMessage());
        }
        LOGGER.warn("[{}] [publish-single] error, dataId={}, group={}, tenant={}, code={}, msg={}", new Object[]{this.agent.getName(), dataId, group, tenant, result.getCode(), result.getMessage()});
        return false;
    }

    public String getServerStatus() {
        if (this.worker.isHealthServer()) {
            return "UP";
        }
        return "DOWN";
    }

    public void shutDown() throws NacosException {
        this.agent.shutdown();
        this.worker.shutdown();
    }
}

