/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.network.trace.component.command;

import java.util.List;
import org.apache.skywalking.apm.network.common.v3.Command;
import org.apache.skywalking.apm.network.common.v3.KeyStringValuePair;
import org.apache.skywalking.apm.network.trace.component.command.BaseCommand;
import org.apache.skywalking.apm.network.trace.component.command.Deserializable;
import org.apache.skywalking.apm.network.trace.component.command.Serializable;

public class ProfileTaskCommand
extends BaseCommand
implements Serializable,
Deserializable<ProfileTaskCommand> {
    public static final Deserializable<ProfileTaskCommand> DESERIALIZER = new ProfileTaskCommand("", "", "", 0, 0, 0, 0, 0L, 0L);
    public static final String NAME = "ProfileTaskQuery";
    private String taskId;
    private String endpointName;
    private int duration;
    private int minDurationThreshold;
    private int dumpPeriod;
    private int maxSamplingCount;
    private long startTime;
    private long createTime;

    public ProfileTaskCommand(String serialNumber, String taskId, String endpointName, int duration, int minDurationThreshold, int dumpPeriod, int maxSamplingCount, long startTime, long createTime) {
        super(NAME, serialNumber);
        this.taskId = taskId;
        this.endpointName = endpointName;
        this.duration = duration;
        this.minDurationThreshold = minDurationThreshold;
        this.dumpPeriod = dumpPeriod;
        this.maxSamplingCount = maxSamplingCount;
        this.startTime = startTime;
        this.createTime = createTime;
    }

    @Override
    public ProfileTaskCommand deserialize(Command command) {
        List<KeyStringValuePair> argsList = command.getArgsList();
        String serialNumber = null;
        String taskId = null;
        String endpointName = null;
        int duration = 0;
        int minDurationThreshold = 0;
        int dumpPeriod = 0;
        int maxSamplingCount = 0;
        long startTime = 0L;
        long createTime = 0L;
        for (KeyStringValuePair pair : argsList) {
            if ("SerialNumber".equals(pair.getKey())) {
                serialNumber = pair.getValue();
                continue;
            }
            if ("EndpointName".equals(pair.getKey())) {
                endpointName = pair.getValue();
                continue;
            }
            if ("TaskId".equals(pair.getKey())) {
                taskId = pair.getValue();
                continue;
            }
            if ("Duration".equals(pair.getKey())) {
                duration = Integer.parseInt(pair.getValue());
                continue;
            }
            if ("MinDurationThreshold".equals(pair.getKey())) {
                minDurationThreshold = Integer.parseInt(pair.getValue());
                continue;
            }
            if ("DumpPeriod".equals(pair.getKey())) {
                dumpPeriod = Integer.parseInt(pair.getValue());
                continue;
            }
            if ("MaxSamplingCount".equals(pair.getKey())) {
                maxSamplingCount = Integer.parseInt(pair.getValue());
                continue;
            }
            if ("StartTime".equals(pair.getKey())) {
                startTime = Long.parseLong(pair.getValue());
                continue;
            }
            if (!"CreateTime".equals(pair.getKey())) continue;
            createTime = Long.parseLong(pair.getValue());
        }
        return new ProfileTaskCommand(serialNumber, taskId, endpointName, duration, minDurationThreshold, dumpPeriod, maxSamplingCount, startTime, createTime);
    }

    @Override
    public Command.Builder serialize() {
        Command.Builder builder = this.commandBuilder();
        builder.addArgs(KeyStringValuePair.newBuilder().setKey("TaskId").setValue(this.taskId)).addArgs(KeyStringValuePair.newBuilder().setKey("EndpointName").setValue(this.endpointName)).addArgs(KeyStringValuePair.newBuilder().setKey("Duration").setValue(String.valueOf(this.duration))).addArgs(KeyStringValuePair.newBuilder().setKey("MinDurationThreshold").setValue(String.valueOf(this.minDurationThreshold))).addArgs(KeyStringValuePair.newBuilder().setKey("DumpPeriod").setValue(String.valueOf(this.dumpPeriod))).addArgs(KeyStringValuePair.newBuilder().setKey("MaxSamplingCount").setValue(String.valueOf(this.maxSamplingCount))).addArgs(KeyStringValuePair.newBuilder().setKey("StartTime").setValue(String.valueOf(this.startTime))).addArgs(KeyStringValuePair.newBuilder().setKey("CreateTime").setValue(String.valueOf(this.createTime)));
        return builder;
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getMinDurationThreshold() {
        return this.minDurationThreshold;
    }

    public int getDumpPeriod() {
        return this.dumpPeriod;
    }

    public int getMaxSamplingCount() {
        return this.maxSamplingCount;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public String getTaskId() {
        return this.taskId;
    }
}

