//---------------------------------------------------------------------------
//	Greenplum Database
//	Copyright (C) 2012 EMC Corp.
//
//	@filename:
//		CParseHandlerWindowFrame.h
//
//	@doc:
//		SAX parse handler class for parsing the window frame in a window key
//---------------------------------------------------------------------------

#ifndef GPDXL_CParseHandlerWindowFrame_H
#define GPDXL_CParseHandlerWindowFrame_H

#include "gpos/base.h"

#include "naucrates/dxl/operators/CDXLWindowFrame.h"
#include "naucrates/dxl/parser/CParseHandlerBase.h"
#include "naucrates/dxl/xml/dxltokens.h"

namespace gpdxl
{
using namespace gpos;

XERCES_CPP_NAMESPACE_USE

//---------------------------------------------------------------------------
//	@class:
//		CParseHandlerWindowFrame
//
//	@doc:
//		SAX parse handler class for parsing the window frame in a
//		window key.
//
//---------------------------------------------------------------------------
class CParseHandlerWindowFrame : public CParseHandlerBase
{
private:
	// window frame specification
	EdxlFrameSpec m_dxl_win_frame_spec;

	// frame exclusion strategy
	EdxlFrameExclusionStrategy m_dxl_frame_exclusion_strategy;

	// in_range function for startOffset
	OID m_start_in_range_func;

	// in_range function for endOffset
	OID m_end_in_range_func;

	// collation for in_range tests
	OID m_in_range_coll;

	// use ASC sort order for in_range tests
	bool m_in_range_asc;

	// nulls sort first for in_range tests
	bool m_in_range_nulls_first;

	// window frame generated by the parse handler
	CDXLWindowFrame *m_window_frame;

	// process the start of an element
	void StartElement(
		const XMLCh *const element_uri,			// URI of element's namespace
		const XMLCh *const element_local_name,	// local part of element's name
		const XMLCh *const element_qname,		// element's qname
		const Attributes &attr					// element's attributes
		) override;

	// process the end of an element
	void EndElement(
		const XMLCh *const element_uri,			// URI of element's namespace
		const XMLCh *const element_local_name,	// local part of element's name
		const XMLCh *const element_qname		// element's qname
		) override;

public:
	CParseHandlerWindowFrame(const CParseHandlerWindowFrame &) = delete;

	// ctor
	CParseHandlerWindowFrame(CMemoryPool *mp,
							 CParseHandlerManager *parse_handler_mgr,
							 CParseHandlerBase *parse_handler_root);

	// window frame generated by the parse handler
	CDXLWindowFrame *
	GetWindowFrame()
	{
		return m_window_frame;
	}
};
}  // namespace gpdxl

#endif	// !GPDXL_CParseHandlerWindowFrame_H

// EOF
