/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.distributed.disaster;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.ConsistencyMode;
import org.apache.ignite3.internal.distributionzones.NodeWithAttributes;
import org.apache.ignite3.internal.distributionzones.rebalance.AssignmentUtil;
import org.apache.ignite3.internal.distributionzones.rebalance.RebalanceUtil;
import org.apache.ignite3.internal.distributionzones.rebalance.ZoneRebalanceUtil;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.partition.replicator.network.disaster.LocalPartitionStateMessage;
import org.apache.ignite3.internal.partitiondistribution.Assignment;
import org.apache.ignite3.internal.partitiondistribution.Assignments;
import org.apache.ignite3.internal.replicator.PartitionGroupId;
import org.apache.ignite3.internal.replicator.ReplicationGroupId;
import org.apache.ignite3.internal.replicator.TablePartitionId;
import org.apache.ignite3.internal.replicator.ZonePartitionId;
import org.apache.ignite3.internal.table.distributed.disaster.DisasterRecoveryManager;
import org.apache.ignite3.internal.table.distributed.disaster.DisasterRecoveryRequest;
import org.apache.ignite3.internal.table.distributed.disaster.DisasterRecoveryRequestType;
import org.apache.ignite3.internal.table.distributed.disaster.GroupUpdateRequestHandler;
import org.apache.ignite3.internal.table.distributed.disaster.LocalPartitionStateMessageByNode;
import org.apache.ignite3.internal.table.distributed.disaster.exceptions.DisasterRecoveryException;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.internal.util.CollectionUtils;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.lang.ErrorGroups;

class ManualGroupRestartRequest
implements DisasterRecoveryRequest {
    private final UUID operationId;
    private final int zoneId;
    private final int tableId;
    private final Set<Integer> partitionIds;
    private final Set<String> nodeNames;
    private final long assignmentsTimestamp;
    private final boolean cleanUp;

    ManualGroupRestartRequest(UUID operationId, int zoneId, int tableId, Set<Integer> partitionIds, Set<String> nodeNames, long assignmentsTimestamp, boolean cleanUp) {
        this.operationId = operationId;
        this.zoneId = zoneId;
        this.tableId = tableId;
        this.partitionIds = Set.copyOf(partitionIds);
        this.nodeNames = Set.copyOf(nodeNames);
        this.assignmentsTimestamp = assignmentsTimestamp;
        this.cleanUp = cleanUp;
    }

    @Override
    public UUID operationId() {
        return this.operationId;
    }

    @Override
    public int zoneId() {
        return this.zoneId;
    }

    @Override
    public DisasterRecoveryRequestType type() {
        return DisasterRecoveryRequestType.MULTI_NODE;
    }

    public int tableId() {
        return this.tableId;
    }

    public Set<Integer> partitionIds() {
        return this.partitionIds;
    }

    public Set<String> nodeNames() {
        return this.nodeNames;
    }

    long assignmentsTimestamp() {
        return this.assignmentsTimestamp;
    }

    public boolean cleanUp() {
        return this.cleanUp;
    }

    @Override
    public CompletableFuture<Void> handle(DisasterRecoveryManager disasterRecoveryManager, long revision, HybridTimestamp timestamp) {
        if (!this.nodeNames.isEmpty() && !this.nodeNames.contains(disasterRecoveryManager.localNode().name())) {
            return CompletableFutures.nullCompletedFuture();
        }
        Catalog catalog = disasterRecoveryManager.catalogManager.activeCatalog(timestamp.longValue());
        CatalogZoneDescriptor zoneDescriptor = catalog.zone(this.zoneId);
        ArrayList restartFutures = new ArrayList();
        disasterRecoveryManager.raftManager.forEach((raftNodeId, raftGroupService) -> {
            ReplicationGroupId replicationGroupId = raftNodeId.groupId();
            if (this.shouldProcessPartition(replicationGroupId, zoneDescriptor)) {
                if (this.cleanUp) {
                    restartFutures.add(this.createRestartWithCleanupFuture(disasterRecoveryManager, replicationGroupId, revision, zoneDescriptor, catalog));
                } else {
                    restartFutures.add(this.createRestartFuture(disasterRecoveryManager, replicationGroupId, revision));
                }
            }
        });
        return restartFutures.isEmpty() ? CompletableFutures.nullCompletedFuture() : CompletableFuture.allOf((CompletableFuture[])restartFutures.toArray(CompletableFuture[]::new));
    }

    private boolean shouldProcessPartition(ReplicationGroupId replicationGroupId, CatalogZoneDescriptor zoneDescriptor) {
        Set<Integer> partitionIdsToCheck;
        Set<Integer> set = partitionIdsToCheck = this.partitionIds.isEmpty() ? Arrays.stream(AssignmentUtil.partitionIds(zoneDescriptor.partitions())).boxed().collect(Collectors.toSet()) : this.partitionIds;
        if (replicationGroupId instanceof TablePartitionId) {
            TablePartitionId groupId = (TablePartitionId)replicationGroupId;
            return groupId.tableId() == this.tableId && partitionIdsToCheck.contains(groupId.partitionId());
        }
        if (replicationGroupId instanceof ZonePartitionId) {
            ZonePartitionId groupId = (ZonePartitionId)replicationGroupId;
            return groupId.zoneId() == this.zoneId && partitionIdsToCheck.contains(groupId.partitionId());
        }
        return false;
    }

    private CompletableFuture<?> createRestartFuture(DisasterRecoveryManager disasterRecoveryManager, ReplicationGroupId replicationGroupId, long revision) {
        if (replicationGroupId instanceof TablePartitionId) {
            return disasterRecoveryManager.tableManager.restartPartition((TablePartitionId)replicationGroupId, revision, this.assignmentsTimestamp);
        }
        if (replicationGroupId instanceof ZonePartitionId) {
            return disasterRecoveryManager.partitionReplicaLifecycleManager.restartPartition((ZonePartitionId)replicationGroupId, revision, this.assignmentsTimestamp);
        }
        throw new IllegalStateException("Unexpected replication group id: " + replicationGroupId);
    }

    private CompletableFuture<?> createCleanupRestartFuture(DisasterRecoveryManager disasterRecoveryManager, ReplicationGroupId replicationGroupId, long revision) {
        if (replicationGroupId instanceof TablePartitionId) {
            return disasterRecoveryManager.tableManager.restartPartitionWithCleanUp((TablePartitionId)replicationGroupId, revision, this.assignmentsTimestamp);
        }
        if (replicationGroupId instanceof ZonePartitionId) {
            return disasterRecoveryManager.partitionReplicaLifecycleManager.restartPartitionWithCleanUp((ZonePartitionId)replicationGroupId, revision, this.assignmentsTimestamp);
        }
        throw new IllegalStateException("Unexpected replication group id: " + replicationGroupId);
    }

    private CompletableFuture<?> createRestartWithCleanupFuture(DisasterRecoveryManager disasterRecoveryManager, ReplicationGroupId replicationGroupId, long revision, CatalogZoneDescriptor zoneDescriptor, Catalog catalog) {
        if (zoneDescriptor.consistencyMode() == ConsistencyMode.HIGH_AVAILABILITY) {
            if (zoneDescriptor.replicas() >= 2) {
                return this.createCleanupRestartFuture(disasterRecoveryManager, replicationGroupId, revision);
            }
            return ManualGroupRestartRequest.notEnoughAliveNodes();
        }
        if (zoneDescriptor.replicas() <= 2) {
            return ManualGroupRestartRequest.notEnoughAliveNodes();
        }
        return ManualGroupRestartRequest.enoughAliveNodesToRestartWithCleanUp(disasterRecoveryManager, revision, replicationGroupId, zoneDescriptor, catalog).thenCompose(enoughNodes -> {
            if (enoughNodes.booleanValue()) {
                return this.createCleanupRestartFuture(disasterRecoveryManager, replicationGroupId, revision);
            }
            return ManualGroupRestartRequest.notEnoughAliveNodes();
        });
    }

    private static <U> CompletableFuture<U> notEnoughAliveNodes() {
        return CompletableFuture.failedFuture(new DisasterRecoveryException(ErrorGroups.DisasterRecovery.RESTART_WITH_CLEAN_UP_ERR, "Not enough alive nodes to perform reset with clean up."));
    }

    private static CompletableFuture<Boolean> enoughAliveNodesToRestartWithCleanUp(DisasterRecoveryManager disasterRecoveryManager, long msRevision, ReplicationGroupId replicationGroupId, CatalogZoneDescriptor zoneDescriptor, Catalog catalog) {
        if (replicationGroupId instanceof TablePartitionId) {
            TablePartitionId tablePartitionId = (TablePartitionId)replicationGroupId;
            return ManualGroupRestartRequest.checkPartitionAliveNodes(disasterRecoveryManager, tablePartitionId, zoneDescriptor, catalog, msRevision, DisasterRecoveryManager.tableState(), RebalanceUtil.tableStableAssignments(disasterRecoveryManager.metaStorageManager, tablePartitionId.tableId(), new int[]{tablePartitionId.partitionId()}));
        }
        if (replicationGroupId instanceof ZonePartitionId) {
            ZonePartitionId zonePartitionId = (ZonePartitionId)replicationGroupId;
            return ManualGroupRestartRequest.checkPartitionAliveNodes(disasterRecoveryManager, zonePartitionId, zoneDescriptor, catalog, msRevision, DisasterRecoveryManager.zoneState(), ZoneRebalanceUtil.zoneStableAssignments(disasterRecoveryManager.metaStorageManager, zonePartitionId.zoneId(), new int[]{zonePartitionId.partitionId()}));
        }
        throw new IllegalArgumentException("Unsupported replication group type: " + replicationGroupId.getClass());
    }

    private static <T extends PartitionGroupId> CompletableFuture<Boolean> checkPartitionAliveNodes(DisasterRecoveryManager disasterRecoveryManager, T partitionGroupId, CatalogZoneDescriptor zoneDescriptor, Catalog catalog, long msRevision, Function<LocalPartitionStateMessage, T> keyExtractor, CompletableFuture<Map<Integer, Assignments>> stableAssignments) {
        Set aliveNodesConsistentIds = disasterRecoveryManager.dzManager.logicalTopology(msRevision).stream().map(NodeWithAttributes::nodeName).collect(Collectors.toSet());
        CompletableFuture<Map<T, LocalPartitionStateMessageByNode>> localStatesFuture = disasterRecoveryManager.localPartitionStatesInternal(Set.of(zoneDescriptor.name()), Collections.emptySet(), Set.of(Integer.valueOf(partitionGroupId.partitionId())), catalog, keyExtractor);
        return localStatesFuture.thenCombine(stableAssignments, (localPartitionStatesMap, currentAssignments) -> {
            LocalPartitionStateMessageByNode localPartitionStateMessageByNode = (LocalPartitionStateMessageByNode)localPartitionStatesMap.get(partitionGroupId);
            Set<Assignment> partAssignments = GroupUpdateRequestHandler.getAliveNodesWithData(aliveNodesConsistentIds, localPartitionStateMessageByNode);
            Set<Assignment> currentStableAssignments = ((Assignments)currentAssignments.get(partitionGroupId.partitionId())).nodes();
            Set<Assignment> aliveStableNodes = CollectionUtils.intersect(currentStableAssignments, partAssignments);
            return aliveStableNodes.size() > zoneDescriptor.replicas() / 2 + 1;
        });
    }

    public String toString() {
        return S.toString(this);
    }
}

