/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.manager.ComponentContext;
import org.apache.ignite3.internal.manager.IgniteComponent;
import org.apache.ignite3.internal.storage.StorageException;
import org.apache.ignite3.internal.storage.configurations.StorageConfiguration;
import org.apache.ignite3.internal.storage.configurations.StorageProfileView;
import org.apache.ignite3.internal.storage.configurations.StorageView;
import org.apache.ignite3.internal.storage.engine.StorageEngine;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;

public class DataStorageManager
implements IgniteComponent {
    private final Map<String, StorageEngine> engines;
    private Map<String, String> profilesToEngines;
    private final StorageConfiguration storageConfiguration;

    public DataStorageManager(Map<String, StorageEngine> engines, StorageConfiguration storageConfiguration) {
        assert (!engines.isEmpty());
        this.engines = engines;
        this.storageConfiguration = storageConfiguration;
    }

    @Override
    public CompletableFuture<Void> startAsync(ComponentContext componentContext) throws StorageException {
        this.engines.values().forEach(StorageEngine::start);
        this.profilesToEngines = ((StorageView)this.storageConfiguration.value()).profiles().stream().collect(Collectors.toMap(StorageProfileView::name, StorageProfileView::engine));
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        try {
            IgniteUtils.closeAll(this.engines.values().stream().map(engine -> engine::stop));
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
        return CompletableFutures.nullCompletedFuture();
    }

    @Nullable
    public StorageEngine engineByStorageProfile(String storageProfile) {
        String engine = this.profilesToEngines.get(storageProfile);
        if (engine == null) {
            return null;
        }
        return this.engines.get(engine);
    }

    public Collection<StorageEngine> allStorageEngines() {
        return List.copyOf(this.engines.values());
    }

    public String toString() {
        return S.toString(DataStorageManager.class, this);
    }
}

