/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.pagememory.persistence;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.pagememory.io.PageIoRegistry;
import org.apache.ignite3.internal.pagememory.persistence.GroupPartitionId;
import org.apache.ignite3.internal.pagememory.persistence.IgniteInternalDataIntegrityViolationException;
import org.apache.ignite3.internal.pagememory.persistence.PartitionMeta;
import org.apache.ignite3.internal.pagememory.persistence.PartitionMetaFactory;
import org.apache.ignite3.internal.pagememory.persistence.io.PartitionMetaIo;
import org.apache.ignite3.internal.pagememory.persistence.store.FilePageStore;
import org.apache.ignite3.internal.util.GridUnsafe;
import org.jetbrains.annotations.Nullable;

public class PartitionMetaManager {
    private static final IgniteLogger LOG = Loggers.forClass(PartitionMetaManager.class);
    private final Map<GroupPartitionId, PartitionMeta> metas = new ConcurrentHashMap<GroupPartitionId, PartitionMeta>();
    private final PageIoRegistry ioRegistry;
    private final int pageSize;
    private final PartitionMetaFactory partitionMetaFactory;

    public PartitionMetaManager(PageIoRegistry ioRegistry, int pageSize, PartitionMetaFactory partitionMetaFactory) {
        this.ioRegistry = ioRegistry;
        this.pageSize = pageSize;
        this.partitionMetaFactory = partitionMetaFactory;
    }

    @Nullable
    public PartitionMeta getMeta(GroupPartitionId groupPartitionId) {
        return this.metas.get(groupPartitionId);
    }

    public void addMeta(GroupPartitionId groupPartitionId, PartitionMeta partitionMeta) {
        this.metas.put(groupPartitionId, partitionMeta);
    }

    public PartitionMeta readOrCreateMeta(@Nullable UUID checkpointId, GroupPartitionId groupPartitionId, FilePageStore filePageStore, ByteBuffer buffer, int partitionGeneration) throws IgniteInternalCheckedException {
        long bufferAddr = GridUnsafe.bufferAddress(buffer);
        long partitionMetaPageId = PartitionMeta.partitionMetaPageId(groupPartitionId.getPartitionId());
        if (this.containsPartitionMeta(filePageStore)) {
            try {
                filePageStore.readWithoutPageIdCheck(partitionMetaPageId, buffer, false);
                return this.partitionMetaFactory.createPartitionMeta(checkpointId, (PartitionMetaIo)this.ioRegistry.resolve(bufferAddr), bufferAddr, partitionGeneration);
            }
            catch (IgniteInternalDataIntegrityViolationException e) {
                LOG.info(() -> "Error reading partition meta page, will be recreated: " + groupPartitionId, (Throwable)e);
            }
        }
        PartitionMetaIo io = this.partitionMetaFactory.partitionMetaIo();
        io.initNewPage(bufferAddr, partitionMetaPageId, this.pageSize);
        io.setPageCount(bufferAddr, 1);
        int pageIdx = filePageStore.allocatePage();
        assert (pageIdx == 0) : pageIdx;
        filePageStore.write(partitionMetaPageId, buffer.rewind());
        filePageStore.sync();
        return this.partitionMetaFactory.createPartitionMeta(checkpointId, io, bufferAddr, partitionGeneration);
    }

    public void writeMetaToBuffer(GroupPartitionId groupPartitionId, PartitionMeta.PartitionMetaSnapshot partitionMeta, ByteBuffer writeToBuffer) {
        assert (writeToBuffer.remaining() == this.pageSize) : writeToBuffer.remaining();
        long partitionMetaPageId = PartitionMeta.partitionMetaPageId(groupPartitionId.getPartitionId());
        long pageAddr = GridUnsafe.bufferAddress(writeToBuffer);
        PartitionMetaIo io = this.partitionMetaFactory.partitionMetaIo();
        io.initNewPage(pageAddr, partitionMetaPageId, this.pageSize);
        partitionMeta.writeTo(io, pageAddr);
    }

    private boolean containsPartitionMeta(FilePageStore filePageStore) throws IgniteInternalCheckedException {
        return filePageStore.deltaFileCount() > 0 || filePageStore.size() > (long)filePageStore.headerSize();
    }

    public void removeMeta(GroupPartitionId groupPartitionId) {
        this.metas.remove(groupPartitionId);
    }
}

