/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.systemview.view.sql;

import org.apache.ignite.internal.managers.systemview.walker.Order;
import org.apache.ignite.internal.processors.query.GridQueryProperty;
import org.apache.ignite.internal.processors.query.schema.management.TableDescriptor;
import org.apache.ignite.internal.util.typedef.F;

public class SqlTableColumnView {
    private final TableDescriptor tbl;
    private final GridQueryProperty prop;

    public SqlTableColumnView(TableDescriptor tbl, GridQueryProperty prop) {
        this.tbl = tbl;
        this.prop = prop;
    }

    @Order
    public String columnName() {
        return this.prop.name();
    }

    @Order(value=2)
    public String schemaName() {
        return this.tbl.type().schemaName();
    }

    @Order(value=1)
    public String tableName() {
        return this.tbl.type().tableName();
    }

    public Class<?> type() {
        return this.prop.type();
    }

    public String defaultValue() {
        return this.prop.defaultValue() == null ? null : this.prop.defaultValue().toString();
    }

    public int precision() {
        return this.prop.precision();
    }

    public int scale() {
        return this.prop.scale();
    }

    public boolean nullable() {
        return !this.prop.notNull();
    }

    public boolean pk() {
        return F.eq(this.prop.name(), this.tbl.type().keyFieldName()) || this.prop.key();
    }

    public boolean autoIncrement() {
        return false;
    }

    public boolean affinityColumn() {
        return !this.tbl.type().customAffinityKeyMapper() && (F.eq(this.prop.name(), this.tbl.type().affinityKey()) || F.isEmpty(this.tbl.type().affinityKey()) && this.pk());
    }
}

