/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.pagemem;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.internal.mem.DirectMemoryRegion;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageHeader;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.OffheapReadWriteLock;
import org.apache.ignite.internal.util.offheap.GridOffHeapOutOfMemoryException;
import org.apache.ignite.internal.util.typedef.internal.U;

public class PagePool {
    static final long SEGMENT_INDEX_MASK = -1099511627776L;
    private static final long ADDRESS_MASK = 0xFFFFFFFFFFFFFFL;
    private static final long COUNTER_INC = 0x100000000000000L;
    private static final long COUNTER_MASK = -72057594037927936L;
    protected final int idx;
    protected final DirectMemoryRegion region;
    protected final AtomicInteger pagesCntr = new AtomicInteger();
    protected long lastAllocatedIdxPtr;
    protected long freePageListPtr;
    protected long pagesBase;
    private final int sysPageSize;
    private OffheapReadWriteLock rwLock;

    protected PagePool(int idx, DirectMemoryRegion region, int sysPageSize, OffheapReadWriteLock rwLock) {
        long base;
        this.idx = idx;
        this.region = region;
        this.sysPageSize = sysPageSize;
        this.rwLock = rwLock;
        this.freePageListPtr = base = region.address() + 7L & 0xFFFFFFFFFFFFFFF8L;
        this.lastAllocatedIdxPtr = base += 8L;
        this.pagesBase = base += 8L;
        GridUnsafe.putLong(this.freePageListPtr, 0xFFFFFFFFFFFFFFL);
        GridUnsafe.putLong(this.lastAllocatedIdxPtr, 0L);
    }

    public long borrowOrAllocateFreePage(int tag) throws GridOffHeapOutOfMemoryException {
        long relPtr = this.borrowFreePage();
        if (relPtr == 0xFFFFFFFFFFFFFFL) {
            relPtr = this.allocateFreePage(tag);
        }
        if (relPtr != 0xFFFFFFFFFFFFFFL && this.pagesCntr != null) {
            this.pagesCntr.incrementAndGet();
        }
        return relPtr;
    }

    private long borrowFreePage() {
        long freePageRelPtrMasked;
        long freePageRelPtr;
        while ((freePageRelPtr = (freePageRelPtrMasked = GridUnsafe.getLongVolatile(null, this.freePageListPtr)) & 0xFFFFFFFFFFFFFFL) != 0xFFFFFFFFFFFFFFL) {
            long cnt;
            long freePageAbsPtr = this.absolute(freePageRelPtr);
            long nextFreePageRelPtr = GridUnsafe.getLongVolatile(null, freePageAbsPtr) & 0xFFFFFFFFFFFFFFL;
            if (!GridUnsafe.compareAndSwapLong(null, this.freePageListPtr, freePageRelPtrMasked, nextFreePageRelPtr | (cnt = (freePageRelPtrMasked & 0xFF00000000000000L) + 0x100000000000000L & 0xFF00000000000000L))) continue;
            GridUnsafe.putLongVolatile(null, freePageAbsPtr, 1L);
            return freePageRelPtr;
        }
        return 0xFFFFFFFFFFFFFFL;
    }

    private long allocateFreePage(int tag) throws GridOffHeapOutOfMemoryException {
        long lastIdx;
        long limit = this.region.address() + this.region.size();
        do {
            if (this.pagesBase + ((lastIdx = GridUnsafe.getLongVolatile(null, this.lastAllocatedIdxPtr)) + 1L) * (long)this.sysPageSize <= limit) continue;
            return 0xFFFFFFFFFFFFFFL;
        } while (!GridUnsafe.compareAndSwapLong(null, this.lastAllocatedIdxPtr, lastIdx, lastIdx + 1L));
        long absPtr = this.pagesBase + lastIdx * (long)this.sysPageSize;
        assert ((lastIdx & 0xFFFFFF0000000000L) == 0L);
        long relative = this.relative(lastIdx);
        assert (relative != 0xFFFFFFFFFFFFFFL);
        PageHeader.initNew(absPtr, relative);
        this.rwLock.init(absPtr + 32L, tag);
        return relative;
    }

    public int releaseFreePage(long relPtr) {
        long cnt;
        long relPtrWithCnt;
        long freePageRelPtrMasked;
        long absPtr = this.absolute(relPtr);
        assert (!PageHeader.isAcquired(absPtr)) : "Release pinned page: " + PageHeader.fullPageId(absPtr);
        int resCntr = 0;
        if (this.pagesCntr != null) {
            resCntr = this.pagesCntr.decrementAndGet();
        }
        do {
            freePageRelPtrMasked = GridUnsafe.getLongVolatile(null, this.freePageListPtr);
            long freePageRelPtr = freePageRelPtrMasked & 0xFFFFFFFFFFFFFFL;
            GridUnsafe.putLongVolatile(null, absPtr, freePageRelPtr);
        } while (!GridUnsafe.compareAndSwapLong(null, this.freePageListPtr, freePageRelPtrMasked, relPtrWithCnt = relPtr & 0xFFFFFFFFFFFFFFL | (cnt = freePageRelPtrMasked & 0xFF00000000000000L)));
        return resCntr;
    }

    long absolute(long relativePtr) {
        int segIdx = (int)(relativePtr >> 40 & 0xFFFFL);
        assert (segIdx == this.idx) : "expected=" + this.idx + ", actual=" + segIdx + ", relativePtr=" + U.hexLong(relativePtr);
        long pageIdx = relativePtr & 0xFFFFFFFFFFL;
        long off = pageIdx * (long)this.sysPageSize;
        return this.pagesBase + off;
    }

    long relative(long pageIdx) {
        return pageIdx | (long)this.idx << 40;
    }

    long pageIndex(long relPtr) {
        return relPtr & 0xFFFFFFFFFFL;
    }

    public int pages() {
        return (int)((this.region.size() - (this.pagesBase - this.region.address())) / (long)this.sysPageSize);
    }

    public int size() {
        return this.pagesCntr.get();
    }
}

