/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.lang.ErrorGroups;

class LocalIpAddresses {
    private static final IgniteLogger LOG = Loggers.forClass(LocalIpAddresses.class);
    private Set<InetAddress> addresses;

    LocalIpAddresses() {
    }

    void start() {
        try {
            this.addresses = NetworkInterface.networkInterfaces().flatMap(NetworkInterface::inetAddresses).collect(Collectors.toUnmodifiableSet());
        }
        catch (SocketException e) {
            throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, "Cannot get local addresses", (Throwable)e);
        }
        LOG.info("Local IP addresses: {}", new Object[]{this.addresses});
    }

    boolean isLocal(InetAddress addr) {
        return this.addresses.contains(addr);
    }
}

