/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rule.logical;

import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.RelShuttleImpl;
import org.apache.calcite.rel.core.Correlate;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.logical.LogicalTableFunctionScan;
import org.apache.calcite.rel.rules.PushProjector;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.util.BitSets;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.sql.engine.rule.logical.ImmutableIgniteProjectCorrelateTransposeRule;
import org.immutables.value.Value;

@Value.Enclosing
public class IgniteProjectCorrelateTransposeRule
extends RelRule<IgniteProjectCorrelateTransposeRuleConfig>
implements TransformationRule {
    public static final RelOptRule INSTANCE = IgniteProjectCorrelateTransposeRuleConfig.DEFAULT.toRule();

    protected IgniteProjectCorrelateTransposeRule(IgniteProjectCorrelateTransposeRuleConfig config) {
        super((RelRule.Config)config);
    }

    public void onMatch(RelOptRuleCall call) {
        Project origProject = (Project)call.rel(0);
        Correlate correlate = (Correlate)call.rel(1);
        PushProjector pushProjector = new PushProjector(origProject, (RexNode)call.builder().literal((Object)true), (RelNode)correlate, ((IgniteProjectCorrelateTransposeRuleConfig)this.config).preserveExprCondition(), call.builder());
        if (pushProjector.locateAllRefs()) {
            return;
        }
        Project leftProject = pushProjector.createProjectRefsAndExprs(correlate.getLeft(), true, false);
        Project rightProject = pushProjector.createProjectRefsAndExprs(correlate.getRight(), true, true);
        HashMap<Integer, Integer> requiredColsMap = new HashMap<Integer, Integer>();
        int[] adjustments = pushProjector.getAdjustments();
        BitSet updatedBits = new BitSet();
        for (Integer col : correlate.getRequiredColumns()) {
            int newCol = col + adjustments[col];
            updatedBits.set(newCol);
            requiredColsMap.put(col, newCol);
        }
        RexBuilder rexBuilder = call.builder().getRexBuilder();
        CorrelationId correlationId = correlate.getCluster().createCorrel();
        RexCorrelVariable rexCorrel = (RexCorrelVariable)rexBuilder.makeCorrel(leftProject.getRowType(), correlationId);
        rightProject = rightProject.accept((RelShuttle)new RelNodesExprsHandler(new RexFieldAccessReplacer(correlate.getCorrelationId(), rexCorrel, rexBuilder, requiredColsMap)));
        Correlate newCorrelate = correlate.copy(correlate.getTraitSet(), (RelNode)leftProject, (RelNode)rightProject, correlationId, ImmutableBitSet.of((Iterable)BitSets.toIter((BitSet)updatedBits)), correlate.getJoinType());
        RelNode topProject = pushProjector.createNewProject((RelNode)newCorrelate, adjustments);
        call.transformTo(topProject);
    }

    @Value.Immutable(singleton=false)
    public static interface IgniteProjectCorrelateTransposeRuleConfig
    extends RelRule.Config {
        public static final IgniteProjectCorrelateTransposeRuleConfig DEFAULT = ImmutableIgniteProjectCorrelateTransposeRule.IgniteProjectCorrelateTransposeRuleConfig.builder().withPreserveExprCondition(expr -> !(expr instanceof RexOver)).build().withOperandFor(Project.class, Correlate.class);

        default public IgniteProjectCorrelateTransposeRule toRule() {
            return new IgniteProjectCorrelateTransposeRule(this);
        }

        public PushProjector.ExprCondition preserveExprCondition();

        public IgniteProjectCorrelateTransposeRuleConfig withPreserveExprCondition(PushProjector.ExprCondition var1);

        default public IgniteProjectCorrelateTransposeRuleConfig withOperandFor(Class<? extends Project> projectClass, Class<? extends Correlate> correlateClass) {
            return (IgniteProjectCorrelateTransposeRuleConfig)this.withOperandSupplier(b0 -> b0.operand(projectClass).oneInput(b1 -> b1.operand(correlateClass).anyInputs())).as(IgniteProjectCorrelateTransposeRuleConfig.class);
        }
    }

    public static class RelNodesExprsHandler
    extends RelShuttleImpl {
        private final RexShuttle rexVisitor;

        public RelNodesExprsHandler(RexShuttle rexVisitor) {
            this.rexVisitor = rexVisitor;
        }

        protected RelNode visitChild(RelNode parent, int i, RelNode input) {
            return super.visitChild(parent, i, input.stripped()).accept(this.rexVisitor);
        }

        public RelNode visit(RelNode other) {
            if (other instanceof LogicalTableFunctionScan) {
                List operands = ((RexCall)((LogicalTableFunctionScan)other).getCall()).getOperands();
                for (int i = 0; i < operands.size(); ++i) {
                    ((RexNode)operands.get(i)).accept((RexVisitor)this.rexVisitor);
                }
            }
            return super.visit(other).accept(this.rexVisitor);
        }
    }

    public static class RexFieldAccessReplacer
    extends RexShuttle {
        private final RexBuilder builder;
        private final CorrelationId rexCorrelVariableToReplace;
        private final RexCorrelVariable rexCorrelVariable;
        private final Map<Integer, Integer> requiredColsMap;

        public RexFieldAccessReplacer(CorrelationId rexCorrelVariableToReplace, RexCorrelVariable rexCorrelVariable, RexBuilder builder, Map<Integer, Integer> requiredColsMap) {
            this.rexCorrelVariableToReplace = rexCorrelVariableToReplace;
            this.rexCorrelVariable = rexCorrelVariable;
            this.builder = builder;
            this.requiredColsMap = requiredColsMap;
        }

        public RexNode visitCorrelVariable(RexCorrelVariable variable) {
            if (variable.id.equals((Object)this.rexCorrelVariableToReplace)) {
                return this.rexCorrelVariable;
            }
            return variable;
        }

        public RexNode visitCall(RexCall call) {
            return super.visitCall(call);
        }

        public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
            RexNode refExpr = (RexNode)fieldAccess.getReferenceExpr().accept((RexVisitor)this);
            if (fieldAccess.getReferenceExpr() != refExpr && refExpr == this.rexCorrelVariable) {
                int fieldIndex = fieldAccess.getField().getIndex();
                return this.builder.makeFieldAccess(refExpr, Objects.requireNonNull(this.requiredColsMap.get(fieldIndex), () -> "no entry for field " + fieldIndex + " in " + String.valueOf(this.requiredColsMap)).intValue());
            }
            return super.visitFieldAccess(fieldAccess);
        }
    }
}

