/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.command;

import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.metastorage.command.CompactionCommand;
import org.apache.ignite.internal.metastorage.command.CompactionCommandBuilder;
import org.apache.ignite.internal.metastorage.command.MetaStorageCommandsFactory;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;

class CompactionCommandDeserializer
implements MessageDeserializer<CompactionCommand> {
    private final CompactionCommandBuilder msg;

    CompactionCommandDeserializer(MetaStorageCommandsFactory messageFactory) {
        this.msg = messageFactory.compactionCommand();
    }

    public Class<CompactionCommand> klass() {
        return CompactionCommand.class;
    }

    public CompactionCommand getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                long tmp = reader.readLong("compactionRevision");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.compactionRevision(tmp);
                reader.incrementState();
            }
            case 1: {
                HybridTimestamp tmp = reader.readHybridTimestamp("initiatorTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.initiatorTime(tmp);
                reader.incrementState();
            }
            case 2: {
                HybridTimestamp tmp = reader.readHybridTimestamp("safeTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.safeTime(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(CompactionCommand.class);
    }
}

