/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.service.impl;

import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hertzbeat.alert.dto.AlertManagerExternAlert;
import org.apache.hertzbeat.alert.dto.PrometheusExternAlert;
import org.apache.hertzbeat.alert.reduce.AlarmCommonReduce;
import org.apache.hertzbeat.alert.service.ExternAlertService;
import org.apache.hertzbeat.common.entity.alerter.SingleAlert;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class AlertManagerExternAlertService
implements ExternAlertService {
    private static final Logger log = LoggerFactory.getLogger(AlertManagerExternAlertService.class);
    @Autowired
    private AlarmCommonReduce alarmCommonReduce;

    @Override
    public void addExternAlert(String content) {
        AlertManagerExternAlert alert = (AlertManagerExternAlert)JsonUtil.fromJson((String)content, AlertManagerExternAlert.class);
        if (alert == null) {
            log.warn("parse alertmanager extern alert content failed! content: {}", (Object)content);
            return;
        }
        List<PrometheusExternAlert> alerts = alert.getAlerts();
        if (alerts == null || alerts.isEmpty()) {
            log.warn("receive alertmanager extern alert without alerts! content: {}", (Object)content);
            return;
        }
        for (PrometheusExternAlert prometheusAlert : alerts) {
            Map<String, String> labels;
            String description;
            Map<String, String> annotations = prometheusAlert.getAnnotations();
            if (annotations == null) {
                annotations = new HashMap<String, String>(8);
            }
            if (StringUtils.hasText((String)prometheusAlert.getGeneratorURL())) {
                annotations.put("generatorURL", prometheusAlert.getGeneratorURL());
            }
            if ((description = annotations.get("description")) == null) {
                description = annotations.get("summary");
            }
            if (description == null) {
                description = annotations.values().stream().findFirst().orElse("");
            }
            if ((labels = prometheusAlert.getLabels()) == null) {
                labels = new HashMap<String, String>(8);
            }
            labels.put("__source__", "alertmanager");
            String status = "firing";
            if (prometheusAlert.getEndsAt() != null && prometheusAlert.getEndsAt().isBefore(Instant.now())) {
                status = "resolved";
            }
            SingleAlert singleAlert = SingleAlert.builder().content(description).status(status).activeAt("firing".equals(status) ? Long.valueOf(Instant.now().toEpochMilli()) : null).startAt(Long.valueOf(prometheusAlert.getStartsAt() != null ? prometheusAlert.getStartsAt().toEpochMilli() : Instant.now().toEpochMilli())).endAt("resolved".equals(status) ? Long.valueOf(prometheusAlert.getEndsAt().toEpochMilli()) : null).labels(labels).annotations(prometheusAlert.getAnnotations()).triggerTimes(Integer.valueOf(1)).build();
            this.alarmCommonReduce.reduceAndSendAlarm(singleAlert);
        }
    }

    @Override
    public String supportSource() {
        return "alertmanager";
    }
}

