/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.service.ai;

import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.hertzbeat.common.constants.AiConstants;
import org.apache.hertzbeat.common.constants.AiTypeEnum;
import org.apache.hertzbeat.manager.config.AiProperties;
import org.apache.hertzbeat.manager.pojo.dto.AiMessage;
import org.apache.hertzbeat.manager.pojo.dto.OpenAiRequestParamDTO;
import org.apache.hertzbeat.manager.pojo.dto.OpenAiResponse;
import org.apache.hertzbeat.manager.service.ai.AiService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;

@Service(value="SparkDeskAiServiceImpl")
@ConditionalOnProperty(prefix="ai", name={"type"}, havingValue="sparkDesk")
public class SparkDeskAiServiceImpl
implements AiService {
    private static final Logger log = LoggerFactory.getLogger(SparkDeskAiServiceImpl.class);
    @Autowired
    private AiProperties aiProperties;
    private WebClient webClient;

    @PostConstruct
    private void init() {
        StringBuilder sb = new StringBuilder();
        String bearer = sb.append("Bearer ").append(this.aiProperties.getApiKey()).append(":").append(this.aiProperties.getApiSecret()).toString();
        this.webClient = WebClient.builder().baseUrl("https://spark-api-open.xf-yun.com/v1/chat/completions").defaultHeader("Content-Type", "application/json").defaultHeader("Authorization", bearer).exchangeStrategies(ExchangeStrategies.builder().codecs(item -> item.defaultCodecs().maxInMemorySize(0x1000000)).build()).build();
    }

    @Override
    public AiTypeEnum getType() {
        return AiTypeEnum.sparkDesk;
    }

    @Override
    public Flux<ServerSentEvent<String>> requestAi(String text) {
        this.checkParam(text, this.aiProperties.getApiKey(), this.aiProperties.getModel());
        OpenAiRequestParamDTO zhiPuRequestParamDTO = OpenAiRequestParamDTO.builder().model(this.aiProperties.getModel()).stream(Boolean.TRUE).maxTokens(AiConstants.SparkDeskConstants.MAX_TOKENS).temperature(0.7f).messages(List.of(new AiMessage("user", text))).build();
        return this.webClient.post().body(BodyInserters.fromValue(zhiPuRequestParamDTO)).retrieve().bodyToFlux(String.class).filter(aiResponse -> !"[DONE]".equals(aiResponse)).map(OpenAiResponse::convertToResponse).doOnError(error -> log.info("SparkDeskAiServiceImpl.requestAi exception:{}", (Object)error.getMessage()));
    }

    private void checkParam(String param, String apiKey, String model) {
        Assert.notNull((Object)param, "text is null");
        Assert.notNull((Object)model, "model is null");
        Assert.notNull((Object)apiKey, "ai.api-key is null");
    }
}

