/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.HBCKMetaTableAccessor;
import org.apache.hbase.HBCKRegionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionInfoMismatchTool {
    private static final Logger LOG = LoggerFactory.getLogger(RegionInfoMismatchTool.class);
    private final Connection connection;

    public RegionInfoMismatchTool(Connection connection) {
        this.connection = connection;
    }

    List<MalformedRegion> getMalformedRegions() throws IOException {
        try (Table meta = this.connection.getTable(TableName.META_TABLE_NAME);){
            HBCKMetaTableAccessor.MetaScanner<MalformedRegion> scanner = new HBCKMetaTableAccessor.MetaScanner<MalformedRegion>();
            List<MalformedRegion> list = scanner.scanMeta(this.connection, scan -> scan.addFamily(HConstants.CATALOG_FAMILY), r -> {
                Cell riCell = r.getColumnLatestCell(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
                RegionInfo info = RegionInfo.parseFromOrNull((byte[])riCell.getValueArray(), (int)riCell.getValueOffset(), (int)riCell.getValueLength());
                byte[] valueEncodedRegionName = info.getEncodedNameAsBytes();
                HBCKMetaTableAccessor.getMetaKeyForRegion(info);
                byte[] rowKeyRegionName = CellUtil.cloneRow((Cell)riCell);
                byte[] rowkeyEncodedRegionName = Bytes.toBytes((String)HBCKRegionInfo.encodeRegionName(rowKeyRegionName));
                if (Arrays.equals(rowkeyEncodedRegionName, valueEncodedRegionName)) {
                    LOG.debug("Ignoring region {} because rowkey aligns with value", (Object)info);
                    return null;
                }
                LOG.debug("Found mismatched region {} and {}", (Object)Bytes.toStringBinary((byte[])rowKeyRegionName), (Object)Bytes.toStringBinary((byte[])valueEncodedRegionName));
                return new MalformedRegion(rowKeyRegionName, info);
            });
            return list;
        }
    }

    public void run(boolean fix) throws IOException, DeserializationException {
        this.run(System.out, fix);
    }

    void run(PrintStream out, boolean fix) throws IOException, DeserializationException {
        List<MalformedRegion> regionsToFix = this.getMalformedRegions();
        if (!fix) {
            out.println("Fix mode is disabled, printing all malformed regions detected:");
            for (MalformedRegion r : regionsToFix) {
                out.println("Rowkey " + HBCKRegionInfo.encodeRegionName(r.getRegionName()) + " does not match " + r.getRegionInfo());
            }
        }
        out.println("Found " + regionsToFix.size() + " regions to fix.");
        try (Table meta = this.connection.getTable(TableName.META_TABLE_NAME);){
            for (MalformedRegion regionToFix : regionsToFix) {
                String updatedValueEncodedRegionName;
                byte[] regionName = regionToFix.getRegionName();
                RegionInfo wrongRegionInfo = regionToFix.getRegionInfo();
                byte[][] regionNameParts = HBCKRegionInfo.parseRegionNameOrReturnNull(regionName);
                if (regionNameParts == null) {
                    throw new RuntimeException("Couldn't parse parts from " + Bytes.toStringBinary((byte[])regionName));
                }
                int i = 0;
                for (byte[] part : regionNameParts) {
                    LOG.debug("Region name part[{}]: {}", (Object)i++, (Object)Bytes.toStringBinary((byte[])part));
                }
                long regionId = Long.parseLong(Bytes.toString((byte[])regionNameParts[2]));
                RegionInfo correctedRegionInfo = RegionInfoBuilder.newBuilder((TableName)wrongRegionInfo.getTable()).setRegionId(regionId).setStartKey(wrongRegionInfo.getStartKey()).setEndKey(wrongRegionInfo.getEndKey()).setReplicaId(0).setOffline(wrongRegionInfo.isOffline()).setSplit(wrongRegionInfo.isSplit()).build();
                String rowkeyEncodedRegionName = HBCKRegionInfo.encodeRegionName(regionName);
                if (!rowkeyEncodedRegionName.equals(updatedValueEncodedRegionName = correctedRegionInfo.getEncodedName())) {
                    out.println("Aborting: sanity-check failed on updated RegionInfo. Expected encoded region name " + rowkeyEncodedRegionName + " but got " + updatedValueEncodedRegionName + ".");
                    out.println("Incorrectly created RegionInfo was: " + correctedRegionInfo);
                    throw new RuntimeException("Failed sanity-check on corrected RegionInfo");
                }
                out.println("Updating RegionInfo for " + Bytes.toStringBinary((byte[])regionName) + " to " + correctedRegionInfo);
                if (!fix) continue;
                meta.put(HBCKMetaTableAccessor.makePutFromRegionInfo(correctedRegionInfo, System.currentTimeMillis()));
            }
            if (!fix) {
                out.println("Fix mode is not enabled, hbase:meta was not updated. See the tool output for a list of detected problematic regions. Re-run the tool without the dry run option to persist updates to hbase:meta.");
            }
        }
    }

    static class MalformedRegion {
        byte[] regionName;
        RegionInfo regionInfo;

        MalformedRegion(byte[] regionName, RegionInfo regionInfo) {
            this.regionName = regionName;
            this.regionInfo = regionInfo;
        }

        byte[] getRegionName() {
            return this.regionName;
        }

        RegionInfo getRegionInfo() {
            return this.regionInfo;
        }

        public String toString() {
            return "regionName=" + Bytes.toStringBinary((byte[])this.regionName) + ", regioninfo=" + this.regionInfo.toString();
        }
    }
}

