/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterListBase;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class FilterListWithOR
extends FilterListBase {
    private List<Filter.ReturnCode> prevFilterRCList = null;
    private List<Cell> prevCellList = null;

    public FilterListWithOR(List<Filter> filters) {
        super(filters);
        this.prevFilterRCList = new ArrayList<Object>(Collections.nCopies(filters.size(), null));
        this.prevCellList = new ArrayList<Object>(Collections.nCopies(filters.size(), null));
        this.subFiltersIncludedCell = new ArrayList<Boolean>(Collections.nCopies(filters.size(), false));
    }

    @Override
    public void addFilterLists(List<Filter> filters) {
        if (FilterListWithOR.checkAndGetReversed(filters, this.isReversed()) != this.isReversed()) {
            throw new IllegalArgumentException("Filters in the list must have the same reversed flag");
        }
        this.filters.addAll(filters);
        this.subFiltersIncludedCell.addAll(Collections.nCopies(filters.size(), false));
        this.prevFilterRCList.addAll(Collections.nCopies(filters.size(), null));
        this.prevCellList.addAll(Collections.nCopies(filters.size(), null));
    }

    @Override
    protected String formatLogFilters(List<Filter> logFilters) {
        return String.format("FilterList OR (%d/%d): %s", logFilters.size(), this.size(), logFilters.toString());
    }

    private Filter.ReturnCode calculateReturnCodeByPrevCellAndRC(Filter subFilter, Cell currentCell, Cell prevCell, Filter.ReturnCode prevCode) throws IOException {
        if (prevCell == null || prevCode == null) {
            return null;
        }
        switch (prevCode) {
            case INCLUDE: 
            case SKIP: {
                return null;
            }
            case SEEK_NEXT_USING_HINT: {
                Cell nextHintCell = subFilter.getNextCellHint(prevCell);
                return nextHintCell != null && this.compareCell(currentCell, nextHintCell) < 0 ? Filter.ReturnCode.SEEK_NEXT_USING_HINT : null;
            }
            case NEXT_COL: 
            case INCLUDE_AND_NEXT_COL: {
                return CellUtil.matchingColumn(prevCell, currentCell) ? Filter.ReturnCode.NEXT_COL : null;
            }
            case NEXT_ROW: 
            case INCLUDE_AND_SEEK_NEXT_ROW: {
                return CellUtil.matchingFamily(prevCell, currentCell) ? Filter.ReturnCode.NEXT_ROW : null;
            }
        }
        throw new IllegalStateException("Received code is not valid.");
    }

    private Filter.ReturnCode mergeReturnCode(Filter.ReturnCode rc, Filter.ReturnCode localRC) {
        if (rc == null) {
            return localRC;
        }
        switch (localRC) {
            case INCLUDE: {
                return Filter.ReturnCode.INCLUDE;
            }
            case INCLUDE_AND_NEXT_COL: {
                if (FilterListWithOR.isInReturnCodes(rc, Filter.ReturnCode.INCLUDE, Filter.ReturnCode.SKIP, Filter.ReturnCode.SEEK_NEXT_USING_HINT)) {
                    return Filter.ReturnCode.INCLUDE;
                }
                if (!FilterListWithOR.isInReturnCodes(rc, Filter.ReturnCode.INCLUDE_AND_NEXT_COL, Filter.ReturnCode.INCLUDE_AND_SEEK_NEXT_ROW, Filter.ReturnCode.NEXT_COL, Filter.ReturnCode.NEXT_ROW)) break;
                return Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
            }
            case INCLUDE_AND_SEEK_NEXT_ROW: {
                if (FilterListWithOR.isInReturnCodes(rc, Filter.ReturnCode.INCLUDE, Filter.ReturnCode.SKIP, Filter.ReturnCode.SEEK_NEXT_USING_HINT)) {
                    return Filter.ReturnCode.INCLUDE;
                }
                if (FilterListWithOR.isInReturnCodes(rc, Filter.ReturnCode.INCLUDE_AND_NEXT_COL, Filter.ReturnCode.NEXT_COL)) {
                    return Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
                }
                if (!FilterListWithOR.isInReturnCodes(rc, Filter.ReturnCode.INCLUDE_AND_SEEK_NEXT_ROW, Filter.ReturnCode.NEXT_ROW)) break;
                return Filter.ReturnCode.INCLUDE_AND_SEEK_NEXT_ROW;
            }
            case SKIP: {
                if (FilterListWithOR.isInReturnCodes(rc, Filter.ReturnCode.INCLUDE, Filter.ReturnCode.INCLUDE_AND_NEXT_COL, Filter.ReturnCode.INCLUDE_AND_SEEK_NEXT_ROW)) {
                    return Filter.ReturnCode.INCLUDE;
                }
                if (!FilterListWithOR.isInReturnCodes(rc, Filter.ReturnCode.SKIP, Filter.ReturnCode.NEXT_COL, Filter.ReturnCode.NEXT_ROW, Filter.ReturnCode.SEEK_NEXT_USING_HINT)) break;
                return Filter.ReturnCode.SKIP;
            }
            case NEXT_COL: {
                if (FilterListWithOR.isInReturnCodes(rc, Filter.ReturnCode.INCLUDE)) {
                    return Filter.ReturnCode.INCLUDE;
                }
                if (FilterListWithOR.isInReturnCodes(rc, Filter.ReturnCode.NEXT_COL, Filter.ReturnCode.NEXT_ROW)) {
                    return Filter.ReturnCode.NEXT_COL;
                }
                if (FilterListWithOR.isInReturnCodes(rc, Filter.ReturnCode.INCLUDE_AND_NEXT_COL, Filter.ReturnCode.INCLUDE_AND_SEEK_NEXT_ROW)) {
                    return Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
                }
                if (!FilterListWithOR.isInReturnCodes(rc, Filter.ReturnCode.SKIP, Filter.ReturnCode.SEEK_NEXT_USING_HINT)) break;
                return Filter.ReturnCode.SKIP;
            }
            case NEXT_ROW: {
                if (FilterListWithOR.isInReturnCodes(rc, Filter.ReturnCode.INCLUDE)) {
                    return Filter.ReturnCode.INCLUDE;
                }
                if (FilterListWithOR.isInReturnCodes(rc, Filter.ReturnCode.INCLUDE_AND_NEXT_COL)) {
                    return Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
                }
                if (FilterListWithOR.isInReturnCodes(rc, Filter.ReturnCode.INCLUDE_AND_SEEK_NEXT_ROW)) {
                    return Filter.ReturnCode.INCLUDE_AND_SEEK_NEXT_ROW;
                }
                if (FilterListWithOR.isInReturnCodes(rc, Filter.ReturnCode.SKIP, Filter.ReturnCode.SEEK_NEXT_USING_HINT)) {
                    return Filter.ReturnCode.SKIP;
                }
                if (FilterListWithOR.isInReturnCodes(rc, Filter.ReturnCode.NEXT_COL)) {
                    return Filter.ReturnCode.NEXT_COL;
                }
                if (!FilterListWithOR.isInReturnCodes(rc, Filter.ReturnCode.NEXT_ROW)) break;
                return Filter.ReturnCode.NEXT_ROW;
            }
            case SEEK_NEXT_USING_HINT: {
                if (FilterListWithOR.isInReturnCodes(rc, Filter.ReturnCode.INCLUDE, Filter.ReturnCode.INCLUDE_AND_NEXT_COL, Filter.ReturnCode.INCLUDE_AND_SEEK_NEXT_ROW)) {
                    return Filter.ReturnCode.INCLUDE;
                }
                if (FilterListWithOR.isInReturnCodes(rc, Filter.ReturnCode.SKIP, Filter.ReturnCode.NEXT_COL, Filter.ReturnCode.NEXT_ROW)) {
                    return Filter.ReturnCode.SKIP;
                }
                if (!FilterListWithOR.isInReturnCodes(rc, Filter.ReturnCode.SEEK_NEXT_USING_HINT)) break;
                return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
            }
        }
        throw new IllegalStateException("Received code is not valid. rc: " + (Object)((Object)rc) + ", localRC: " + (Object)((Object)localRC));
    }

    private void updatePrevFilterRCList(int index, Filter.ReturnCode currentRC) {
        this.prevFilterRCList.set(index, currentRC);
    }

    private void updatePrevCellList(int index, Cell currentCell, Filter.ReturnCode currentRC) {
        if (currentCell == null || currentRC == Filter.ReturnCode.INCLUDE || currentRC == Filter.ReturnCode.SKIP) {
            this.prevCellList.set(index, null);
        } else {
            this.prevCellList.set(index, currentCell);
        }
    }

    @Override
    public Filter.ReturnCode filterCell(Cell c) throws IOException {
        if (this.isEmpty()) {
            return Filter.ReturnCode.INCLUDE;
        }
        Filter.ReturnCode rc = null;
        int n = this.filters.size();
        for (int i = 0; i < n; ++i) {
            Filter filter = (Filter)this.filters.get(i);
            this.subFiltersIncludedCell.set(i, false);
            Cell prevCell = this.prevCellList.get(i);
            Filter.ReturnCode prevCode = this.prevFilterRCList.get(i);
            if (filter.filterAllRemaining()) continue;
            Filter.ReturnCode localRC = this.calculateReturnCodeByPrevCellAndRC(filter, c, prevCell, prevCode);
            if (localRC == null) {
                localRC = filter.filterCell(c);
            }
            this.updatePrevFilterRCList(i, localRC);
            this.updatePrevCellList(i, c, localRC);
            rc = this.mergeReturnCode(rc, localRC);
            if (!FilterListWithOR.isInReturnCodes(localRC, Filter.ReturnCode.INCLUDE, Filter.ReturnCode.INCLUDE_AND_NEXT_COL, Filter.ReturnCode.INCLUDE_AND_SEEK_NEXT_ROW)) continue;
            this.subFiltersIncludedCell.set(i, true);
        }
        return rc == null ? Filter.ReturnCode.SKIP : rc;
    }

    @Override
    public void reset() throws IOException {
        int n = this.filters.size();
        for (int i = 0; i < n; ++i) {
            ((Filter)this.filters.get(i)).reset();
            this.subFiltersIncludedCell.set(i, false);
            this.prevFilterRCList.set(i, null);
            this.prevCellList.set(i, null);
        }
    }

    @Override
    public boolean filterRowKey(byte[] rowKey, int offset, int length) throws IOException {
        if (this.isEmpty()) {
            return super.filterRowKey(rowKey, offset, length);
        }
        boolean retVal = true;
        int n = this.filters.size();
        for (int i = 0; i < n; ++i) {
            Filter filter = (Filter)this.filters.get(i);
            if (filter.filterAllRemaining() || filter.filterRowKey(rowKey, offset, length)) continue;
            retVal = false;
        }
        return retVal;
    }

    @Override
    public boolean filterRowKey(Cell firstRowCell) throws IOException {
        if (this.isEmpty()) {
            return super.filterRowKey(firstRowCell);
        }
        boolean retVal = true;
        int n = this.filters.size();
        for (int i = 0; i < n; ++i) {
            Filter filter = (Filter)this.filters.get(i);
            if (filter.filterAllRemaining() || filter.filterRowKey(firstRowCell)) continue;
            retVal = false;
        }
        return retVal;
    }

    @Override
    public boolean filterAllRemaining() throws IOException {
        if (this.isEmpty()) {
            return super.filterAllRemaining();
        }
        int n = this.filters.size();
        for (int i = 0; i < n; ++i) {
            if (((Filter)this.filters.get(i)).filterAllRemaining()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean filterRow() throws IOException {
        if (this.isEmpty()) {
            return super.filterRow();
        }
        int n = this.filters.size();
        for (int i = 0; i < n; ++i) {
            Filter filter = (Filter)this.filters.get(i);
            if (filter.filterRow()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Cell getNextCellHint(Cell currentCell) throws IOException {
        if (this.isEmpty()) {
            return super.getNextCellHint(currentCell);
        }
        Cell minKeyHint = null;
        int n = this.filters.size();
        for (int i = 0; i < n; ++i) {
            if (((Filter)this.filters.get(i)).filterAllRemaining()) continue;
            Cell curKeyHint = ((Filter)this.filters.get(i)).getNextCellHint(currentCell);
            if (curKeyHint == null) {
                return null;
            }
            if (minKeyHint == null) {
                minKeyHint = curKeyHint;
                continue;
            }
            if (this.compareCell(minKeyHint, curKeyHint) <= 0) continue;
            minKeyHint = curKeyHint;
        }
        return minKeyHint;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FilterListWithOR)) {
            return false;
        }
        FilterListWithOR f = (FilterListWithOR)obj;
        return this.filters.equals(f.getFilters()) && this.prevFilterRCList.equals(f.prevFilterRCList) && this.prevCellList.equals(f.prevCellList);
    }

    public int hashCode() {
        return Objects.hash(this.prevFilterRCList, this.prevCellList, this.filters);
    }
}

