/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.regionserver.BrokenStoreFileCleaner;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MediumTests.class, RegionServerTests.class})
public class TestBrokenStoreFileCleaner {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestBrokenStoreFileCleaner.class);
    private final HBaseTestingUtility testUtil = new HBaseTestingUtility();
    private static final byte[] fam = Bytes.toBytes((String)"cf_1");
    private static final byte[] qual1 = Bytes.toBytes((String)"qf_1");
    private static final byte[] val = Bytes.toBytes((String)"val");
    private static final String junkFileName = "409fad9a751c4e8c86d7f32581bdc156";
    TableName tableName;

    @Before
    public void setUp() throws Exception {
        this.testUtil.getConfiguration().set("hbase.store.file-tracker.impl", "org.apache.hadoop.hbase.regionserver.storefiletracker.FileBasedStoreFileTracker");
        this.testUtil.getConfiguration().set("hbase.region.broken.storefilecleaner.enabled", "true");
        this.testUtil.getConfiguration().set("hbase.region.broken.storefilecleaner.ttl", "0");
        this.testUtil.getConfiguration().set("hbase.region.broken.storefilecleaner.period", "15000000");
        this.testUtil.getConfiguration().set("hbase.region.broken.storefilecleaner.delay", "0");
        this.testUtil.startMiniCluster(1);
    }

    @After
    public void tearDown() throws Exception {
        this.testUtil.shutdownMiniCluster();
    }

    @Test
    public void testDeletingJunkFile() throws Exception {
        this.tableName = TableName.valueOf((String)(this.getClass().getSimpleName() + "testDeletingJunkFile"));
        this.createTableWithData(this.tableName);
        HRegion region = this.testUtil.getMiniHBaseCluster().getRegions(this.tableName).get(0);
        ServerName sn = this.testUtil.getMiniHBaseCluster().getServerHoldingRegion(this.tableName, region.getRegionInfo().getRegionName());
        HRegionServer rs = this.testUtil.getMiniHBaseCluster().getRegionServer(sn);
        BrokenStoreFileCleaner cleaner = rs.getBrokenStoreFileCleaner();
        HStore store = region.getStore(fam);
        Path cfPath = store.getRegionFileSystem().getStoreDir(store.getColumnFamilyName());
        Path junkFilePath = new Path(cfPath, junkFileName);
        FSDataOutputStream junkFileOS = store.getFileSystem().create(junkFilePath);
        junkFileOS.writeUTF("hello");
        junkFileOS.close();
        int storeFiles = store.getStorefilesCount();
        Assert.assertTrue((storeFiles > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)store.getFileSystem().exists(junkFilePath));
        cleaner.chore();
        Assert.assertFalse((boolean)store.getFileSystem().exists(junkFilePath));
        int currentStoreFiles = store.getStorefilesCount();
        Assert.assertEquals((long)currentStoreFiles, (long)storeFiles);
    }

    @Test
    public void testSkippingCompactedFiles() throws Exception {
        this.tableName = TableName.valueOf((String)(this.getClass().getSimpleName() + "testSkippningCompactedFiles"));
        this.createTableWithData(this.tableName);
        HRegion region = this.testUtil.getMiniHBaseCluster().getRegions(this.tableName).get(0);
        ServerName sn = this.testUtil.getMiniHBaseCluster().getServerHoldingRegion(this.tableName, region.getRegionInfo().getRegionName());
        HRegionServer rs = this.testUtil.getMiniHBaseCluster().getRegionServer(sn);
        BrokenStoreFileCleaner cleaner = rs.getBrokenStoreFileCleaner();
        region.compact(true);
        HStore store = region.getStore(fam);
        int compactedFiles = store.getCompactedFilesCount();
        Assert.assertTrue((compactedFiles > 0 ? 1 : 0) != 0);
        cleaner.chore();
        int existingCompactedFiles = store.getCompactedFilesCount();
        Assert.assertEquals((long)compactedFiles, (long)existingCompactedFiles);
        Path cfPath = store.getRegionFileSystem().getStoreDir(store.getColumnFamilyName());
        Path junkFilePath = new Path(cfPath, junkFileName);
        FSDataOutputStream junkFileOS = store.getFileSystem().create(junkFilePath);
        junkFileOS.writeUTF("hello");
        junkFileOS.close();
        Assert.assertTrue((boolean)store.getFileSystem().exists(junkFilePath));
        cleaner.setEnabled(true);
        cleaner.chore();
        Assert.assertFalse((boolean)store.getFileSystem().exists(junkFilePath));
        existingCompactedFiles = store.getCompactedFilesCount();
        Assert.assertEquals((long)compactedFiles, (long)existingCompactedFiles);
    }

    @Test
    public void testJunkFileTTL() throws Exception {
        this.tableName = TableName.valueOf((String)(this.getClass().getSimpleName() + "testDeletingJunkFile"));
        this.createTableWithData(this.tableName);
        HRegion region = this.testUtil.getMiniHBaseCluster().getRegions(this.tableName).get(0);
        ServerName sn = this.testUtil.getMiniHBaseCluster().getServerHoldingRegion(this.tableName, region.getRegionInfo().getRegionName());
        HRegionServer rs = this.testUtil.getMiniHBaseCluster().getRegionServer(sn);
        HStore store = region.getStore(fam);
        Path cfPath = store.getRegionFileSystem().getStoreDir(store.getColumnFamilyName());
        Path junkFilePath = new Path(cfPath, junkFileName);
        FSDataOutputStream junkFileOS = store.getFileSystem().create(junkFilePath);
        junkFileOS.writeUTF("hello");
        junkFileOS.close();
        int storeFiles = store.getStorefilesCount();
        Assert.assertTrue((storeFiles > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)store.getFileSystem().exists(junkFilePath));
        rs.getConfiguration().set("hbase.region.broken.storefilecleaner.ttl", "5000");
        BrokenStoreFileCleaner cleaner = new BrokenStoreFileCleaner(15000000, 0, (Stoppable)rs, rs.getConfiguration(), rs);
        cleaner.chore();
        Assert.assertTrue((boolean)store.getFileSystem().exists(junkFilePath));
        Thread.sleep(5000L);
        cleaner.chore();
        Assert.assertFalse((boolean)store.getFileSystem().exists(junkFilePath));
        int currentStoreFiles = store.getStorefilesCount();
        Assert.assertEquals((long)currentStoreFiles, (long)storeFiles);
    }

    @Test
    public void testWhenRegionIsClosing() throws Exception {
        this.tableName = TableName.valueOf((String)(this.getClass().getSimpleName() + "testWhenRegionIsClosing"));
        this.createTableWithData(this.tableName);
        HRegion region = this.testUtil.getMiniHBaseCluster().getRegions(this.tableName).get(0);
        ServerName sn = this.testUtil.getMiniHBaseCluster().getServerHoldingRegion(this.tableName, region.getRegionInfo().getRegionName());
        HRegionServer rs = this.testUtil.getMiniHBaseCluster().getRegionServer(sn);
        HStore store = region.getStore(fam);
        int expectedStoreFiles = store.getStorefilesCount();
        Assert.assertTrue((expectedStoreFiles > 0 ? 1 : 0) != 0);
        Path cfPath = store.getRegionFileSystem().getStoreDir(store.getColumnFamilyName());
        int totalFiles = store.getRegionFileSystem().getFileSystem().listStatus(cfPath).length - 1;
        Assert.assertEquals((long)expectedStoreFiles, (long)totalFiles);
        HRegionServer mockedServer = (HRegionServer)Mockito.mock(HRegionServer.class);
        HRegion mockedRegion = (HRegion)Mockito.mock(HRegion.class);
        Mockito.when((Object)mockedRegion.isAvailable()).thenReturn((Object)region.isAvailable());
        Mockito.when((Object)mockedRegion.getRegionFileSystem()).thenReturn((Object)region.getRegionFileSystem());
        ArrayList<HRegion> mockedRegionsList = new ArrayList<HRegion>();
        mockedRegionsList.add(mockedRegion);
        Mockito.when((Object)mockedServer.getRegions()).thenReturn(mockedRegionsList);
        Mockito.when((Object)mockedServer.getServerName()).thenReturn((Object)rs.getServerName());
        Mockito.when((Object)mockedRegion.getStores()).thenAnswer(i -> {
            region.close();
            return region.getStores();
        });
        BrokenStoreFileCleaner cleaner = new BrokenStoreFileCleaner(15000000, 0, (Stoppable)rs, rs.getConfiguration(), mockedServer);
        cleaner.chore();
        int currentStoreFiles = store.getRegionFileSystem().getFileSystem().listStatus(cfPath).length - 1;
        Assert.assertEquals((long)expectedStoreFiles, (long)currentStoreFiles);
    }

    private Table createTableWithData(TableName tableName) throws IOException {
        Table table = this.testUtil.createTable(tableName, fam);
        try {
            Put p;
            int i;
            for (i = 1; i < 10; ++i) {
                p = new Put(Bytes.toBytes((String)("row" + i)));
                p.addColumn(fam, qual1, val);
                table.put(p);
            }
            this.testUtil.getAdmin().flush(tableName);
            for (i = 11; i < 20; ++i) {
                p = new Put(Bytes.toBytes((String)("row" + i)));
                p.addColumn(fam, qual1, val);
                table.put(p);
            }
            this.testUtil.getAdmin().flush(tableName);
            for (i = 21; i < 30; ++i) {
                p = new Put(Bytes.toBytes((String)("row" + i)));
                p.addColumn(fam, qual1, val);
                table.put(p);
            }
            this.testUtil.getAdmin().flush(tableName);
        }
        catch (IOException e) {
            table.close();
            throw e;
        }
        return table;
    }
}

