/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.replication;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ProcedureTestUtil;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.PeerProcedureInterface;
import org.apache.hadoop.hbase.master.replication.ModifyPeerProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, LargeTests.class})
public class TestModifyPeerProcedureRetryBackoff {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestModifyPeerProcedureRetryBackoff.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static boolean FAIL = true;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertBackoffIncrease() throws IOException, InterruptedException {
        ProcedureTestUtil.waitUntilProcedureWaitingTimeout(UTIL, TestModifyPeerProcedure.class, 30000L);
        ProcedureTestUtil.waitUntilProcedureTimeoutIncrease(UTIL, TestModifyPeerProcedure.class, 2);
        Class<TestModifyPeerProcedureRetryBackoff> clazz = TestModifyPeerProcedureRetryBackoff.class;
        synchronized (TestModifyPeerProcedureRetryBackoff.class) {
            FAIL = false;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            UTIL.waitFor(30000L, () -> FAIL);
            return;
        }
    }

    @Test
    public void test() throws IOException, InterruptedException {
        ProcedureExecutor procExec = UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor();
        long procId = procExec.submitProcedure((Procedure)new TestModifyPeerProcedure("1"));
        this.assertBackoffIncrease();
        this.assertBackoffIncrease();
        this.assertBackoffIncrease();
        this.assertBackoffIncrease();
        this.assertBackoffIncrease();
        this.assertBackoffIncrease();
        UTIL.waitFor(30000L, () -> procExec.isFinished(procId));
    }

    public static class TestModifyPeerProcedure
    extends ModifyPeerProcedure {
        public TestModifyPeerProcedure() {
        }

        public TestModifyPeerProcedure(String peerId) {
            super(peerId);
        }

        public PeerProcedureInterface.PeerOperationType getPeerOperationType() {
            return PeerProcedureInterface.PeerOperationType.ADD;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void tryFail() throws ReplicationException {
            Class<TestModifyPeerProcedureRetryBackoff> clazz = TestModifyPeerProcedureRetryBackoff.class;
            synchronized (TestModifyPeerProcedureRetryBackoff.class) {
                if (FAIL) {
                    throw new ReplicationException("Inject error");
                }
                FAIL = true;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        protected <T extends Procedure<MasterProcedureEnv>> void addChildProcedure(T ... subProcedure) {
        }

        protected MasterProcedureProtos.PeerModificationState nextStateAfterRefresh() {
            return MasterProcedureProtos.PeerModificationState.SERIAL_PEER_REOPEN_REGIONS;
        }

        protected boolean enablePeerBeforeFinish() {
            return true;
        }

        protected void updateLastPushedSequenceIdForSerialPeer(MasterProcedureEnv env) throws IOException, ReplicationException {
            this.tryFail();
        }

        protected void reopenRegions(MasterProcedureEnv env) throws IOException {
            try {
                this.tryFail();
            }
            catch (ReplicationException e) {
                throw new IOException(e);
            }
        }

        protected void enablePeer(MasterProcedureEnv env) throws ReplicationException {
            this.tryFail();
        }

        protected void prePeerModification(MasterProcedureEnv env) throws IOException, ReplicationException {
            this.tryFail();
        }

        protected void updatePeerStorage(MasterProcedureEnv env) throws ReplicationException {
            this.tryFail();
        }

        protected void postPeerModification(MasterProcedureEnv env) throws IOException, ReplicationException {
            this.tryFail();
        }
    }
}

