/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.ipc.AbstractRpcClient;
import org.apache.hadoop.hbase.ipc.AbstractTestIPC;
import org.apache.hadoop.hbase.ipc.BlockingRpcClient;
import org.apache.hadoop.hbase.ipc.BlockingRpcConnection;
import org.apache.hadoop.hbase.ipc.ConnectionId;
import org.apache.hadoop.hbase.ipc.NettyRpcServer;
import org.apache.hadoop.hbase.ipc.SimpleRpcServer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RPCTests;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={RPCTests.class, MediumTests.class})
public class TestBlockingIPC
extends AbstractTestIPC {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestBlockingIPC.class);

    @Parameterized.Parameters(name="{index}: rpcServerImpl={0}")
    public static List<Object[]> data() {
        return Arrays.asList({SimpleRpcServer.class}, {NettyRpcServer.class});
    }

    protected BlockingRpcClient createRpcClientNoCodec(Configuration conf) {
        return new BlockingRpcClient(conf){

            Codec getCodec() {
                return null;
            }
        };
    }

    protected BlockingRpcClient createRpcClient(Configuration conf) {
        return new BlockingRpcClient(conf);
    }

    protected BlockingRpcClient createRpcClientRTEDuringConnectionSetup(Configuration conf) throws IOException {
        return new BlockingRpcClient(conf){

            boolean isTcpNoDelay() {
                throw new RuntimeException("Injected fault");
            }
        };
    }

    @Override
    protected AbstractRpcClient<?> createBadAuthRpcClient(Configuration conf) {
        return new BlockingRpcClient(conf){

            protected BlockingRpcConnection createConnection(ConnectionId remoteId) throws IOException {
                return new BlockingRpcConnection(this, remoteId){

                    protected byte[] getConnectionHeaderPreamble() {
                        byte[] header = super.getConnectionHeaderPreamble();
                        header[header.length - 1] = -10;
                        return header;
                    }
                };
            }
        };
    }
}

