/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http;

import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.hbase.http.ProfileServlet;
import org.apache.hbase.thirdparty.org.eclipse.jetty.servlet.DefaultServlet;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ProfileOutputServlet
extends DefaultServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(ProfileOutputServlet.class);
    private static final int REFRESH_PERIOD = 2;
    private static final Pattern ALPHA_NUMERIC = Pattern.compile("[a-zA-Z0-9%=&.\\-]*");

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String absoluteDiskPath = this.getServletContext().getRealPath(req.getPathInfo());
        File requestedFile = new File(absoluteDiskPath);
        if (requestedFile.length() < 100L) {
            LOG.info(requestedFile + " is incomplete. Sending auto-refresh header.");
            String refreshUrl = req.getRequestURI();
            if (req.getQueryString() != null) {
                refreshUrl = refreshUrl + "?" + ProfileOutputServlet.sanitize(req.getQueryString());
            }
            ProfileServlet.setResponseHeader(resp);
            resp.setHeader("Refresh", "2;" + refreshUrl);
            resp.getWriter().write("This page will be auto-refreshed every 2 seconds until the output file is ready. Redirecting to " + refreshUrl);
        } else {
            super.doGet(req, resp);
        }
    }

    static String sanitize(String input) {
        if (ALPHA_NUMERIC.matcher(input).matches()) {
            return input;
        }
        throw new RuntimeException("Non-alphanumeric data found in input, aborting.");
    }
}

