/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.master.balancer.BalancerRegionLoad;
import org.apache.hadoop.hbase.master.balancer.CostFromRegionLoadAsRateFunction;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class WriteRequestCostFunction
extends CostFromRegionLoadAsRateFunction {
    private static final String WRITE_REQUEST_COST_KEY = "hbase.master.balancer.stochastic.writeRequestCost";
    private static final float DEFAULT_WRITE_REQUEST_COST = 5.0f;

    WriteRequestCostFunction(Configuration conf) {
        this.setMultiplier(conf.getFloat(WRITE_REQUEST_COST_KEY, 5.0f));
    }

    @Override
    protected double getCostFromRl(BalancerRegionLoad rl) {
        return rl.getWriteRequestsCount();
    }
}

