/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.vmplugin.v8;

import groovy.lang.Closure;
import groovy.lang.ExpandoMetaClass;
import groovy.lang.GroovyInterceptable;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassImpl;
import groovy.lang.MetaMethod;
import groovy.lang.MetaProperty;
import groovy.lang.MissingMethodException;
import groovy.transform.Internal;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Predicate;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.reflection.CachedField;
import org.codehaus.groovy.reflection.CachedMethod;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.reflection.GeneratedMetaMethod;
import org.codehaus.groovy.reflection.stdclasses.CachedSAMClass;
import org.codehaus.groovy.runtime.ArrayTypeUtils;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.GroovyCategorySupport;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.runtime.NullObject;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberMetaMethod;
import org.codehaus.groovy.runtime.metaclass.ClosureMetaClass;
import org.codehaus.groovy.runtime.metaclass.MetaClassRegistryImpl;
import org.codehaus.groovy.runtime.metaclass.MethodMetaProperty;
import org.codehaus.groovy.runtime.metaclass.NewInstanceMetaMethod;
import org.codehaus.groovy.runtime.metaclass.NewStaticMetaMethod;
import org.codehaus.groovy.runtime.metaclass.ReflectionMetaMethod;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.wrappers.Wrapper;
import org.codehaus.groovy.vmplugin.VMPlugin;
import org.codehaus.groovy.vmplugin.VMPluginFactory;
import org.codehaus.groovy.vmplugin.v8.CacheableCallSite;
import org.codehaus.groovy.vmplugin.v8.IndyGuardsFiltersAndSignatures;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.codehaus.groovy.vmplugin.v8.IndyMath;
import org.codehaus.groovy.vmplugin.v8.Java8;
import org.codehaus.groovy.vmplugin.v8.TypeHelper;
import org.codehaus.groovy.vmplugin.v8.TypeTransformers;

public abstract class Selector {
    public Object[] args;
    public Object[] originalArguments;
    public MetaMethod method;
    public MethodType targetType;
    public MethodType currentType;
    public String name;
    public MethodHandle handle;
    public boolean useMetaClass = false;
    public boolean cache = true;
    public CacheableCallSite callSite;
    public Class<?> sender;
    public boolean isVargs;
    public boolean safeNavigation;
    public boolean safeNavigationOrig;
    public boolean spread;
    public boolean skipSpreadCollector;
    public boolean thisCall;
    public Class<?> selectionBase;
    public boolean catchException = true;
    public IndyInterface.CallType callType;
    private static final IndyInterface.CallType[] CALL_TYPE_VALUES = IndyInterface.CallType.values();

    public static Selector getSelector(CacheableCallSite callSite, Class<?> sender, String methodName, int callID, boolean safeNavigation, boolean thisCall, boolean spreadCall, Object[] arguments) {
        IndyInterface.CallType callType = CALL_TYPE_VALUES[callID];
        switch (callType) {
            case INIT: {
                return new InitSelector(callSite, sender, methodName, callType, safeNavigation, thisCall, spreadCall, arguments);
            }
            case METHOD: {
                return new MethodSelector(callSite, sender, methodName, callType, safeNavigation, thisCall, spreadCall, arguments);
            }
            case GET: {
                return new PropertySelector(callSite, sender, methodName, callType, safeNavigation, thisCall, spreadCall, arguments);
            }
            case SET: {
                throw new GroovyBugError("your call tried to do a property set, which is not supported.");
            }
            case CAST: {
                return new CastSelector(callSite, arguments);
            }
            case INTERFACE: {
                return new InterfaceSelector(callSite, sender, methodName, callType, safeNavigation, thisCall, spreadCall, arguments);
            }
        }
        throw new GroovyBugError("unexpected call type");
    }

    public Object getCorrectedReceiver() {
        Object receiver = this.args[0];
        if (receiver == null) {
            if (IndyInterface.LOG_ENABLED) {
                IndyInterface.LOG.info("receiver is null");
            }
            receiver = NullObject.getNullObject();
        }
        return receiver;
    }

    abstract void setCallSiteTarget();

    private static MetaClassImpl getMetaClassImpl(MetaClass mc, boolean includeEMC) {
        boolean valid;
        Class<?> mcc = mc.getClass();
        boolean bl = valid = mcc == MetaClassImpl.class || mcc == ClosureMetaClass.class || includeEMC && mcc == ExpandoMetaClass.class;
        if (!valid) {
            if (IndyInterface.LOG_ENABLED) {
                IndyInterface.LOG.info("meta class is neither MetaClassImpl, nor ClosureMetaClass, normal method selection path disabled.");
            }
            return null;
        }
        if (IndyInterface.LOG_ENABLED) {
            IndyInterface.LOG.info("meta class is a recognized MetaClassImpl");
        }
        return (MetaClassImpl)mc;
    }

    private static Object[] spread(Object[] args, boolean spreadCall) {
        Object[] result = args;
        if (spreadCall) {
            Object[] arguments = (Object[])args[1];
            int nArguments = arguments.length;
            result = new Object[nArguments + 1];
            result[0] = args[0];
            System.arraycopy(arguments, 0, result, 1, nArguments);
            for (int i = 1; i <= nArguments; ++i) {
                Class<Object> argumentType;
                Class clazz = argumentType = result[i] != null ? result[i].getClass() : Object.class;
                if (!argumentType.isArray() || !argumentType.getComponentType().isPrimitive()) continue;
                result[i] = DefaultTypeTransformation.primitiveArrayBox(result[i]);
            }
        }
        return result;
    }

    private static Object[] removeRealReceiver(Object[] args) {
        Object[] ar = new Object[args.length - 1];
        System.arraycopy(args, 1, ar, 0, args.length - 1);
        return ar;
    }

    private static Object unwrapIfWrapped(Object object) {
        return object instanceof Wrapper ? IndyGuardsFiltersAndSignatures.unwrap(object) : object;
    }

    private static Class<?> getThisType(Class<?> sender) {
        while (GeneratedClosure.class.isAssignableFrom(sender)) {
            sender = sender.getEnclosingClass();
        }
        return sender;
    }

    private static class InitSelector
    extends MethodSelector {
        private static final MethodType MT_OBJECT = MethodType.methodType(Object.class);
        private boolean beanConstructor;

        public InitSelector(CacheableCallSite callSite, Class<?> sender, String methodName, IndyInterface.CallType callType, boolean safeNavigation, boolean thisCall, boolean spreadCall, Object[] arguments) {
            super(callSite, sender, methodName, callType, safeNavigation, thisCall, spreadCall, arguments);
        }

        @Override
        public boolean setInterceptor() {
            return false;
        }

        @Override
        public MetaClass getMetaClass() {
            this.mc = GroovySystem.getMetaClassRegistry().getMetaClass((Class)this.args[0]);
            if (IndyInterface.LOG_ENABLED) {
                IndyInterface.LOG.info("meta class is " + this.mc);
            }
            return this.mc;
        }

        @Override
        public void chooseMeta(MetaClassImpl mci) {
            MetaClassImpl.MetaConstructor mcon;
            if (mci == null) {
                return;
            }
            if (IndyInterface.LOG_ENABLED) {
                IndyInterface.LOG.info("getting constructor");
            }
            Object[] newArgs = Selector.removeRealReceiver(this.args);
            this.method = mci.retrieveConstructor(newArgs);
            if (this.method instanceof MetaClassImpl.MetaConstructor && (mcon = (MetaClassImpl.MetaConstructor)this.method).isBeanConstructor()) {
                if (IndyInterface.LOG_ENABLED) {
                    IndyInterface.LOG.info("do beans constructor");
                }
                this.beanConstructor = true;
            }
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void setHandleForMetaMethod() {
            if (this.method == null) {
                return;
            }
            if (this.method instanceof MetaClassImpl.MetaConstructor) {
                if (IndyInterface.LOG_ENABLED) {
                    IndyInterface.LOG.info("meta method is MetaConstructor instance");
                }
                mc = (MetaClassImpl.MetaConstructor)this.method;
                this.isVargs = mc.isVargsMethod();
                con = mc.getCachedConstrcutor().getCachedConstructor();
                try {
                    this.handle = this.callSite.getLookup().unreflectConstructor(con);
                    if (!IndyInterface.LOG_ENABLED) ** GOTO lbl17
                    IndyInterface.LOG.info("successfully unreflected constructor");
                }
                catch (IllegalAccessException e) {
                    throw new GroovyBugError(e);
                }
            } else {
                super.setHandleForMetaMethod();
            }
lbl17:
            // 3 sources

            if (this.beanConstructor) {
                con = IndyGuardsFiltersAndSignatures.BEAN_CONSTRUCTOR_PROPERTY_SETTER.bindTo(this.mc);
                foldTargetType = InitSelector.MT_OBJECT;
                if (this.args.length == 3) {
                    con = MethodHandles.dropArguments(con, 1, new Class[]{this.targetType.parameterType(1)});
                    foldTargetType = foldTargetType.insertParameterTypes(0, new Class[]{this.targetType.parameterType(1)});
                }
                this.handle = MethodHandles.foldArguments(con, this.handle.asType(foldTargetType));
            }
            if (this.method instanceof MetaClassImpl.MetaConstructor) {
                this.handle = MethodHandles.dropArguments(this.handle, 0, new Class[]{Class.class});
            }
        }

        @Override
        public void correctParameterLength() {
            if (this.beanConstructor) {
                return;
            }
            super.correctParameterLength();
        }

        @Override
        public void correctCoerce() {
            if (this.beanConstructor) {
                return;
            }
            super.correctCoerce();
        }

        @Override
        public void setMetaClassCallHandleIfNeeded(boolean standardMetaClass) {
            if (this.handle != null) {
                return;
            }
            this.useMetaClass = true;
            if (IndyInterface.LOG_ENABLED) {
                IndyInterface.LOG.info("set meta class invocation path");
            }
            this.handle = IndyGuardsFiltersAndSignatures.MOP_INVOKE_CONSTRUCTOR.bindTo(this.mc);
            this.handle = this.handle.asCollector(Object[].class, this.targetType.parameterCount() - 1);
            this.handle = MethodHandles.dropArguments(this.handle, 0, new Class[]{Class.class});
            if (IndyInterface.LOG_ENABLED) {
                IndyInterface.LOG.info("create collector for arguments");
            }
        }
    }

    private static class MethodSelector
    extends Selector {
        private static final Object[] SINGLE_NULL_ARRAY = new Object[]{null};
        private boolean isCategoryMethod;
        protected MetaClass mc;

        public MethodSelector(CacheableCallSite callSite, Class<?> sender, String methodName, IndyInterface.CallType callType, Boolean safeNavigation, Boolean thisCall, Boolean spreadCall, Object[] arguments) {
            this.callType = callType;
            this.targetType = callSite.type();
            this.name = methodName;
            this.originalArguments = arguments;
            this.args = Selector.spread(arguments, spreadCall);
            this.callSite = callSite;
            this.sender = sender;
            this.safeNavigationOrig = safeNavigation;
            this.safeNavigation = safeNavigation != false && arguments[0] == null;
            this.thisCall = thisCall;
            this.spread = spreadCall;
            boolean bl = this.cache = spreadCall == false;
            if (IndyInterface.LOG_ENABLED) {
                StringBuilder msg = new StringBuilder("----------------------------------------------------\n\t\tinvocation of method '" + methodName + "'\n\t\tinvocation type: " + callType + "\n\t\tsender: " + sender + "\n\t\ttargetType: " + this.targetType + "\n\t\tsafe navigation: " + safeNavigation + "\n\t\tthisCall: " + thisCall + "\n\t\tspreadCall: " + spreadCall + "\n\t\twith " + arguments.length + " arguments");
                for (int i = 0; i < arguments.length; ++i) {
                    msg.append("\n\t\t\targument[").append(i).append("] = ");
                    if (arguments[i] == null) {
                        msg.append("null");
                        continue;
                    }
                    msg.append(arguments[i].getClass().getName()).append("@").append(Integer.toHexString(System.identityHashCode(arguments[i])));
                }
                IndyInterface.LOG.info(msg.toString());
            }
        }

        public boolean setNullForSafeNavigation() {
            if (!this.safeNavigation) {
                return false;
            }
            this.handle = MethodHandles.dropArguments(IndyGuardsFiltersAndSignatures.NULL_REF, 0, this.targetType.parameterArray());
            if (IndyInterface.LOG_ENABLED) {
                IndyInterface.LOG.info("set null returning handle for safe navigation");
            }
            return true;
        }

        public MetaClass getMetaClass() {
            Object receiver = this.getCorrectedReceiver();
            if (receiver instanceof GroovyObject) {
                this.mc = ((GroovyObject)receiver).getMetaClass();
            } else if (receiver instanceof Class) {
                Class c = (Class)receiver;
                this.mc = GroovySystem.getMetaClassRegistry().getMetaClass(c);
                this.cache &= !ClassInfo.getClassInfo(c).hasPerInstanceMetaClasses();
            } else {
                this.mc = ((MetaClassRegistryImpl)GroovySystem.getMetaClassRegistry()).getMetaClass(receiver);
                this.cache &= !ClassInfo.getClassInfo(receiver.getClass()).hasPerInstanceMetaClasses();
            }
            this.mc.initialize();
            if (IndyInterface.LOG_ENABLED) {
                IndyInterface.LOG.info("meta class is " + this.mc);
            }
            return this.mc;
        }

        public void chooseMeta(MetaClassImpl mci) {
            if (mci == null) {
                return;
            }
            Object receiver = this.getCorrectedReceiver();
            Object[] newArgs = Selector.removeRealReceiver(this.args);
            if (receiver instanceof Class) {
                if (IndyInterface.LOG_ENABLED) {
                    IndyInterface.LOG.info("receiver is a class");
                }
                if (!mci.hasCustomStaticInvokeMethod()) {
                    this.method = mci.retrieveStaticMethod(this.name, newArgs);
                }
            } else if (!mci.hasCustomInvokeMethod()) {
                String name = this.name;
                if ("call".equals(name) && receiver instanceof GeneratedClosure) {
                    name = "doCall";
                }
                this.method = mci.getMethodWithCaching(this.selectionBase, name, newArgs, false);
            }
            if (IndyInterface.LOG_ENABLED) {
                IndyInterface.LOG.info("retrieved method from meta class: " + this.method);
            }
        }

        public void setHandleForMetaMethod() {
            MetaMethod metaMethod = this.method;
            this.isCategoryMethod = this.method instanceof GroovyCategorySupport.CategoryMethod;
            if (metaMethod instanceof NumberNumberMetaMethod || this.method instanceof GeneratedMetaMethod && ("next".equals(this.name) || "previous".equals(this.name))) {
                if (IndyInterface.LOG_ENABLED) {
                    IndyInterface.LOG.info("meta method is number method");
                }
                if (IndyMath.chooseMathMethod(this, metaMethod)) {
                    this.catchException = false;
                    if (IndyInterface.LOG_ENABLED) {
                        IndyInterface.LOG.info("indy math successful");
                    }
                    return;
                }
            }
            boolean isCategoryTypeMethod = metaMethod instanceof NewInstanceMetaMethod;
            if (IndyInterface.LOG_ENABLED) {
                IndyInterface.LOG.info("meta method is category type method: " + isCategoryTypeMethod);
            }
            boolean isStaticCategoryTypeMethod = metaMethod instanceof NewStaticMetaMethod;
            if (IndyInterface.LOG_ENABLED) {
                IndyInterface.LOG.info("meta method is static category type method: " + isCategoryTypeMethod);
            }
            if (metaMethod instanceof ReflectionMetaMethod) {
                if (IndyInterface.LOG_ENABLED) {
                    IndyInterface.LOG.info("meta method is reflective method");
                }
                metaMethod = ((ReflectionMetaMethod)metaMethod).getCachedMethod();
            }
            if (metaMethod instanceof CachedMethod) {
                this.isVargs = metaMethod.isVargsMethod();
                CachedMethod cm = (CachedMethod)metaMethod;
                VMPlugin vmplugin = VMPluginFactory.getPlugin();
                cm = (CachedMethod)vmplugin.transformMetaMethod(this.mc, cm, this.sender);
                try {
                    Class<?> declaringClass = cm.getDeclaringClass().getTheClass();
                    int parameterCount = cm.getParamsCount();
                    if (parameterCount == 0 && "clone".equals(this.name) && declaringClass == Object.class) {
                        Class<?> receiverClass = this.getCorrectedReceiver().getClass();
                        if (receiverClass.isArray()) {
                            this.handle = MethodHandles.publicLookup().findVirtual(receiverClass, "clone", MethodType.methodType(Object.class));
                        } else {
                            this.handle = MethodHandles.throwException(Object.class, CloneNotSupportedException.class).bindTo(new CloneNotSupportedException());
                            this.handle = MethodHandles.dropArguments(this.handle, 0, new Class[]{Object.class});
                        }
                    } else {
                        this.handle = parameterCount == 1 && "forName".equals(this.name) && declaringClass == Class.class ? MethodHandles.insertArguments(IndyGuardsFiltersAndSignatures.CLASS_FOR_NAME, 1, Boolean.TRUE, this.sender.getClassLoader()) : this.unreflect(cm.getCachedMethod());
                    }
                }
                catch (ReflectiveOperationException e) {
                    throw new GroovyBugError(e);
                }
                if (isStaticCategoryTypeMethod) {
                    this.handle = MethodHandles.insertArguments(this.handle, 0, SINGLE_NULL_ARRAY);
                    this.handle = MethodHandles.dropArguments(this.handle, 0, new Class[]{this.targetType.parameterType(0)});
                } else if (!isCategoryTypeMethod && cm.isStatic()) {
                    this.handle = MethodHandles.dropArguments(this.handle, 0, new Class[]{Object.class});
                }
            } else if (this.method != null) {
                if (IndyInterface.LOG_ENABLED) {
                    IndyInterface.LOG.info("meta method is dgm helper");
                }
                this.handle = IndyGuardsFiltersAndSignatures.META_METHOD_INVOKER;
                this.handle = this.handle.bindTo(this.method);
                if (this.spread) {
                    this.args = this.originalArguments;
                    this.skipSpreadCollector = true;
                } else {
                    this.handle = this.handle.asCollector(Object[].class, this.targetType.parameterCount() - 1);
                }
                this.currentType = this.removeWrapper(this.targetType);
                if (IndyInterface.LOG_ENABLED) {
                    IndyInterface.LOG.info("bound method name to META_METHOD_INVOKER");
                }
            }
        }

        protected MethodHandle unreflect(Method cachedMethod) throws IllegalAccessException {
            return this.callSite.getLookup().unreflect(cachedMethod);
        }

        private MethodType removeWrapper(MethodType targetType) {
            Class<?>[] types = targetType.parameterArray();
            for (int i = 0; i < types.length; ++i) {
                if (types[i] != Wrapper.class) continue;
                targetType = targetType.changeParameterType(i, Object.class);
            }
            return targetType;
        }

        private Method metaClassMethod(String name, Class<?> ... signature) {
            try {
                return this.mc.getClass().getMethod(name, signature);
            }
            catch (ReflectiveOperationException e) {
                throw new GroovyBugError(e);
            }
        }

        public void setMetaClassCallHandleIfNeeded(boolean standardMetaClass) {
            Object receiver;
            if (this.handle != null) {
                return;
            }
            this.useMetaClass = true;
            if (IndyInterface.LOG_ENABLED) {
                IndyInterface.LOG.info("set meta class invocation path");
            }
            if ((receiver = this.getCorrectedReceiver()) instanceof Class) {
                this.handle = IndyGuardsFiltersAndSignatures.META_CLASS_INVOKE_STATIC_METHOD.bindTo(this.mc);
                if (IndyInterface.LOG_ENABLED) {
                    IndyInterface.LOG.info("use invokeStaticMethod with bound meta class");
                }
            } else {
                if (standardMetaClass || this.metaClassMethod("invokeMethod", Object.class, String.class, Object[].class).getDeclaringClass().isAssignableFrom(this.metaClassMethod("invokeMethod", Class.class, Object.class, String.class, Object[].class, Boolean.TYPE, Boolean.TYPE).getDeclaringClass())) {
                    this.handle = IndyGuardsFiltersAndSignatures.META_CLASS_INVOKE_METHOD;
                    this.handle = this.handle.bindTo(this.mc).bindTo(this.sender);
                    this.handle = MethodHandles.insertArguments(this.handle, 3, Boolean.FALSE, Boolean.FALSE);
                    if (IndyInterface.LOG_ENABLED) {
                        IndyInterface.LOG.info("use invokeMethod with bound meta class and sender class");
                    }
                } else {
                    this.handle = IndyGuardsFiltersAndSignatures.MOP_INVOKE_METHOD.bindTo(this.mc);
                    if (IndyInterface.LOG_ENABLED) {
                        IndyInterface.LOG.info("use invokeMethod with bound meta class");
                    }
                }
                if (receiver instanceof GroovyObject) {
                    if (IndyInterface.LOG_ENABLED) {
                        IndyInterface.LOG.info("add MissingMethod handler for GroovyObject#invokeMethod fallback path");
                    }
                    this.handle = MethodHandles.catchException(this.handle, MissingMethodException.class, IndyGuardsFiltersAndSignatures.GROOVY_OBJECT_INVOKER);
                }
            }
            this.handle = MethodHandles.insertArguments(this.handle, 1, this.name);
            if (!this.spread) {
                this.handle = this.handle.asCollector(Object[].class, this.targetType.parameterCount() - 1);
            }
            if (IndyInterface.LOG_ENABLED) {
                IndyInterface.LOG.info("bind method name and create collector for arguments");
            }
        }

        public void correctWrapping() {
            if (this.useMetaClass) {
                return;
            }
            Class<?>[] pt = this.handle.type().parameterArray();
            if (this.currentType != null) {
                pt = this.currentType.parameterArray();
            }
            for (int i = 1; i < this.args.length; ++i) {
                if (!(this.args[i] instanceof Wrapper)) continue;
                Class<?> type = pt[i];
                MethodType mt = MethodType.methodType(type, Wrapper.class);
                this.handle = MethodHandles.filterArguments(this.handle, i, IndyGuardsFiltersAndSignatures.UNWRAP_METHOD.asType(mt));
                if (!IndyInterface.LOG_ENABLED) continue;
                IndyInterface.LOG.info("added filter for Wrapper for argument at pos " + i);
            }
        }

        public void correctParameterLength() {
            if (this.handle == null) {
                return;
            }
            Class<?>[] params = this.handle.type().parameterArray();
            if (this.currentType != null) {
                params = this.currentType.parameterArray();
            }
            if (!this.isVargs) {
                if (!(this.spread && this.useMetaClass || params.length != 2 || this.args.length != 1)) {
                    this.handle = MethodHandles.insertArguments(this.handle, 1, SINGLE_NULL_ARRAY);
                }
                return;
            }
            int aCount = this.args.length;
            int pCount = params.length;
            Class<?> vaType = params[pCount - 1];
            if (aCount == pCount) {
                Class lastArg = MetaClassHelper.convertToTypeArray(this.args)[aCount - 1];
                if (lastArg != null && (!lastArg.isArray() || ArrayTypeUtils.dimension(lastArg) != ArrayTypeUtils.dimension(vaType) && vaType != Object[].class)) {
                    this.handle = this.handle.asCollector(vaType, 1);
                    if (IndyInterface.LOG_ENABLED) {
                        IndyInterface.LOG.info("changed last argument to be collected for variadic parameter");
                    }
                }
            } else if (aCount < pCount) {
                this.handle = MethodHandles.insertArguments(this.handle, pCount - 1, Array.newInstance(vaType.getComponentType(), 0));
                if (IndyInterface.LOG_ENABLED) {
                    IndyInterface.LOG.info("added empty array for variadic parameter");
                }
            } else {
                this.handle = this.handle.asCollector(vaType, aCount - pCount + 1);
                if (IndyInterface.LOG_ENABLED) {
                    IndyInterface.LOG.info("changed surplus arguments to be collected for variadic parameter");
                }
            }
        }

        public void correctCoerce() {
            if (this.useMetaClass) {
                return;
            }
            Class<?>[] parameterTypes = this.handle.type().parameterArray();
            if (this.currentType != null) {
                parameterTypes = this.currentType.parameterArray();
            }
            if (this.args.length != parameterTypes.length) {
                throw new GroovyBugError("At this point argument array length and parameter array length should be the same");
            }
            for (int i = 0; i < this.args.length; ++i) {
                Class<?> wrappedPara;
                Class<?> got;
                Object arg;
                Class<?> parameterType = parameterTypes[i];
                if (parameterType == Object.class || (arg = Selector.unwrapIfWrapped(this.args[i])) == null || (got = arg.getClass()) == parameterType || (wrappedPara = TypeHelper.getWrapperClass(parameterType)) == TypeHelper.getWrapperClass(got) || parameterType.isAssignableFrom(got)) continue;
                this.handle = TypeTransformers.addTransformer(this.handle, i, arg, wrappedPara);
                if (!IndyInterface.LOG_ENABLED) continue;
                IndyInterface.LOG.info("added transformer at pos " + i + " for type " + got + " to type " + wrappedPara);
            }
        }

        public void correctNullReceiver() {
            if (this.args[0] != null) {
                return;
            }
            this.handle = this.handle.bindTo(NullObject.getNullObject());
            this.handle = MethodHandles.dropArguments(this.handle, 0, new Class[]{this.targetType.parameterType(0)});
            if (IndyInterface.LOG_ENABLED) {
                IndyInterface.LOG.info("binding null object receiver and dropping old receiver");
            }
        }

        public void correctSpreading() {
            if (this.spread && !this.useMetaClass && !this.skipSpreadCollector) {
                this.handle = this.handle.asSpreader(Object[].class, this.args.length - 1);
            }
        }

        public void addExceptionHandler() {
            if (this.handle == null || !this.catchException) {
                return;
            }
            TypeDescriptor.OfField returnType = this.handle.type().returnType();
            if (returnType != Object.class) {
                MethodType mtype = MethodType.methodType(returnType, GroovyRuntimeException.class);
                this.handle = MethodHandles.catchException(this.handle, GroovyRuntimeException.class, IndyGuardsFiltersAndSignatures.UNWRAP_EXCEPTION.asType(mtype));
            } else {
                this.handle = MethodHandles.catchException(this.handle, GroovyRuntimeException.class, IndyGuardsFiltersAndSignatures.UNWRAP_EXCEPTION);
            }
            if (IndyInterface.LOG_ENABLED) {
                IndyInterface.LOG.info("added GroovyRuntimeException unwrapper");
            }
        }

        public void setGuards(Object receiver) {
            MethodHandle test;
            if (!this.cache || this.handle == null) {
                return;
            }
            MethodHandle fallback = this.callSite.getFallbackTarget();
            if (receiver instanceof GroovyObject) {
                GroovyObject go = (GroovyObject)receiver;
                MetaClass mc = go.getMetaClass();
                test = IndyGuardsFiltersAndSignatures.SAME_MC.bindTo(mc);
                test = test.asType(MethodType.methodType(Boolean.TYPE, this.targetType.parameterType(0)));
                this.handle = MethodHandles.guardWithTest(test, this.handle, fallback);
                if (IndyInterface.LOG_ENABLED) {
                    IndyInterface.LOG.info("added meta class equality check");
                }
            } else if (receiver instanceof Class) {
                MethodHandle test2 = IndyGuardsFiltersAndSignatures.EQUALS.bindTo(receiver);
                test2 = test2.asType(MethodType.methodType(Boolean.TYPE, this.targetType.parameterType(0)));
                this.handle = MethodHandles.guardWithTest(test2, this.handle, fallback);
                if (IndyInterface.LOG_ENABLED) {
                    IndyInterface.LOG.info("added class equality check");
                }
            }
            if (this.isCategoryMethod && !this.useMetaClass && this.method instanceof NewInstanceMetaMethod) {
                this.handle = MethodHandles.guardWithTest(IndyGuardsFiltersAndSignatures.HAS_CATEGORY_IN_CURRENT_THREAD_GUARD, this.handle, fallback);
                if (IndyInterface.LOG_ENABLED) {
                    IndyInterface.LOG.info("added category-in-current-thread-guard for category method");
                }
            }
            this.handle = IndyInterface.switchPoint.guardWithTest(this.handle, fallback);
            if (IndyInterface.LOG_ENABLED) {
                IndyInterface.LOG.info("added switch point guard");
            }
            Predicate<Class> nonFinalOrNullUnsafe = t -> !Modifier.isFinal(t.getModifiers()) || TypeHelper.getUnboxedType(t).isPrimitive();
            Class<?>[] pt = this.handle.type().parameterArray();
            if (Arrays.stream(this.args).anyMatch(Objects::isNull)) {
                for (int i = 0; i < this.args.length; ++i) {
                    MethodHandle test3;
                    Object arg = this.args[i];
                    if (arg == null) {
                        test3 = IndyGuardsFiltersAndSignatures.IS_NULL.asType(MethodType.methodType(Boolean.TYPE, pt[i]));
                        if (IndyInterface.LOG_ENABLED) {
                            IndyInterface.LOG.info("added null argument check at pos " + i);
                        }
                    } else {
                        if (nonFinalOrNullUnsafe.negate().test(pt[i])) continue;
                        test3 = IndyGuardsFiltersAndSignatures.SAME_CLASS.bindTo(arg.getClass()).asType(MethodType.methodType(Boolean.TYPE, pt[i]));
                        if (IndyInterface.LOG_ENABLED) {
                            IndyInterface.LOG.info("added same-class argument check at pos " + i);
                        }
                    }
                    Class[] drops = new Class[i];
                    System.arraycopy(pt, 0, drops, 0, drops.length);
                    test3 = MethodHandles.dropArguments(test3, 0, drops);
                    this.handle = MethodHandles.guardWithTest(test3, this.handle, fallback);
                }
            } else if (Arrays.stream(pt).anyMatch(nonFinalOrNullUnsafe)) {
                test = IndyGuardsFiltersAndSignatures.SAME_CLASSES.bindTo(Arrays.stream(this.args).map(Object::getClass).toArray(Class[]::new)).asCollector(Object[].class, pt.length).asType(MethodType.methodType(Boolean.TYPE, pt));
                this.handle = MethodHandles.guardWithTest(test, this.handle, fallback);
                if (IndyInterface.LOG_ENABLED) {
                    IndyInterface.LOG.info("added same-class argument check");
                }
            } else if (this.safeNavigationOrig) {
                test = IndyGuardsFiltersAndSignatures.NON_NULL.asType(MethodType.methodType(Boolean.TYPE, pt[0]));
                this.handle = MethodHandles.guardWithTest(test, this.handle, fallback);
                if (IndyInterface.LOG_ENABLED) {
                    IndyInterface.LOG.info("added null receiver check");
                }
            }
        }

        public void doCallSiteTargetSet() {
            if (IndyInterface.LOG_ENABLED) {
                IndyInterface.LOG.info("call site stays uncached");
            }
        }

        public void setSelectionBase() {
            Class<?> sender = Selector.getThisType(this.sender);
            this.selectionBase = this.thisCall || sender.isInstance(this.args[0]) ? sender : this.mc.getTheClass();
            if (IndyInterface.LOG_ENABLED) {
                IndyInterface.LOG.info("selectionBase set to " + this.selectionBase);
            }
        }

        public boolean setInterceptor() {
            if (!(this.args[0] instanceof GroovyInterceptable)) {
                return false;
            }
            this.handle = MethodHandles.insertArguments(IndyGuardsFiltersAndSignatures.INTERCEPTABLE_INVOKER, 1, this.name);
            this.handle = this.handle.asCollector(Object[].class, this.targetType.parameterCount() - 1);
            this.handle = this.handle.asType(this.targetType);
            return true;
        }

        @Override
        public void setCallSiteTarget() {
            if (!this.setNullForSafeNavigation() && !this.setInterceptor()) {
                this.getMetaClass();
                this.setSelectionBase();
                MetaClassImpl mci = Selector.getMetaClassImpl(this.mc, this.callType != IndyInterface.CallType.GET);
                this.chooseMeta(mci);
                this.setHandleForMetaMethod();
                this.setMetaClassCallHandleIfNeeded(mci != null);
                this.correctParameterLength();
                this.correctCoerce();
                this.correctWrapping();
                this.correctNullReceiver();
                this.correctSpreading();
                if (IndyInterface.LOG_ENABLED) {
                    IndyInterface.LOG.info("casting explicit from " + this.handle.type() + " to " + this.targetType);
                }
                this.handle = MethodHandles.explicitCastArguments(this.handle, this.targetType);
                this.addExceptionHandler();
            }
            this.setGuards(this.args[0]);
            this.doCallSiteTargetSet();
        }
    }

    private static class PropertySelector
    extends MethodSelector {
        private boolean insertName;

        public PropertySelector(CacheableCallSite callSite, Class<?> sender, String propertyName, IndyInterface.CallType callType, boolean safeNavigation, boolean thisCall, boolean spreadCall, Object[] arguments) {
            super(callSite, sender, propertyName, callType, safeNavigation, thisCall, spreadCall, arguments);
        }

        @Override
        public boolean setInterceptor() {
            return false;
        }

        @Override
        public void chooseMeta(MetaClassImpl mci) {
            MetaProperty mp;
            Object receiver = this.getCorrectedReceiver();
            if (receiver instanceof GroovyObject) {
                try {
                    Method propertyAccessMethod = receiver.getClass().getMethod("getProperty", String.class);
                    if (!propertyAccessMethod.isSynthetic() && !this.isMarkedInternal(propertyAccessMethod)) {
                        this.handle = MethodHandles.insertArguments(IndyGuardsFiltersAndSignatures.GROOVY_OBJECT_GET_PROPERTY, 1, this.name);
                        return;
                    }
                }
                catch (ReflectiveOperationException propertyAccessMethod) {}
            } else if (receiver instanceof Class) {
                this.handle = IndyGuardsFiltersAndSignatures.MOP_GET;
                this.handle = MethodHandles.insertArguments(this.handle, 2, this.name);
                this.handle = MethodHandles.insertArguments(this.handle, 0, this.mc);
                return;
            }
            if (this.method != null || mci == null) {
                return;
            }
            this.selectionBase = this.sender;
            if (this.sender != mci.getTheClass()) {
                if (GroovyCategorySupport.hasCategoryInCurrentThread()) {
                    this.selectionBase = mci.getTheClass();
                } else {
                    Class<?> thisType = Selector.getThisType(this.sender);
                    if (thisType.isInstance(receiver)) {
                        this.selectionBase = thisType;
                    }
                }
            }
            if (IndyInterface.LOG_ENABLED) {
                IndyInterface.LOG.info("selectionBase set to " + this.selectionBase);
            }
            if ((mp = mci.getEffectiveGetMetaProperty(this.selectionBase, receiver, this.name, false)) instanceof MethodMetaProperty) {
                this.method = ((MethodMetaProperty)mp).getMetaMethod();
                this.insertName = true;
            } else if (mp instanceof CachedField && !mp.isStatic()) {
                try {
                    MethodHandles.Lookup lookup = ((Java8)VMPluginFactory.getPlugin()).newLookup(this.sender);
                    this.handle = ((CachedField)mp).asAccessMethod(lookup);
                }
                catch (IllegalAccessException e) {
                    throw new GroovyBugError(e);
                }
            } else {
                this.handle = IndyGuardsFiltersAndSignatures.META_PROPERTY_GETTER.bindTo(mp);
            }
        }

        private boolean isMarkedInternal(Method reflectionMethod) {
            return reflectionMethod.getAnnotation(Internal.class) != null;
        }

        @Override
        public void setHandleForMetaMethod() {
            if (this.handle != null) {
                return;
            }
            super.setHandleForMetaMethod();
            if (this.handle != null && this.insertName && this.handle.type().parameterCount() == 2) {
                this.handle = MethodHandles.insertArguments(this.handle, 1, this.name);
            }
        }

        @Override
        public void setMetaClassCallHandleIfNeeded(boolean standardMetaClass) {
            if (this.handle != null) {
                return;
            }
            this.useMetaClass = true;
            if (IndyInterface.LOG_ENABLED) {
                IndyInterface.LOG.info("set meta class invocation path for property get.");
            }
            this.handle = MethodHandles.insertArguments(IndyGuardsFiltersAndSignatures.MOP_GET, 2, this.name);
            this.handle = MethodHandles.insertArguments(this.handle, 0, this.mc);
        }
    }

    private static class CastSelector
    extends MethodSelector {
        private final Class<?> staticSourceType;
        private final Class<?> staticTargetType;

        public CastSelector(CacheableCallSite callSite, Object[] arguments) {
            super(callSite, Selector.class, "", IndyInterface.CallType.CAST, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, arguments);
            this.staticSourceType = callSite.type().parameterType(0);
            this.staticTargetType = callSite.type().returnType();
        }

        @Override
        public void setCallSiteTarget() {
            this.handleBoolean();
            this.handleNullWithoutBoolean();
            this.handleInstanceCase();
            this.handleCollections();
            this.handleSAM();
            this.castToTypeFallBack();
            if (!this.handle.type().equals((Object)this.callSite.type())) {
                this.castAndSetGuards();
            }
        }

        private void castAndSetGuards() {
            this.handle = MethodHandles.explicitCastArguments(this.handle, this.targetType);
            this.setGuards(this.args[0]);
            this.doCallSiteTargetSet();
        }

        private void handleNullWithoutBoolean() {
            if (this.handle != null || this.args[0] != null) {
                return;
            }
            if (this.staticTargetType.isPrimitive()) {
                this.handle = MethodHandles.insertArguments(IndyGuardsFiltersAndSignatures.GROOVY_CAST_EXCEPTION, 1, this.staticTargetType);
                this.castAndSetGuards();
            } else {
                this.handle = MethodHandles.identity(this.staticSourceType);
            }
        }

        private void handleInstanceCase() {
            if (this.handle != null) {
                return;
            }
            if (this.staticTargetType.isAssignableFrom(this.args[0].getClass())) {
                this.handle = MethodHandles.identity(this.staticSourceType);
            }
        }

        private static boolean isAbstractClassOf(Class<?> toTest, Class<?> givenOnCallSite) {
            if (!toTest.isAssignableFrom(givenOnCallSite)) {
                return false;
            }
            if (givenOnCallSite.isInterface()) {
                return true;
            }
            return Modifier.isAbstract(givenOnCallSite.getModifiers());
        }

        private void handleCollections() {
            if (this.handle != null) {
                return;
            }
            if (!(this.args[0] instanceof Collection)) {
                return;
            }
            if (CastSelector.isAbstractClassOf(HashSet.class, this.staticTargetType)) {
                this.handle = IndyGuardsFiltersAndSignatures.HASHSET_CONSTRUCTOR;
            } else if (CastSelector.isAbstractClassOf(ArrayList.class, this.staticTargetType)) {
                this.handle = IndyGuardsFiltersAndSignatures.ARRAYLIST_CONSTRUCTOR;
            }
        }

        private void handleSAM() {
            if (this.handle != null) {
                return;
            }
            if (!(this.args[0] instanceof Closure)) {
                return;
            }
            Method m = CachedSAMClass.getSAMMethod(this.staticTargetType);
            if (m == null) {
                return;
            }
            this.handle = MethodHandles.insertArguments(IndyGuardsFiltersAndSignatures.SAM_CONVERSION, 1, m, this.staticTargetType);
        }

        private void castToTypeFallBack() {
            if (this.handle != null) {
                return;
            }
            this.handle = MethodHandles.insertArguments(IndyGuardsFiltersAndSignatures.DTT_CAST_TO_TYPE, 1, this.staticTargetType);
        }

        private void handleBoolean() {
            boolean primitive;
            if (this.handle != null) {
                return;
            }
            boolean bl = primitive = this.staticTargetType == Boolean.TYPE;
            if (!primitive && this.staticTargetType != Boolean.class) {
                return;
            }
            MethodHandle ifNull = IndyGuardsFiltersAndSignatures.IS_NULL.asType(MethodType.methodType(Boolean.TYPE, this.staticSourceType));
            MethodHandle thenZero = primitive ? MethodHandles.dropArguments(MethodHandles.constant(Boolean.TYPE, Boolean.FALSE), 0, new Class[]{this.staticSourceType}) : MethodHandles.identity(this.staticSourceType).asType(MethodType.methodType(Boolean.class, this.staticSourceType));
            this.name = "asBoolean";
            super.setCallSiteTarget();
            MethodHandle elseCallAsBoolean = this.handle;
            this.handle = MethodHandles.guardWithTest(ifNull, thenZero, elseCallAsBoolean);
        }
    }

    private static class InterfaceSelector
    extends MethodSelector {
        public InterfaceSelector(CacheableCallSite callSite, Class<?> sender, String methodName, IndyInterface.CallType callType, boolean safeNavigation, boolean thisCall, boolean spreadCall, Object[] arguments) {
            super(callSite, sender, methodName, callType, safeNavigation, thisCall, spreadCall, arguments);
        }

        @Override
        public MetaClass getMetaClass() {
            this.mc = GroovySystem.getMetaClassRegistry().getMetaClass((Class)this.targetType.parameterType(0));
            this.mc.initialize();
            if (IndyInterface.LOG_ENABLED) {
                IndyInterface.LOG.info("meta class is " + this.mc);
            }
            return this.mc;
        }

        @Override
        public void setSelectionBase() {
            this.selectionBase = this.mc.getTheClass();
            if (IndyInterface.LOG_ENABLED) {
                IndyInterface.LOG.info("selectionBase set to " + this.selectionBase);
            }
        }

        @Override
        public MethodHandle unreflect(Method cachedMethod) throws IllegalAccessException {
            return this.callSite.getLookup().unreflectSpecial(cachedMethod, this.sender);
        }
    }
}

