/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.fineract.infrastructure.bulkimport.constants;

public final class LoanRepaymentConstants {

    private LoanRepaymentConstants() {

    }

    public static final int OFFICE_NAME_COL = 0;// A
    public static final int CLIENT_NAME_COL = 1;// B
    public static final int CLIENT_EXTERNAL_ID = 2;// C
    public static final int LOAN_ACCOUNT_NO_COL = 3;// D
    public static final int PRODUCT_COL = 4;// E
    public static final int PRINCIPAL_COL = 5;// F
    public static final int TOTAL_OUTSTANDING_AMOUNT_COL = 6;
    public static final int LOAN_DISBURSEMENT_DATE_COL = 7;
    public static final int AMOUNT_COL = 8;// G
    public static final int REPAID_ON_DATE_COL = 9;// H
    public static final int REPAYMENT_TYPE_COL = 10;// I
    public static final int ACCOUNT_NO_COL = 11;// J
    public static final int CHECK_NO_COL = 12;// K
    public static final int ROUTING_CODE_COL = 13;// L
    public static final int RECEIPT_NO_COL = 14;// M
    public static final int BANK_NO_COL = 15;// N
    public static final int STATUS_COL = 16;// O
    public static final int LOOKUP_CLIENT_NAME_COL = 17;// P
    public static final int LOOKUP_CLIENT_EXTERNAL_ID = 18;// Q
    public static final int LOOKUP_ACCOUNT_NO_COL = 19;// R
    public static final int LOOKUP_PRODUCT_COL = 20;// S
    public static final int LOOKUP_PRINCIPAL_COL = 21;// T
    public static final int LOOKUP_TOTAL_OUTSTANDING_AMOUNT_COL = 22;
    public static final int LOOKUP_LOAN_DISBURSEMENT_DATE_COL = 23;// U
}
