/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.processors;

import org.apache.daffodil.io.processors.charset.BitsCharset;
import org.apache.daffodil.io.processors.charset.BitsCharsetUTF8$;
import org.apache.daffodil.io.processors.charset.CharsetUtils$;
import org.apache.daffodil.io.processors.charset.StandardBitsCharsets$;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.util.MaybeInt$;
import org.apache.daffodil.runtime1.processors.CharsetEv;

public interface KnownEncodingMixin {
    public static void $init$(KnownEncodingMixin $this) {
    }

    public boolean isKnownEncoding();

    public CharsetEv charsetEv();

    public int knownEncodingAlignmentInBits();

    public static String knownEncodingName$(KnownEncodingMixin $this) {
        return $this.knownEncodingName();
    }

    default public String knownEncodingName() {
        if (!this.isKnownEncoding()) {
            throw Assert$.MODULE$.abort("Invariant broken: KnownEncodingMixin.this.isKnownEncoding");
        }
        String res = ((BitsCharset)this.charsetEv().optConstant().get()).name();
        return res;
    }

    public static BitsCharset knownEncodingCharset$(KnownEncodingMixin $this) {
        return $this.knownEncodingCharset();
    }

    default public BitsCharset knownEncodingCharset() {
        return CharsetUtils$.MODULE$.getCharset(this.knownEncodingName());
    }

    public static boolean knownEncodingIsFixedWidth$(KnownEncodingMixin $this) {
        return $this.knownEncodingIsFixedWidth();
    }

    default public boolean knownEncodingIsFixedWidth() {
        if (!this.isKnownEncoding()) {
            return false;
        }
        long maybeFixedWidth = this.knownEncodingCharset().maybeFixedWidth();
        return MaybeInt$.MODULE$.isDefined$extension(maybeFixedWidth);
    }

    public static int knownEncodingWidthInBits$(KnownEncodingMixin $this) {
        return $this.knownEncodingWidthInBits();
    }

    default public int knownEncodingWidthInBits() {
        return this.encodingMinimumCodePointWidthInBits(this.knownEncodingCharset());
    }

    public static int encodingMinimumCodePointWidthInBits$(KnownEncodingMixin $this, BitsCharset cs) {
        return $this.encodingMinimumCodePointWidthInBits(cs);
    }

    default public int encodingMinimumCodePointWidthInBits(BitsCharset cs) {
        BitsCharset bitsCharset = cs;
        BitsCharsetUTF8$ bitsCharsetUTF8$ = StandardBitsCharsets$.MODULE$.UTF_8();
        BitsCharset bitsCharset2 = bitsCharset;
        int res = !(bitsCharsetUTF8$ != null ? !((Object)bitsCharsetUTF8$).equals(bitsCharset2) : bitsCharset2 != null) ? 8 : MaybeInt$.MODULE$.get$extension(cs.maybeFixedWidth());
        return res;
    }

    public static boolean knownEncodingIsUnicode$(KnownEncodingMixin $this) {
        return $this.knownEncodingIsUnicode();
    }

    default public boolean knownEncodingIsUnicode() {
        if (!this.isKnownEncoding()) {
            return false;
        }
        return this.knownEncodingName().toUpperCase().startsWith("UTF");
    }

    public static boolean mustBeAnEncodingWith8BitAlignment$(KnownEncodingMixin $this) {
        return $this.mustBeAnEncodingWith8BitAlignment();
    }

    default public boolean mustBeAnEncodingWith8BitAlignment() {
        return !this.isKnownEncoding() || this.knownEncodingAlignmentInBits() == 8;
    }

    public static boolean couldBeVariableWidthEncoding$(KnownEncodingMixin $this) {
        return $this.couldBeVariableWidthEncoding();
    }

    default public boolean couldBeVariableWidthEncoding() {
        return !this.knownEncodingIsFixedWidth();
    }

    public static long knownFixedWidthEncodingInCharsToBits$(KnownEncodingMixin $this, long nChars) {
        return $this.knownFixedWidthEncodingInCharsToBits(nChars);
    }

    default public long knownFixedWidthEncodingInCharsToBits(long nChars) {
        if (!this.isKnownEncoding()) {
            throw Assert$.MODULE$.usageError("KnownEncodingMixin.this.isKnownEncoding");
        }
        if (!this.knownEncodingIsFixedWidth()) {
            throw Assert$.MODULE$.usageError("KnownEncodingMixin.this.knownEncodingIsFixedWidth");
        }
        long nBits = (long)this.knownEncodingWidthInBits() * nChars;
        return nBits;
    }
}

