/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ClusterTopologyListener;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.postoffice.DuplicateIDCache;
import org.apache.activemq.artemis.core.postoffice.impl.PostOfficeImpl;
import org.apache.activemq.artemis.core.remoting.server.RemotingService;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.NodeLocator;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.cluster.ActiveMQServerSideProtocolManagerFactory;
import org.apache.activemq.artemis.core.server.cluster.ha.PrimaryOnlyPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.ScaleDownPolicy;
import org.apache.activemq.artemis.core.server.impl.Activation;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.AnyNodeLocatorForScaleDown;
import org.apache.activemq.artemis.core.server.impl.NamedNodeLocatorForScaleDown;
import org.apache.activemq.artemis.core.server.impl.ScaleDownHandler;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.ClientProtocolManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimaryOnlyActivation
extends Activation {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PrimaryOnlyPolicy primaryOnlyPolicy;
    private final ActiveMQServerImpl activeMQServer;
    private ServerLocatorInternal scaleDownServerLocator;
    private ClientSessionFactoryInternal scaleDownClientSessionFactory;

    public PrimaryOnlyActivation(ActiveMQServerImpl server, PrimaryOnlyPolicy primaryOnlyPolicy) {
        this.activeMQServer = server;
        this.primaryOnlyPolicy = primaryOnlyPolicy;
    }

    public PrimaryOnlyPolicy getPrimaryOnlyPolicy() {
        return this.primaryOnlyPolicy;
    }

    @Override
    public void run() {
        try {
            this.activeMQServer.initialisePart1(false);
            this.activeMQServer.registerActivateCallback(this.activeMQServer.getNodeManager().startPrimaryNode());
            if (this.activeMQServer.getState() == ActiveMQServer.SERVER_STATE.STOPPED || this.activeMQServer.getState() == ActiveMQServer.SERVER_STATE.STOPPING) {
                return;
            }
            this.activeMQServer.initialisePart2(false);
            this.activeMQServer.completeActivation(false);
            if (this.activeMQServer.getIdentity() != null) {
                ActiveMQServerLogger.LOGGER.serverIsActive(this.activeMQServer.getIdentity());
            } else {
                ActiveMQServerLogger.LOGGER.serverIsActive();
            }
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.initializationError(e);
            this.activeMQServer.callActivationFailureListeners(e);
        }
    }

    @Override
    public void close(boolean permanently, boolean restarting) throws Exception {
        NodeManager nodeManagerInUse;
        if (this.scaleDownServerLocator != null) {
            this.scaleDownServerLocator.close();
            this.scaleDownServerLocator = null;
        }
        if ((nodeManagerInUse = this.activeMQServer.getNodeManager()) != null) {
            if (permanently) {
                nodeManagerInUse.crashPrimaryServer();
            } else {
                nodeManagerInUse.pausePrimaryServer();
            }
        }
    }

    @Override
    public void freezeConnections(RemotingService remotingService) {
        String nodeID;
        if (this.primaryOnlyPolicy.getScaleDownPolicy() != null && this.primaryOnlyPolicy.getScaleDownPolicy().isEnabled()) {
            this.connectToScaleDownTarget(this.primaryOnlyPolicy.getScaleDownPolicy());
        }
        RemotingConnection rc = this.scaleDownClientSessionFactory == null ? null : this.scaleDownClientSessionFactory.getConnection();
        String string = nodeID = rc == null ? null : this.scaleDownClientSessionFactory.getServerLocator().getTopology().getMember(rc).getNodeId();
        if (remotingService != null) {
            remotingService.freeze(nodeID, null);
        }
    }

    @Override
    public void postConnectionFreeze() {
        if (this.primaryOnlyPolicy.getScaleDownPolicy() != null && this.primaryOnlyPolicy.getScaleDownPolicy().isEnabled() && this.scaleDownClientSessionFactory != null) {
            try {
                this.scaleDown(this.primaryOnlyPolicy.getScaleDownPolicy().getCommitInterval());
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.failedToScaleDown(e);
            }
            finally {
                this.scaleDownClientSessionFactory.close();
                this.scaleDownServerLocator.close();
            }
        }
    }

    public void connectToScaleDownTarget(ScaleDownPolicy scaleDownPolicy) {
        try {
            this.scaleDownServerLocator = ScaleDownPolicy.getScaleDownConnector(scaleDownPolicy, this.activeMQServer);
            this.scaleDownServerLocator.setProtocolManagerFactory((ClientProtocolManagerFactory)ActiveMQServerSideProtocolManagerFactory.getInstance((ServerLocator)this.scaleDownServerLocator, this.activeMQServer.getStorageManager()));
            NodeLocator nodeLocator = scaleDownPolicy.getGroupName() == null ? new AnyNodeLocatorForScaleDown(this.activeMQServer) : new NamedNodeLocatorForScaleDown(scaleDownPolicy.getGroupName(), this.activeMQServer);
            this.scaleDownServerLocator.addClusterTopologyListener((ClusterTopologyListener)nodeLocator);
            nodeLocator.connectToCluster(this.scaleDownServerLocator);
            nodeLocator.locateNode(10000L);
            ClientSessionFactoryInternal clientSessionFactory = null;
            if (nodeLocator instanceof AnyNodeLocatorForScaleDown && scaleDownPolicy.getConnectors() != null) {
                try {
                    clientSessionFactory = this.scaleDownServerLocator.connect();
                }
                catch (Exception e) {
                    logger.trace("Failed to connect to {}", (Object)scaleDownPolicy.getConnectors().get(0));
                    if (clientSessionFactory != null) {
                        clientSessionFactory.close();
                    }
                    clientSessionFactory = null;
                }
            }
            while (clientSessionFactory == null) {
                Pair<TransportConfiguration, TransportConfiguration> possiblePrimary = null;
                possiblePrimary = nodeLocator.getPrimaryConfiguration();
                if (possiblePrimary == null) break;
                try {
                    clientSessionFactory = (ClientSessionFactoryInternal)this.scaleDownServerLocator.createSessionFactory((TransportConfiguration)possiblePrimary.getA(), 0, false);
                }
                catch (Exception e) {
                    logger.trace("Failed to connect to {}", possiblePrimary.getA());
                    nodeLocator.notifyRegistrationFailed(false);
                    if (clientSessionFactory != null) {
                        clientSessionFactory.close();
                    }
                    clientSessionFactory = null;
                }
            }
            if (clientSessionFactory == null) {
                throw new ActiveMQException("Unable to connect to server for scale-down");
            }
            this.scaleDownClientSessionFactory = clientSessionFactory;
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.failedToScaleDown(e);
        }
    }

    public long scaleDown(int commitInterval) throws Exception {
        ScaleDownHandler scaleDownHandler = new ScaleDownHandler(this.activeMQServer.getPagingManager(), this.activeMQServer.getPostOffice(), this.activeMQServer.getNodeManager(), this.activeMQServer.getClusterManager().getClusterController(), this.activeMQServer.getStorageManager(), commitInterval);
        ConcurrentMap<SimpleString, DuplicateIDCache> duplicateIDCaches = ((PostOfficeImpl)this.activeMQServer.getPostOffice()).getDuplicateIDCaches();
        HashMap<SimpleString, List<Pair<byte[], Long>>> duplicateIDMap = new HashMap<SimpleString, List<Pair<byte[], Long>>>();
        for (SimpleString address : duplicateIDCaches.keySet()) {
            DuplicateIDCache duplicateIDCache = this.activeMQServer.getPostOffice().getDuplicateIDCache(address);
            duplicateIDMap.put(address, duplicateIDCache.getMap());
        }
        return scaleDownHandler.scaleDown((ClientSessionFactory)this.scaleDownClientSessionFactory, this.activeMQServer.getResourceManager(), duplicateIDMap, this.activeMQServer.getManagementService().getManagementAddress(), null);
    }
}

