/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view.predicate;

import org.apache.activemq.artemis.core.management.impl.view.ProducerField;
import org.apache.activemq.artemis.core.management.impl.view.predicate.ActiveMQFilterPredicate;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ServerProducer;

public class ProducerFilterPredicate
extends ActiveMQFilterPredicate<ServerProducer> {
    private ProducerField f;
    private final ActiveMQServer server;

    public ProducerFilterPredicate(ActiveMQServer server) {
        this.server = server;
    }

    @Override
    public boolean test(ServerProducer producer) {
        if (this.f == null) {
            return true;
        }
        return switch (this.f) {
            case ProducerField.ID -> this.matches(producer.getID());
            case ProducerField.CONNECTION_ID -> this.matches(producer.getConnectionID());
            case ProducerField.SESSION -> this.matches(producer.getSessionID());
            case ProducerField.USER -> this.matches(this.server.getSessionByID(producer.getSessionID()).getUsername());
            case ProducerField.VALIDATED_USER -> this.matches(this.server.getSessionByID(producer.getSessionID()).getValidatedUser());
            case ProducerField.ADDRESS -> this.matches(producer.getAddress() != null ? producer.getAddress() : this.server.getSessionByID(producer.getSessionID()).getDefaultAddress());
            case ProducerField.PROTOCOL -> this.matches(producer.getProtocol());
            case ProducerField.CLIENT_ID -> this.matches(this.server.getSessionByID(producer.getSessionID()).getRemotingConnection().getClientID());
            case ProducerField.LOCAL_ADDRESS -> this.matches(this.server.getSessionByID(producer.getSessionID()).getRemotingConnection().getTransportConnection().getLocalAddress());
            case ProducerField.REMOTE_ADDRESS -> this.matches(this.server.getSessionByID(producer.getSessionID()).getRemotingConnection().getTransportConnection().getRemoteAddress());
            default -> true;
        };
    }

    @Override
    public void setField(String field) {
        if (field != null && !field.isEmpty()) {
            this.f = ProducerField.valueOfName(field);
            if (this.f == null) {
                this.f = ProducerField.valueOf(field);
            }
        }
    }
}

