/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view;

import org.apache.activemq.artemis.api.core.management.AddressControl;
import org.apache.activemq.artemis.core.management.impl.view.ActiveMQAbstractView;
import org.apache.activemq.artemis.core.management.impl.view.AddressField;
import org.apache.activemq.artemis.core.management.impl.view.predicate.AddressFilterPredicate;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.json.JsonObjectBuilder;
import org.apache.activemq.artemis.utils.JsonLoader;

public class AddressView
extends ActiveMQAbstractView<AddressControl> {
    private static final String defaultSortField = AddressField.ID.getName();
    private final ActiveMQServer server;

    public AddressView(ActiveMQServer server) {
        this.server = server;
        this.predicate = new AddressFilterPredicate(server);
    }

    @Override
    public Class getClassT() {
        return AddressControl.class;
    }

    @Override
    public JsonObjectBuilder toJson(AddressControl address) {
        if (address == null) {
            return null;
        }
        JsonObjectBuilder obj = JsonLoader.createObjectBuilder().add(AddressField.ID.getName(), this.toString(address.getId())).add(AddressField.NAME.getName(), this.toString(address.getAddress())).add(AddressField.ROUTING_TYPES.getName(), this.toString(address.getRoutingTypesAsJSON())).add(AddressField.QUEUE_COUNT.getName(), this.toString(address.getQueueCount())).add(AddressField.INTERNAL.getName(), this.toString(address.isInternal())).add(AddressField.TEMPORARY.getName(), this.toString(address.isTemporary())).add(AddressField.AUTO_CREATED.getName(), this.toString(address.isAutoCreated())).add(AddressField.PAUSED.getName(), this.toString(address.isPaused())).add(AddressField.CURRENT_DUPLICATE_ID_CACHE_SIZE.getName(), this.toString(address.getCurrentDuplicateIdCacheSize())).add(AddressField.RETROACTIVE_RESOURCE.getName(), this.toString(address.isRetroactiveResource())).add(AddressField.UNROUTED_MESSAGE_COUNT.getName(), this.toString(address.getUnRoutedMessageCount())).add(AddressField.ROUTED_MESSAGE_COUNT.getName(), this.toString(address.getRoutedMessageCount())).add(AddressField.MESSAGE_COUNT.getName(), this.toString(address.getMessageCount())).add(AddressField.ADDRESS_LIMIT_PERCENT.getName(), this.toString(address.getAddressLimitPercent())).add(AddressField.NUMBER_OF_PAGES.getName(), this.toString(address.getNumberOfPages())).add(AddressField.ADDRESS_SIZE.getName(), this.toString(address.getAddressSize())).add(AddressField.MAX_PAGE_READ_BYTES.getName(), this.toString(address.getMaxPageReadBytes())).add(AddressField.MAX_PAGE_READ_MESSAGES.getName(), this.toString(address.getMaxPageReadMessages())).add(AddressField.PREFETCH_PAGE_BYTES.getName(), this.toString(address.getPrefetchPageBytes())).add(AddressField.PREFETCH_PAGE_MESSAGES.getName(), this.toString(address.getPrefetchPageBytes()));
        try {
            obj.add(AddressField.NUMBER_OF_BYTES_PER_PAGE.getName(), this.toString(address.getNumberOfBytesPerPage()));
        }
        catch (Exception e) {
            obj.add(AddressField.NUMBER_OF_BYTES_PER_PAGE.getName(), "n/a");
        }
        try {
            obj.add(AddressField.PAGING.getName(), this.toString(address.isPaging()));
        }
        catch (Exception e) {
            obj.add(AddressField.PAGING.getName(), "n/a");
        }
        return obj;
    }

    @Override
    public Object getField(AddressControl address, String fieldName) {
        if (address == null) {
            return null;
        }
        return switch (AddressField.valueOfName(fieldName)) {
            case AddressField.ID -> {
                Long var3_3 = address.getId();
                yield var3_3;
            }
            case AddressField.NAME -> {
                String[] var3_4;
                yield var3_4 = address.getAddress();
            }
            case AddressField.ROUTING_TYPES -> {
                String[] var3_5;
                yield var3_5 = address.getRoutingTypes();
            }
            case AddressField.QUEUE_COUNT -> {
                Long var3_6 = address.getQueueCount();
                yield var3_6;
            }
            case AddressField.INTERNAL -> {
                Boolean var3_7 = address.isInternal();
                yield var3_7;
            }
            case AddressField.TEMPORARY -> {
                Boolean var3_8 = address.isTemporary();
                yield var3_8;
            }
            case AddressField.AUTO_CREATED -> {
                Boolean var3_9 = address.isAutoCreated();
                yield var3_9;
            }
            case AddressField.PAUSED -> {
                Boolean var3_10 = address.isPaused();
                yield var3_10;
            }
            case AddressField.CURRENT_DUPLICATE_ID_CACHE_SIZE -> {
                Long var3_11 = address.getCurrentDuplicateIdCacheSize();
                yield var3_11;
            }
            case AddressField.RETROACTIVE_RESOURCE -> {
                Boolean var3_12 = address.isRetroactiveResource();
                yield var3_12;
            }
            case AddressField.UNROUTED_MESSAGE_COUNT -> {
                Long var3_13 = address.getUnRoutedMessageCount();
                yield var3_13;
            }
            case AddressField.ROUTED_MESSAGE_COUNT -> {
                Long var3_14 = address.getRoutedMessageCount();
                yield var3_14;
            }
            case AddressField.MESSAGE_COUNT -> {
                Long var3_15 = address.getMessageCount();
                yield var3_15;
            }
            case AddressField.NUMBER_OF_BYTES_PER_PAGE -> {
                try {
                    Long var3_16 = address.getNumberOfBytesPerPage();
                    yield var3_16;
                }
                catch (Exception e) {
                    String var3_17 = "n/a";
                    yield var3_17;
                }
            }
            case AddressField.ADDRESS_LIMIT_PERCENT -> {
                Integer var3_18 = address.getAddressLimitPercent();
                yield var3_18;
            }
            case AddressField.PAGING -> {
                try {
                    Boolean var3_19 = address.isPaging();
                    yield var3_19;
                }
                catch (Exception e) {
                    String var3_20 = "n/a";
                    yield var3_20;
                }
            }
            case AddressField.NUMBER_OF_PAGES -> {
                Long var3_21 = address.getNumberOfPages();
                yield var3_21;
            }
            case AddressField.ADDRESS_SIZE -> {
                Long var3_22 = address.getAddressSize();
                yield var3_22;
            }
            case AddressField.MAX_PAGE_READ_BYTES -> {
                Integer var3_23 = address.getMaxPageReadBytes();
                yield var3_23;
            }
            case AddressField.MAX_PAGE_READ_MESSAGES -> {
                Integer var3_24 = address.getMaxPageReadMessages();
                yield var3_24;
            }
            case AddressField.PREFETCH_PAGE_BYTES -> {
                Integer var3_25 = address.getPrefetchPageBytes();
                yield var3_25;
            }
            case AddressField.PREFETCH_PAGE_MESSAGES -> {
                Integer var3_26 = address.getPrefetchPageBytes();
                yield var3_26;
            }
            default -> throw new IllegalArgumentException("Unsupported field, " + fieldName);
        };
    }

    @Override
    public String getDefaultOrderColumn() {
        return defaultSortField;
    }
}

