/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config;

import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.activemq.artemis.json.JsonObject;
import org.apache.activemq.artemis.json.JsonObjectBuilder;
import org.apache.activemq.artemis.json.JsonString;
import org.apache.activemq.artemis.json.JsonValue;
import org.apache.activemq.artemis.utils.JsonLoader;

public final class TransformerConfiguration
implements Serializable {
    private static final long serialVersionUID = -1057244274380572226L;
    public static final String CLASS_NAME = "class-name";
    public static final String PROPERTIES = "properties";
    private String className;
    private Map<String, String> properties = new HashMap<String, String>();

    public TransformerConfiguration(String className) {
        this.className = className;
    }

    public TransformerConfiguration() {
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public static TransformerConfiguration fromJSON(String jsonString) {
        JsonObject json = JsonLoader.readObject((Reader)new StringReader(jsonString));
        if (!json.containsKey((Object)CLASS_NAME)) {
            return null;
        }
        TransformerConfiguration result = new TransformerConfiguration(json.getString(CLASS_NAME));
        if (json.containsKey((Object)PROPERTIES)) {
            HashMap<String, String> properties = new HashMap<String, String>();
            for (Map.Entry propEntry : json.getJsonObject(PROPERTIES).entrySet()) {
                if (((JsonValue)propEntry.getValue()).getValueType() == JsonValue.ValueType.STRING) {
                    properties.put((String)propEntry.getKey(), ((JsonString)propEntry.getValue()).getString());
                    continue;
                }
                properties.put((String)propEntry.getKey(), ((JsonValue)propEntry.getValue()).toString());
            }
            result.setProperties(properties);
        }
        return result;
    }

    public JsonObjectBuilder createJsonObjectBuilder() {
        JsonObjectBuilder tcBuilder = JsonLoader.createObjectBuilder().add(CLASS_NAME, this.getClassName());
        if (this.getProperties() != null && !this.getProperties().isEmpty()) {
            JsonObjectBuilder propBuilder = JsonLoader.createObjectBuilder();
            this.getProperties().forEach((arg_0, arg_1) -> ((JsonObjectBuilder)propBuilder).add(arg_0, arg_1));
            tcBuilder.add(PROPERTIES, propBuilder);
        }
        return tcBuilder;
    }

    public TransformerConfiguration setProperties(Map<String, String> properties) {
        if (properties != null) {
            this.properties.putAll(properties);
        }
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.className, this.properties);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TransformerConfiguration)) {
            return false;
        }
        TransformerConfiguration other = (TransformerConfiguration)obj;
        return Objects.equals(this.className, other.className) && Objects.equals(this.properties, other.properties);
    }

    public String toString() {
        return "TransformerConfiguration [className=" + this.className + ", properties=" + String.valueOf(this.properties) + "]";
    }
}

