/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.postoffice.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.Address;
import org.apache.activemq.artemis.core.postoffice.AddressManager;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.Bindings;
import org.apache.activemq.artemis.core.postoffice.BindingsFactory;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.postoffice.impl.AddressImpl;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.metrics.MetricsManager;
import org.apache.activemq.artemis.core.server.mirror.MirrorController;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleAddressManager
implements AddressManager {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ConcurrentMap<SimpleString, AddressInfo> addressInfoMap = new ConcurrentHashMap<SimpleString, AddressInfo>();
    private final StorageManager storageManager;
    private final ConcurrentMap<Long, LocalQueueBinding> localBindingsMap = new ConcurrentHashMap<Long, LocalQueueBinding>();
    protected final ConcurrentMap<SimpleString, Bindings> mappings = new ConcurrentHashMap<SimpleString, Bindings>();
    private final ConcurrentMap<SimpleString, Pair<Binding, Address>> nameMap = new ConcurrentHashMap<SimpleString, Pair<Binding, Address>>();
    private final ConcurrentMap<SimpleString, Collection<Binding>> directBindingMap = new ConcurrentHashMap<SimpleString, Collection<Binding>>();
    private final BindingsFactory bindingsFactory;
    protected final MetricsManager metricsManager;
    protected final WildcardConfiguration wildcardConfiguration;

    public SimpleAddressManager(BindingsFactory bindingsFactory, StorageManager storageManager, MetricsManager metricsManager) {
        this(bindingsFactory, new WildcardConfiguration(), storageManager, metricsManager);
    }

    public SimpleAddressManager(BindingsFactory bindingsFactory, WildcardConfiguration wildcardConfiguration, StorageManager storageManager, MetricsManager metricsManager) {
        this.wildcardConfiguration = wildcardConfiguration;
        this.bindingsFactory = bindingsFactory;
        this.storageManager = storageManager;
        this.metricsManager = metricsManager;
    }

    @Override
    public LocalQueueBinding findLocalBinding(long bindingID) {
        return (LocalQueueBinding)this.localBindingsMap.get(bindingID);
    }

    @Override
    public boolean addBinding(Binding binding) throws Exception {
        Pair bindingAddressPair = new Pair((Object)binding, (Object)new AddressImpl(binding.getAddress(), this.wildcardConfiguration));
        if (this.nameMap.putIfAbsent(binding.getUniqueName(), (Pair<Binding, Address>)bindingAddressPair) != null) {
            throw ActiveMQMessageBundle.BUNDLE.bindingAlreadyExists(binding);
        }
        this.directBindingMap.compute(binding.getAddress(), (key, value) -> {
            Collection bindingList = Objects.requireNonNullElseGet(value, () -> new ArrayList());
            bindingList.add(binding);
            return bindingList;
        });
        if (logger.isTraceEnabled()) {
            logger.trace("Adding binding {} with address = {}", new Object[]{binding, binding.getUniqueName(), new Exception("trace")});
        }
        return this.addMappingInternal(binding.getAddress(), binding);
    }

    @Override
    public Binding removeBinding(SimpleString uniqueName, Transaction tx) throws Exception {
        Pair binding = (Pair)this.nameMap.remove(uniqueName);
        if (binding == null) {
            return null;
        }
        SimpleString address = ((Binding)binding.getA()).getAddress();
        this.removeBindingInternal(address, uniqueName);
        this.directBindingMap.compute(address, (key, value) -> {
            if (value == null) {
                return null;
            }
            value.remove(binding.getA());
            if (value.isEmpty()) {
                return null;
            }
            return value;
        });
        return (Binding)binding.getA();
    }

    @Override
    public Bindings getExistingBindingsForRoutingAddress(SimpleString address) throws Exception {
        return (Bindings)this.mappings.get(CompositeAddress.extractAddressName((SimpleString)address));
    }

    @Override
    public Bindings getBindingsForRoutingAddress(SimpleString address) throws Exception {
        return (Bindings)this.mappings.get(CompositeAddress.extractAddressName((SimpleString)address));
    }

    @Override
    public Binding getBinding(SimpleString bindableName) {
        Pair bindingAddressPair = (Pair)this.nameMap.get(CompositeAddress.extractQueueName((SimpleString)bindableName));
        return bindingAddressPair == null ? null : (Binding)bindingAddressPair.getA();
    }

    @Override
    public Stream<Binding> getBindings() {
        return this.nameMap.values().stream().map(pair -> (Binding)pair.getA());
    }

    @Override
    public Collection<Binding> getMatchingBindings(SimpleString address) throws Exception {
        SimpleString realAddress = CompositeAddress.extractAddressName((SimpleString)address);
        AddressImpl add = new AddressImpl(realAddress, this.wildcardConfiguration);
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        this.nameMap.forEach((bindingUniqueName, bindingAddressPair) -> {
            Address addCheck = (Address)bindingAddressPair.getB();
            if (addCheck.matches(add)) {
                bindings.add((Binding)bindingAddressPair.getA());
            }
        });
        return bindings;
    }

    @Override
    public Collection<Binding> getDirectBindings(SimpleString address) throws Exception {
        SimpleString realAddress = CompositeAddress.extractAddressName((SimpleString)address);
        ArrayList outputList = new ArrayList();
        this.directBindingMap.compute(realAddress, (key, bindings) -> {
            if (bindings != null) {
                outputList.addAll(bindings);
            }
            return bindings;
        });
        return Collections.unmodifiableCollection(outputList);
    }

    @Override
    public SimpleString getMatchingQueue(SimpleString address, RoutingType routingType) throws Exception {
        Bindings bindings;
        SimpleString realAddress = CompositeAddress.extractAddressName((SimpleString)address);
        Binding binding = this.getBinding(realAddress);
        if (!(binding != null && binding instanceof LocalQueueBinding && binding.getAddress().equals((Object)realAddress) || (bindings = (Bindings)this.mappings.get(realAddress)) == null)) {
            for (Binding theBinding : bindings.getBindings()) {
                if (!(theBinding instanceof LocalQueueBinding) || this.wildcardConfiguration.isWild((CharSequence)theBinding.getUniqueName())) continue;
                binding = theBinding;
                break;
            }
        }
        return binding != null ? binding.getUniqueName() : null;
    }

    @Override
    public SimpleString getMatchingQueue(SimpleString address, SimpleString queueName, RoutingType routingType) throws Exception {
        SimpleString realAddress = CompositeAddress.extractAddressName((SimpleString)address);
        Binding binding = this.getBinding(queueName);
        if (binding != null && !binding.getAddress().equals((Object)realAddress) && !realAddress.toString().isEmpty()) {
            throw new IllegalStateException("queue belongs to address" + String.valueOf(binding.getAddress()));
        }
        return binding != null ? binding.getUniqueName() : null;
    }

    @Override
    public void clear() {
        this.nameMap.clear();
        this.mappings.clear();
    }

    @Override
    public Set<SimpleString> getAddresses() {
        HashSet<SimpleString> addresses = new HashSet<SimpleString>();
        addresses.addAll(this.addressInfoMap.keySet());
        return addresses;
    }

    protected void removeBindingInternal(SimpleString address, SimpleString bindableName) {
        SimpleString realAddress = CompositeAddress.extractAddressName((SimpleString)address);
        Bindings bindings = (Bindings)this.mappings.get(realAddress);
        if (bindings != null) {
            SimpleString bindableQueueName = CompositeAddress.extractQueueName((SimpleString)bindableName);
            Binding binding = bindings.removeBindingByUniqueName(bindableQueueName);
            if (binding == null) {
                throw new IllegalStateException("Cannot find binding " + String.valueOf(bindableName));
            }
            if (binding instanceof LocalQueueBinding) {
                this.localBindingsMap.remove(binding.getID());
            }
            if (bindings.getBindings().isEmpty()) {
                this.mappings.remove(realAddress);
                this.bindingsEmpty(realAddress, bindings);
            }
        }
    }

    protected void bindingsEmpty(SimpleString realAddress, Bindings bindings) {
    }

    protected Bindings addMappingsInternal(SimpleString address, Collection<Binding> newBindings) throws Exception {
        Bindings prevBindings;
        if (newBindings.isEmpty()) {
            return null;
        }
        SimpleString realAddress = CompositeAddress.extractAddressName((SimpleString)address);
        Bindings bindings = (Bindings)this.mappings.get(realAddress);
        if (bindings == null && (prevBindings = this.mappings.putIfAbsent(realAddress, bindings = this.bindingsFactory.createBindings(realAddress))) != null) {
            bindings = prevBindings;
        }
        for (Binding binding : newBindings) {
            bindings.addBinding(binding);
        }
        return bindings;
    }

    protected boolean addMappingInternal(SimpleString address, Binding binding) throws Exception {
        boolean addedNewBindings = false;
        SimpleString realAddress = CompositeAddress.extractAddressName((SimpleString)address);
        Bindings bindings = (Bindings)this.mappings.get(realAddress);
        if (bindings == null) {
            bindings = this.bindingsFactory.createBindings(realAddress);
            Bindings prevBindings = this.mappings.putIfAbsent(realAddress, bindings);
            if (prevBindings != null) {
                bindings = prevBindings;
            } else {
                addedNewBindings = true;
            }
        }
        bindings.addBinding(binding);
        if (binding instanceof LocalQueueBinding) {
            LocalQueueBinding localQueueBinding = (LocalQueueBinding)binding;
            this.localBindingsMap.put(binding.getID(), localQueueBinding);
        }
        return addedNewBindings;
    }

    @Override
    public boolean reloadAddressInfo(AddressInfo addressInfo) {
        return this.addressInfoMap.putIfAbsent(addressInfo.getName(), addressInfo) == null;
    }

    @Override
    public boolean addAddressInfo(AddressInfo addressInfo) throws Exception {
        boolean added = this.reloadAddressInfo(addressInfo);
        if (!addressInfo.isTemporary() && added && this.storageManager != null) {
            long txID = this.storageManager.generateID();
            try {
                this.storageManager.addAddressBinding(txID, addressInfo);
                this.storageManager.commitBindings(txID);
            }
            catch (Exception e) {
                try {
                    this.storageManager.rollbackBindings(txID);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e;
            }
        }
        return added;
    }

    @Override
    public AddressInfo updateAddressInfo(SimpleString addressName, EnumSet<RoutingType> routingTypes) throws Exception {
        SimpleString realAddressName = CompositeAddress.extractAddressName((SimpleString)addressName);
        AddressInfo info = (AddressInfo)this.addressInfoMap.get(realAddressName);
        if (info == null) {
            throw ActiveMQMessageBundle.BUNDLE.addressDoesNotExist(realAddressName);
        }
        if (routingTypes == null || this.isEquals(routingTypes, info.getRoutingTypes())) {
            return info;
        }
        this.validateRoutingTypes(realAddressName, routingTypes);
        EnumSet<RoutingType> updatedRoutingTypes = EnumSet.copyOf(routingTypes);
        info.setRoutingTypes(updatedRoutingTypes);
        if (this.storageManager != null) {
            long txID = this.storageManager.generateID();
            try {
                this.storageManager.deleteAddressBinding(txID, info.getId());
                this.storageManager.addAddressBinding(txID, info);
                this.storageManager.commitBindings(txID);
            }
            catch (Exception e) {
                try {
                    this.storageManager.rollbackBindings(txID);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw e;
            }
        }
        return info;
    }

    private boolean isEquals(Collection<RoutingType> set1, EnumSet<RoutingType> set2) {
        Set eset2;
        Set eset1 = set1 == null || set1.isEmpty() ? Collections.emptySet() : EnumSet.copyOf(set1);
        Set<Object> set = eset2 = set2 == null || set2.isEmpty() ? Collections.emptySet() : EnumSet.copyOf(set2);
        if (eset1.isEmpty() && eset2.isEmpty()) {
            return true;
        }
        if (eset1.size() != eset2.size()) {
            return false;
        }
        return eset2.containsAll(eset1);
    }

    private void validateRoutingTypes(SimpleString addressName, EnumSet<RoutingType> routingTypes) {
        Bindings bindings = (Bindings)this.mappings.get(addressName);
        if (bindings != null) {
            for (Binding binding : bindings.getBindings()) {
                RoutingType routingType;
                if (!(binding instanceof QueueBinding)) continue;
                QueueBinding queueBinding = (QueueBinding)binding;
                if (!binding.isLocal() || routingTypes.contains(routingType = queueBinding.getQueue().getRoutingType()) || !binding.getAddress().equals((Object)addressName)) continue;
                throw ActiveMQMessageBundle.BUNDLE.invalidRoutingTypeDelete(routingType, addressName.toString());
            }
        }
    }

    @Override
    public boolean checkAutoRemoveAddress(AddressInfo addressInfo, AddressSettings settings, boolean ignoreDelay) throws Exception {
        return !(settings.isAutoDeleteAddresses() == false || addressInfo == null || !addressInfo.isAutoCreated() || this.bindingsFactory.isAddressBound(addressInfo.getName()) || !ignoreDelay && !this.addressWasUsed(addressInfo, settings) || !ignoreDelay && !this.delayCheck(addressInfo, settings));
    }

    private boolean delayCheck(AddressInfo addressInfo, AddressSettings settings) {
        return !settings.isAutoDeleteAddressesSkipUsageCheck() && System.currentTimeMillis() - addressInfo.getBindingRemovedTimestamp() >= settings.getAutoDeleteAddressesDelay() || settings.isAutoDeleteAddressesSkipUsageCheck() && System.currentTimeMillis() - addressInfo.getCreatedTimestamp() >= settings.getAutoDeleteAddressesDelay();
    }

    private boolean addressWasUsed(AddressInfo addressInfo, AddressSettings settings) {
        return addressInfo.getBindingRemovedTimestamp() != -1L || settings.isAutoDeleteAddressesSkipUsageCheck();
    }

    @Override
    public AddressInfo removeAddressInfo(SimpleString address) throws Exception {
        return (AddressInfo)this.addressInfoMap.remove(CompositeAddress.extractAddressName((SimpleString)address));
    }

    @Override
    public AddressInfo getAddressInfo(SimpleString addressName) {
        return (AddressInfo)this.addressInfoMap.get(CompositeAddress.extractAddressName((SimpleString)addressName));
    }

    @Override
    public void scanAddresses(MirrorController mirrorController) throws Exception {
        for (AddressInfo info : this.addressInfoMap.values()) {
            Bindings bindings;
            if (!info.isInternal()) {
                mirrorController.addAddress(info);
            }
            if ((bindings = (Bindings)this.mappings.get(info.getName())) == null) continue;
            for (Binding binding : bindings.getBindings()) {
                LocalQueueBinding localQueueBinding;
                if (!(binding instanceof LocalQueueBinding) || (localQueueBinding = (LocalQueueBinding)binding).getQueue().isMirrorController() || localQueueBinding.getQueue().isInternalQueue()) continue;
                mirrorController.createQueue(localQueueBinding.getQueue().getQueueConfiguration());
            }
        }
    }
}

