/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.encryption.keys.content.derivedKey;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.util.ArrayList;
import org.apache.xml.security.algorithms.MessageDigestAlgorithm;
import org.apache.xml.security.encryption.XMLCipherUtil;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xml.security.encryption.keys.content.derivedKey.DerivationAlgorithm;
import org.apache.xml.security.encryption.params.ConcatKDFParams;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.utils.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcatKDF
implements DerivationAlgorithm<ConcatKDFParams> {
    private static final Logger LOG = LoggerFactory.getLogger((String)ConcatKDF.class.getName());

    @Override
    public byte[] deriveKey(byte[] sharedSecret, ConcatKDFParams concatKDFParams) throws XMLSecurityException {
        int toGenerateSize;
        int iDigestLength;
        if (concatKDFParams == null) {
            throw new IllegalArgumentException(I18n.translate("KeyDerivation.MissingParameters"));
        }
        byte[] otherInfo = ConcatKDF.concatParameters(concatKDFParams.getAlgorithmID(), concatKDFParams.getPartyUInfo(), concatKDFParams.getPartyVInfo(), concatKDFParams.getSuppPubInfo(), concatKDFParams.getSuppPrivInfo());
        MessageDigest digest = MessageDigestAlgorithm.getDigestInstance(concatKDFParams.getDigestAlgorithm());
        int genKeyLength = concatKDFParams.getKeyLength();
        if ((long)genKeyLength / (long)(iDigestLength = digest.getDigestLength()) > Integer.MAX_VALUE) {
            throw new XMLSecurityException("KeyDerivation.InvalidParameter", new Object[]{"key length"});
        }
        digest.reset();
        ByteBuffer indexBuffer = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN);
        ByteBuffer result = ByteBuffer.allocate(toGenerateSize);
        int counter = 1;
        for (toGenerateSize = genKeyLength; toGenerateSize > 0; toGenerateSize -= iDigestLength) {
            indexBuffer.position(0);
            indexBuffer.putInt(counter++);
            indexBuffer.position(0);
            digest.update(indexBuffer);
            digest.update(sharedSecret);
            if (otherInfo != null && otherInfo.length > 0) {
                digest.update(otherInfo);
            }
            result.put(digest.digest(), 0, Math.min(toGenerateSize, iDigestLength));
        }
        return result.array();
    }

    private static byte[] concatParameters(String ... parameters) throws XMLEncryptionException {
        ArrayList<byte[]> byteParams = new ArrayList<byte[]>();
        for (String parameter : parameters) {
            byte[] bytes = ConcatKDF.parseBitString(parameter);
            byteParams.add(bytes);
        }
        int iSize = byteParams.stream().map(ConcatKDF::getSize).reduce(0, Integer::sum);
        ByteBuffer buffer = ByteBuffer.allocate(iSize);
        byteParams.forEach(buffer::put);
        return buffer.array();
    }

    private static byte[] parseBitString(String kdfParameter) throws XMLEncryptionException {
        int iPadding;
        if (kdfParameter == null || kdfParameter.isEmpty()) {
            return new byte[0];
        }
        String kdfP = kdfParameter.trim();
        int paramLen = kdfP.length();
        if (paramLen < 4) {
            LOG.error("ConcatKDF parameter is to short");
            throw new XMLEncryptionException("KeyDerivation.TooShortParameter", kdfParameter);
        }
        if (paramLen % 2 != 0) {
            LOG.error("Invalid length of ConcatKDF parameter [{0}]!", (Object)kdfP);
            throw new XMLEncryptionException("KeyDerivation.InvalidParameter", kdfParameter);
        }
        String strPadding = kdfP.substring(0, 2);
        try {
            iPadding = Integer.parseInt(strPadding, 16);
        }
        catch (NumberFormatException e) {
            LOG.error("Invalid padding number: [{0}]! Number is not Hexadecimal!", (Object)strPadding);
            throw new XMLEncryptionException(e, "KeyDerivation.InvalidParameter", new Object[]{kdfParameter});
        }
        if (iPadding != 0) {
            LOG.error("Padded ConcatKDF parameters are not supported");
            throw new XMLEncryptionException("KeyDerivation.NotSupportedParameter", kdfParameter);
        }
        kdfP = kdfP.substring(2);
        return XMLCipherUtil.hexStringToByteArray(kdfP);
    }

    private static int getSize(byte[] array) {
        return array == null ? 0 : array.length;
    }
}

