/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ext.logging;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.ext.logging.MaskSensitiveHelper;
import org.apache.cxf.ext.logging.event.DefaultLogEventMapper;
import org.apache.cxf.ext.logging.event.LogEvent;
import org.apache.cxf.ext.logging.event.LogEventSender;
import org.apache.cxf.ext.logging.event.PrettyLoggingFilter;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

public abstract class AbstractLoggingInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final int DEFAULT_LIMIT = 49152;
    public static final int DEFAULT_THRESHOLD = -1;
    public static final String CONTENT_SUPPRESSED = "--- Content suppressed ---";
    protected static final String LIVE_LOGGING_PROP = "org.apache.cxf.logging.enable";
    private static final Pattern BOUNDARY_PATTERN = Pattern.compile("^--(\\S*)$", 8);
    private static final Pattern CONTENT_TYPE_PATTERN = Pattern.compile("Content-Type:.*?$", 40);
    protected int limit = 49152;
    protected long threshold = -1L;
    protected boolean logBinary;
    protected boolean logMultipart = true;
    protected LogEventSender sender;
    protected final DefaultLogEventMapper eventMapper;
    protected MaskSensitiveHelper maskSensitiveHelper = new MaskSensitiveHelper();
    protected Set<String> sensitiveProtocolHeaderNames = new HashSet<String>();

    public AbstractLoggingInterceptor(String phase, LogEventSender sender) {
        super(phase);
        this.sender = sender;
        this.eventMapper = new DefaultLogEventMapper(this.maskSensitiveHelper);
    }

    protected static boolean isLoggingDisabledNow(Message message) throws Fault {
        Object liveLoggingProp = message.getContextualProperty(LIVE_LOGGING_PROP);
        return liveLoggingProp != null && PropertyUtils.isFalse((Object)liveLoggingProp);
    }

    public void addBinaryContentMediaTypes(String mediaTypes) {
        this.eventMapper.addBinaryContentMediaTypes(mediaTypes);
    }

    public void setLimit(int lim) {
        this.limit = lim;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setInMemThreshold(long t) {
        this.threshold = t;
    }

    public long getInMemThreshold() {
        return this.threshold;
    }

    public void setSensitiveElementNames(Set<String> sensitiveElementNames) {
        this.maskSensitiveHelper.setSensitiveElementNames(sensitiveElementNames);
    }

    public void addSensitiveElementNames(Set<String> sensitiveElementNames) {
        this.maskSensitiveHelper.addSensitiveElementNames(sensitiveElementNames);
    }

    public void setSensitiveProtocolHeaderNames(Set<String> protocolHeaderNames) {
        this.sensitiveProtocolHeaderNames.clear();
        this.addSensitiveProtocolHeaderNames(protocolHeaderNames);
    }

    public void addSensitiveProtocolHeaderNames(Set<String> protocolHeaderNames) {
        this.sensitiveProtocolHeaderNames.addAll(protocolHeaderNames);
    }

    public void setSensitiveDataHelper(MaskSensitiveHelper helper) {
        this.maskSensitiveHelper = helper;
        this.eventMapper.setSensitiveDataHelper(helper);
    }

    public void setPrettyLogging(boolean prettyLogging) {
        if (this.sender instanceof PrettyLoggingFilter) {
            ((PrettyLoggingFilter)this.sender).setPrettyLogging(prettyLogging);
        }
    }

    protected boolean shouldLogContent(LogEvent event) {
        return event.isBinaryContent() && this.logBinary || event.isMultipartContent() && this.logMultipart || !event.isBinaryContent() && !event.isMultipartContent();
    }

    public void setLogBinary(boolean logBinary) {
        this.logBinary = logBinary;
    }

    public void setLogMultipart(boolean logMultipart) {
        this.logMultipart = logMultipart;
    }

    public void createExchangeId(Message message) {
        Exchange exchange = message.getExchange();
        String exchangeId = (String)exchange.get((Object)"exchangeId");
        if (exchangeId == null) {
            exchangeId = UUID.randomUUID().toString();
            exchange.put((Object)"exchangeId", (Object)exchangeId);
        }
    }

    protected String transform(Message message, String originalLogString) {
        return originalLogString;
    }

    protected String maskSensitiveElements(Message message, String originalLogString) {
        return this.maskSensitiveHelper.maskSensitiveElements(message, originalLogString);
    }

    protected String stripBinaryParts(LogEvent event, String originalLogString) {
        try {
            if (!this.logBinary && this.findBoundary(originalLogString) != null) {
                String boundary = this.findBoundary(originalLogString);
                String[] parts = originalLogString.split(Pattern.quote(boundary));
                Object payload = "";
                for (String str : parts) {
                    String contentType = this.findContentType(str);
                    if (contentType != null && this.eventMapper.isBinaryContent(contentType.substring("Content-Type:".length()).trim())) {
                        String headers = AbstractLoggingInterceptor.extractHeaders(str);
                        if (headers == null || headers.isEmpty()) {
                            payload = (String)payload + "\r\n--- Content suppressed ---\r\n";
                            continue;
                        }
                        payload = (String)payload + "\r\n" + headers + "\r\n--- Content suppressed ---\r\n";
                        continue;
                    }
                    payload = (String)payload + str;
                    payload = (String)payload + boundary;
                }
                originalLogString = payload;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return originalLogString;
    }

    private static String extractHeaders(String str) {
        Matcher m = CONTENT_TYPE_PATTERN.matcher(str);
        if (m.find()) {
            int payloadStart = 0;
            int buffer = 0;
            for (int i = m.start(0); i < str.length(); ++i) {
                char c = str.charAt(i);
                if (c == '\n') {
                    if (buffer == 0) {
                        payloadStart = i;
                        break;
                    }
                    buffer = 0;
                    continue;
                }
                if (c == '\r') continue;
                ++buffer;
            }
            if (payloadStart > 0 && payloadStart < str.length()) {
                return str.substring(0, payloadStart).trim();
            }
        }
        return null;
    }

    private String findContentType(String payload) {
        Matcher m = CONTENT_TYPE_PATTERN.matcher(payload);
        return m.find() ? m.group(0) : null;
    }

    private String findBoundary(String payload) {
        Matcher m = BOUNDARY_PATTERN.matcher(payload);
        return m.find() ? "--" + m.group(1) : null;
    }
}

