/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.apache.commons.imaging.formats.png.PngImageParser;
import org.apache.commons.imaging.formats.png.PngImagingParameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PngWritePredictorTest {
    @BeforeAll
    public static void setUpClass() {
    }

    private int[] populateARGB() {
        int i;
        int[] argb = new int[65536];
        for (i = 0; i < 256; ++i) {
            for (int j = 0; j < 256; ++j) {
                int red = i;
                int green = 255 - i;
                int blue = j;
                argb[i * 256 + j] = ((0xFF00 | red) << 8 | green) << 8 | blue;
            }
        }
        for (i = 0; i < 256; ++i) {
            argb[i * 256 + i] = -16777216;
            if (i >= 255) continue;
            argb[i * 256 + i + 1] = -1;
        }
        return argb;
    }

    @BeforeEach
    public void setUp() {
    }

    @Test
    void testWriteWithPredictor() throws IOException {
        int[] argb = this.populateARGB();
        BufferedImage bImage = new BufferedImage(256, 256, 1);
        bImage.setRGB(0, 0, 256, 256, argb, 0, 256);
        byte[] tempFile = null;
        PngImagingParameters params = new PngImagingParameters();
        params.setPredictorEnabled(true);
        PngImageParser parser = new PngImageParser();
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            parser.writeImage(bImage, (OutputStream)bos, params);
            tempFile = bos.toByteArray();
        }
        int[] brgb = new int[65536];
        bImage = ImageIO.read(new ByteArrayInputStream(tempFile));
        bImage.getRGB(0, 0, 256, 256, brgb, 0, 256);
        Assertions.assertArrayEquals((int[])argb, (int[])brgb, (String)"Round trip for RGB failed");
        for (int i = 0; i < 256; ++i) {
            int n = i * 256 + i;
            argb[n] = argb[n] & 0x88FFFFFF;
        }
        bImage = new BufferedImage(256, 256, 2);
        bImage.setRGB(0, 0, 256, 256, argb, 0, 256);
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            parser.writeImage(bImage, (OutputStream)bos, params);
            tempFile = bos.toByteArray();
        }
        brgb = new int[65536];
        bImage = ImageIO.read(new ByteArrayInputStream(tempFile));
        bImage.getRGB(0, 0, 256, 256, brgb, 0, 256);
        Assertions.assertArrayEquals((int[])argb, (int[])brgb, (String)"Round trip for ARGB failed");
    }
}

