/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload2.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.fileupload2.core.QuotedPrintableDecoder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class QuotedPrintableDecoderTestCase {
    private static void assertEncoded(String clearText, String encoded) throws Exception {
        byte[] expected = clearText.getBytes(StandardCharsets.US_ASCII);
        ByteArrayOutputStream out = new ByteArrayOutputStream(encoded.length());
        byte[] encodedData = encoded.getBytes(StandardCharsets.US_ASCII);
        QuotedPrintableDecoder.decode((byte[])encodedData, (OutputStream)out);
        byte[] actual = out.toByteArray();
        Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
    }

    private static void assertIOException(String messageText, String encoded) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(encoded.length());
        byte[] encodedData = encoded.getBytes(StandardCharsets.US_ASCII);
        try {
            QuotedPrintableDecoder.decode((byte[])encodedData, (OutputStream)out);
            Assertions.fail((String)"Expected IOException");
        }
        catch (IOException e) {
            String em = e.getMessage();
            Assertions.assertTrue((boolean)em.contains(messageText), (String)("Expected to find " + messageText + " in '" + em + "'"));
        }
    }

    @Test
    void testBasicEncodeDecode() throws Exception {
        QuotedPrintableDecoderTestCase.assertEncoded("= Hello there =\r\n", "=3D Hello there =3D=0D=0A");
    }

    @Test
    void testEmptyDecode() throws Exception {
        QuotedPrintableDecoderTestCase.assertEncoded("", "");
    }

    @Test
    void testInvalidCharDecode() {
        Assertions.assertThrows(IOException.class, () -> QuotedPrintableDecoderTestCase.assertEncoded("=\r\n", "=3D=XD=XA"));
    }

    @Test
    void testInvalidQuotedPrintableEncoding() throws Exception {
        QuotedPrintableDecoderTestCase.assertIOException("truncated escape sequence", "YWJjMTIzXy0uKn4hQCMkJV4mKCkre31cIlxcOzpgLC9bXQ==");
    }

    @Test
    void testInvalidSoftBreak1() throws Exception {
        QuotedPrintableDecoderTestCase.assertIOException("CR must be followed by LF", "=\r\r");
    }

    @Test
    void testInvalidSoftBreak2() throws Exception {
        QuotedPrintableDecoderTestCase.assertIOException("CR must be followed by LF", "=\rn");
    }

    @Test
    void testPlainDecode() throws Exception {
        QuotedPrintableDecoderTestCase.assertEncoded("The quick brown fox jumps over the lazy dog.", "The quick brown fox jumps over the lazy dog.");
    }

    @Test
    void testSoftLineBreakDecode() throws Exception {
        QuotedPrintableDecoderTestCase.assertEncoded("If you believe that truth=beauty, then surely mathematics is the most beautiful branch of philosophy.", "If you believe that truth=3Dbeauty, then surely=20=\r\nmathematics is the most beautiful branch of philosophy.");
    }

    @Test
    void testTruncatedEscape() throws Exception {
        QuotedPrintableDecoderTestCase.assertIOException("truncated", "=1");
    }

    @Test
    void testUnsafeDecode() throws Exception {
        QuotedPrintableDecoderTestCase.assertEncoded("=\r\n", "=3D=0D=0A");
    }

    @Test
    void testUnsafeDecodeLowerCase() throws Exception {
        QuotedPrintableDecoderTestCase.assertEncoded("=\r\n", "=3d=0d=0a");
    }
}

