/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree;

import java.util.List;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.AbstractCombinerTest;
import org.apache.commons.configuration2.tree.ExpressionEngine;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.MergeCombiner;
import org.apache.commons.configuration2.tree.NodeCombiner;
import org.apache.commons.configuration2.tree.NodeHandler;
import org.apache.commons.configuration2.tree.QueryResult;
import org.apache.commons.configuration2.tree.xpath.XPathExpressionEngine;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestMergeCombiner
extends AbstractCombinerTest {
    private ImmutableNode checkTable(HierarchicalConfiguration<ImmutableNode> config) {
        Assertions.assertEquals((int)1, (int)config.getMaxIndex("database.tables.table"));
        HierarchicalConfiguration c = config.configurationAt("database.tables.table(0)");
        Assertions.assertEquals((Object)"documents", (Object)c.getString("name"));
        Assertions.assertEquals((int)2, (int)c.getMaxIndex("fields.field.name"));
        Assertions.assertEquals((Object)"docname", (Object)c.getString("fields.field(1).name"));
        NodeHandler nodeHandler = config.getNodeModel().getNodeHandler();
        List nds = config.getExpressionEngine().query((Object)((ImmutableNode)nodeHandler.getRootNode()), "database.tables.table", nodeHandler);
        Assertions.assertFalse((boolean)nds.isEmpty());
        Assertions.assertFalse((boolean)((QueryResult)nds.get(0)).isAttributeResult());
        return (ImmutableNode)((QueryResult)nds.get(0)).getNode();
    }

    @Override
    protected NodeCombiner createCombiner() {
        return new MergeCombiner();
    }

    @Test
    void testAttributes() throws ConfigurationException {
        BaseHierarchicalConfiguration config = this.createCombinedConfiguration();
        Assertions.assertEquals((int)1, (int)config.getInt("gui.level[@min]"));
        Assertions.assertEquals((int)2, (int)config.getInt("gui.level[@default]"));
        Assertions.assertEquals((int)0, (int)config.getMaxIndex("database.tables.table(0)[@id]"));
        Assertions.assertEquals((int)1, (int)config.getInt("database.tables.table(0)[@id]"));
    }

    @Test
    void testCombinedTable() throws ConfigurationException {
        this.checkTable((HierarchicalConfiguration<ImmutableNode>)this.createCombinedConfiguration());
    }

    @Test
    void testListFromFirstStructure() throws ConfigurationException {
        BaseHierarchicalConfiguration config = this.createCombinedConfiguration();
        Assertions.assertEquals((int)0, (int)config.getMaxIndex("net.service.url"));
        Assertions.assertEquals((Object)"http://service1.org", (Object)config.getString("net.service.url"));
        Assertions.assertFalse((boolean)config.containsKey("net.service.url[@type]"));
    }

    @Test
    void testListFromSecondStructure() throws ConfigurationException {
        BaseHierarchicalConfiguration config = this.createCombinedConfiguration();
        Assertions.assertEquals((int)3, (int)config.getMaxIndex("net.server.url"));
        Assertions.assertEquals((Object)"http://testsvr.com", (Object)config.getString("net.server.url(2)"));
    }

    @Test
    void testMerge() throws ConfigurationException {
        BaseHierarchicalConfiguration config = this.createCombinedConfiguration();
        config.setExpressionEngine((ExpressionEngine)new XPathExpressionEngine());
        Assertions.assertEquals((int)3, (int)config.getMaxIndex("Channels/Channel"));
        Assertions.assertEquals((Object)"My Channel", (Object)config.getString("Channels/Channel[@id='1']/Name"));
        Assertions.assertEquals((Object)"half", (Object)config.getString("Channels/Channel[@id='1']/@type"));
        Assertions.assertEquals((Object)"Channel 2", (Object)config.getString("Channels/Channel[@id='2']/Name"));
        Assertions.assertEquals((Object)"full", (Object)config.getString("Channels/Channel[@id='2']/@type"));
        Assertions.assertEquals((Object)"test 1 data", (Object)config.getString("Channels/Channel[@id='1']/ChannelData"));
        Assertions.assertEquals((Object)"test 2 data", (Object)config.getString("Channels/Channel[@id='2']/ChannelData"));
        Assertions.assertEquals((Object)"more test 2 data", (Object)config.getString("Channels/Channel[@id='2']/MoreChannelData"));
    }

    @Test
    void testOverrideValues() throws ConfigurationException {
        BaseHierarchicalConfiguration config = this.createCombinedConfiguration();
        Assertions.assertEquals((Object)"Admin", (Object)config.getString("base.services.security.login.user"));
        Assertions.assertEquals((Object)"default", (Object)config.getString("base.services.security.login.user[@type]"));
        Assertions.assertNull((Object)config.getString("base.services.security.login.passwd"));
        Assertions.assertEquals((Object)"secret", (Object)config.getString("base.services.security.login.passwd[@type]"));
    }

    @Test
    void testSimpleValues() throws ConfigurationException {
        BaseHierarchicalConfiguration config = this.createCombinedConfiguration();
        Assertions.assertEquals((int)0, (int)config.getMaxIndex("gui.bgcolor"));
        Assertions.assertEquals((Object)"green", (Object)config.getString("gui.bgcolor"));
        Assertions.assertEquals((Object)"yellow", (Object)config.getString("gui.selcolor"));
        Assertions.assertEquals((Object)"blue", (Object)config.getString("gui.fgcolor"));
        Assertions.assertEquals((int)1, (int)config.getInt("gui.level"));
    }
}

