/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder.combined;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BasicBuilderParameters;
import org.apache.commons.configuration2.builder.BasicConfigurationBuilder;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.ConfigurationBuilder;
import org.apache.commons.configuration2.builder.FileBasedBuilderParametersImpl;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.ReloadingFileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.combined.BaseConfigurationBuilderProvider;
import org.apache.commons.configuration2.builder.combined.CombinedConfigurationBuilder;
import org.apache.commons.configuration2.builder.combined.ConfigurationDeclaration;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.DisabledListDelimiterHandler;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBaseConfigurationBuilderProvider {
    private void checkAllowFailOnInit(boolean expFlag, String ... props) throws ConfigurationException {
        HierarchicalConfiguration<?> declConfig = this.setUpConfig(false);
        for (String key : props) {
            declConfig.addProperty(key, (Object)Boolean.TRUE);
        }
        ConfigurationDeclaration decl = this.createDeclaration(declConfig);
        BasicConfigurationBuilder builder = (BasicConfigurationBuilder)this.createProvider().getConfigurationBuilder(decl);
        Assertions.assertEquals((Object)expFlag, (Object)builder.isAllowFailOnInit());
    }

    private ConfigurationBuilder<? extends Configuration> checkBuilder(boolean reload) throws ConfigurationException {
        HierarchicalConfiguration<?> declConfig = this.setUpConfig(reload);
        ConfigurationDeclaration decl = this.createDeclaration(declConfig);
        ConfigurationBuilder builder = this.createProvider().getConfigurationBuilder(decl);
        Configuration config = (Configuration)builder.getConfiguration();
        Assertions.assertEquals(PropertiesConfiguration.class, (Object)config.getClass());
        PropertiesConfiguration pconfig = (PropertiesConfiguration)config;
        Assertions.assertTrue((boolean)pconfig.isThrowExceptionOnMissing());
        DefaultListDelimiterHandler listHandler = (DefaultListDelimiterHandler)pconfig.getListDelimiterHandler();
        Assertions.assertEquals((char)';', (char)listHandler.getDelimiter());
        Assertions.assertTrue((boolean)pconfig.getBoolean("configuration.loaded"));
        return builder;
    }

    private ConfigurationDeclaration createDeclaration(HierarchicalConfiguration<?> declConfig) {
        CombinedConfigurationBuilder parentBuilder = new CombinedConfigurationBuilder(){

            protected void initChildBuilderParameters(BuilderParameters params) {
                if (params instanceof BasicBuilderParameters) {
                    ((BasicBuilderParameters)params).setListDelimiterHandler(DisabledListDelimiterHandler.INSTANCE);
                }
            }
        };
        return new ConfigurationDeclaration(parentBuilder, declConfig){

            protected Object interpolate(Object value) {
                return value;
            }
        };
    }

    private BaseConfigurationBuilderProvider createProvider() {
        return new BaseConfigurationBuilderProvider(FileBasedConfigurationBuilder.class.getName(), ReloadingFileBasedConfigurationBuilder.class.getName(), PropertiesConfiguration.class.getName(), Arrays.asList(FileBasedBuilderParametersImpl.class.getName()));
    }

    private HierarchicalConfiguration<?> setUpConfig(boolean reload) {
        BaseHierarchicalConfiguration config = new BaseHierarchicalConfiguration();
        config.addProperty("[@config-reload]", (Object)reload);
        config.addProperty("[@throwExceptionOnMissing]", (Object)Boolean.TRUE);
        config.addProperty("[@path]", (Object)ConfigurationAssert.getTestFile("test.properties").getAbsolutePath());
        config.addProperty("listDelimiterHandler[@config-class]", (Object)DefaultListDelimiterHandler.class.getName());
        config.addProperty("listDelimiterHandler.config-constrarg[@config-value]", (Object)";");
        return config;
    }

    @Test
    void testGetBuilderAllowFailOnInit() throws ConfigurationException {
        this.checkAllowFailOnInit(true, "[@config-optional]", "[@config-forceCreate]");
    }

    void testGetBuilderAllowFailOnInitNotOptional() throws ConfigurationException {
        this.checkAllowFailOnInit(false, "[@config-forceCreate]");
    }

    @Test
    void testGetBuilderNoFailOnInit() throws ConfigurationException {
        this.checkAllowFailOnInit(false, new String[0]);
    }

    @Test
    void testGetBuilderNotReloading() throws ConfigurationException {
        ConfigurationBuilder<? extends Configuration> builder = this.checkBuilder(false);
        Assertions.assertEquals(FileBasedConfigurationBuilder.class, (Object)builder.getClass());
    }

    @Test
    void testGetBuilderReloading() throws ConfigurationException {
        ConfigurationBuilder<? extends Configuration> builder = this.checkBuilder(true);
        Assertions.assertEquals(ReloadingFileBasedConfigurationBuilder.class, (Object)builder.getClass());
    }

    @Test
    void testGetParameterClassesModify() {
        BaseConfigurationBuilderProvider provider = new BaseConfigurationBuilderProvider(BasicConfigurationBuilder.class.getName(), null, PropertiesConfiguration.class.getName(), Arrays.asList(BasicBuilderParameters.class.getName()));
        Collection parameterClasses = provider.getParameterClasses();
        Assertions.assertThrows(UnsupportedOperationException.class, parameterClasses::clear);
    }

    @Test
    void testGetReloadingBuilderNotSupported() {
        BaseConfigurationBuilderProvider provider = new BaseConfigurationBuilderProvider(FileBasedConfigurationBuilder.class.getName(), null, PropertiesConfiguration.class.getName(), Arrays.asList(FileBasedBuilderParametersImpl.class.getName()));
        HierarchicalConfiguration<?> declConfig = this.setUpConfig(true);
        ConfigurationDeclaration decl = this.createDeclaration(declConfig);
        Assertions.assertThrows(ConfigurationException.class, () -> provider.getConfigurationBuilder(decl));
    }

    @Test
    void testInitNoBuilderClass() {
        String configClass = PropertiesConfiguration.class.getName();
        Assertions.assertThrows(IllegalArgumentException.class, () -> new BaseConfigurationBuilderProvider(null, null, configClass, null));
    }

    @Test
    void testInitNoConfigurationClass() {
        String builderClass = BasicConfigurationBuilder.class.getName();
        Assertions.assertThrows(IllegalArgumentException.class, () -> new BaseConfigurationBuilderProvider(builderClass, null, null, null));
    }

    @Test
    void testInitNoParameterClasses() {
        BaseConfigurationBuilderProvider provider = new BaseConfigurationBuilderProvider(BasicConfigurationBuilder.class.getName(), null, PropertiesConfiguration.class.getName(), null);
        Assertions.assertEquals(Collections.emptyList(), new ArrayList(provider.getParameterClasses()));
    }
}

