/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.Arrays;
import org.apache.commons.collections4.bloomfilter.Shape;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

public class ShapeTest {
    private final Shape shape = Shape.fromKM((int)3, (int)24);

    @Test
    public void testBadNumberOfBits() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Shape.fromKM((int)5, (int)0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Shape.fromNM((int)5, (int)0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Shape.fromNMK((int)5, (int)0, (int)7));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Shape.fromPMK((double)0.035, (int)0, (int)7));
    }

    @Test
    public void testBadNumberOfHashFunctions() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Shape.fromKM((int)0, (int)7));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Shape.fromNMK((int)5, (int)26, (int)0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Shape.fromPMK((double)0.35, (int)26, (int)0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Shape.fromNM((int)2, (int)1));
    }

    @Test
    public void testBadNumberOfItems() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Shape.fromNM((int)0, (int)24));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Shape.fromNMK((int)0, (int)24, (int)5));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Shape.fromNP((int)0, (double)0.02));
    }

    @Test
    public void testBadProbability() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Shape.fromNMK((int)4000, (int)8, (int)1));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Shape.fromNP((int)10, (double)0.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Shape.fromNP((int)10, (double)1.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Shape.fromNP((int)10, (double)Double.NaN));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Shape.fromNP((int)10, (double)Double.POSITIVE_INFINITY));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Shape.fromNP((int)10, (double)Double.NEGATIVE_INFINITY));
    }

    @ParameterizedTest
    @CsvSource(value={"3, 24", "1, 24", "1, 1", "13, 124", "13, 224"})
    public void testEqualsAndHashCode(int k, int m) {
        Shape shape1 = Shape.fromKM((int)k, (int)m);
        Assertions.assertEquals((Object)shape1, (Object)shape1);
        Assertions.assertEquals((int)Arrays.hashCode(new int[]{m, k}), (int)shape1.hashCode(), (String)"Doesn't match Arrays.hashCode(new int[] {m, k})");
        Assertions.assertNotEquals((Object)shape1, null);
        Assertions.assertNotEquals((Object)shape1, (Object)"text");
        Assertions.assertNotEquals((Object)shape1, (Object)3);
        Assertions.assertNotEquals((Object)shape1, (Object)Shape.fromKM((int)k, (int)(m + 1)));
        Assertions.assertNotEquals((Object)shape1, (Object)Shape.fromKM((int)(k + 1), (int)m));
        Shape shape2 = Shape.fromKM((int)k, (int)m);
        Assertions.assertEquals((Object)shape1, (Object)shape2);
        Assertions.assertEquals((int)shape1.hashCode(), (int)shape2.hashCode());
    }

    @Test
    public void testEstimateN() {
        for (int i = 0; i < 24; ++i) {
            double c = i;
            double expected = -8.0 * Math.log1p(-c / 24.0);
            Assertions.assertEquals((double)expected, (double)this.shape.estimateN(i), (String)("Error on " + i));
        }
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)this.shape.estimateN(24));
        Assertions.assertEquals((double)Double.NaN, (double)this.shape.estimateN(25));
    }

    @Test
    public void testFromKM() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Shape.fromKM((int)5, (int)0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Shape.fromKM((int)0, (int)5));
    }

    @Test
    public void testFromNM() {
        Shape shape = Shape.fromNM((int)5, (int)24);
        Assertions.assertEquals((int)24, (int)shape.getNumberOfBits());
        Assertions.assertEquals((int)3, (int)shape.getNumberOfHashFunctions());
        Assertions.assertEquals((double)0.100375138, (double)shape.getProbability(5), (double)1.0E-6);
        Assertions.assertThrows(IllegalArgumentException.class, () -> Shape.fromNM((int)5, (int)0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Shape.fromNM((int)0, (int)5));
    }

    @Test
    public void testFromNMK() {
        Shape shape = Shape.fromNMK((int)5, (int)24, (int)4);
        Assertions.assertEquals((int)24, (int)shape.getNumberOfBits());
        Assertions.assertEquals((int)4, (int)shape.getNumberOfHashFunctions());
        Assertions.assertEquals((double)0.102194782, (double)shape.getProbability(5), (double)1.0E-6);
        Assertions.assertThrows(IllegalArgumentException.class, () -> Shape.fromNMK((int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Shape.fromNMK((int)5, (int)5, (int)0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Shape.fromNMK((int)5, (int)0, (int)5));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Shape.fromNMK((int)0, (int)5, (int)5));
    }

    @Test
    public void testFromNP() {
        double probability = 5.0E-7;
        Shape shape = Shape.fromNP((int)10, (double)5.0E-7);
        Assertions.assertEquals((int)302, (int)shape.getNumberOfBits());
        Assertions.assertEquals((int)21, (int)shape.getNumberOfHashFunctions());
        Assertions.assertThrows(IllegalArgumentException.class, () -> Shape.fromNP((int)Integer.MAX_VALUE, (double)Math.nextDown(1.0)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Shape.fromNP((int)0, (double)5.0E-7));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Shape.fromNP((int)5, (double)0.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Shape.fromNP((int)Integer.MAX_VALUE, (double)Math.nextUp(0.0)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Shape.fromNP((int)Integer.MAX_VALUE, (double)0.1));
    }

    @Test
    public void testFromPMK() {
        Shape shape = Shape.fromPMK((double)0.1, (int)24, (int)3);
        Assertions.assertEquals((int)24, (int)shape.getNumberOfBits());
        Assertions.assertEquals((int)3, (int)shape.getNumberOfHashFunctions());
        Assertions.assertEquals((double)0.100375138, (double)shape.getProbability(5), (double)1.0E-6);
        Assertions.assertThrows(IllegalArgumentException.class, () -> Shape.fromPMK((double)Math.nextDown(1.0), (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE));
        shape = Shape.fromPMK((double)Math.nextUp(0.0), (int)5, (int)5);
        Assertions.assertEquals((double)1.0, (double)shape.getProbability(Integer.MAX_VALUE));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Shape.fromPMK((double)Math.nextDown(1.0), (int)5, (int)5));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Shape.fromPMK((double)0.0, (int)5, (int)5));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Shape.fromPMK((double)0.5, (int)0, (int)5));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Shape.fromPMK((double)0.5, (int)5, (int)0));
    }

    @Test
    public void testGetProbability() {
        for (int i = 0; i <= 24; ++i) {
            double expected = Math.pow(-Math.expm1(-3.0 * (double)i / 24.0), 3.0);
            Assertions.assertEquals((double)expected, (double)this.shape.getProbability(i), (String)("error at " + i));
        }
        Assertions.assertEquals((double)0.0, (double)this.shape.getProbability(0), (double)0.0);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.shape.getProbability(-1));
    }

    @Test
    public void testIsSparse() {
        boolean functions = true;
        for (int i = 1; i <= 3; ++i) {
            int bits = i * 64;
            Shape shape = Shape.fromKM((int)1, (int)bits);
            for (int n = 0; n <= bits; ++n) {
                int c = n;
                Assertions.assertEquals((Object)((double)(n * 32) <= Math.ceil((double)bits / 64.0) * 64.0 ? 1 : 0), (Object)shape.isSparse(n), () -> String.format("n=%d : bits=%d", c, bits));
            }
        }
    }

    @Test
    public void testProbability() {
        Shape shape = Shape.fromNMK((int)5, (int)24, (int)3);
        Assertions.assertEquals((int)24, (int)shape.getNumberOfBits());
        Assertions.assertEquals((int)3, (int)shape.getNumberOfHashFunctions());
        Assertions.assertEquals((double)0.100375138, (double)shape.getProbability(5), (double)1.0E-6);
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)"Shape[k=3 m=5]", (Object)Shape.fromKM((int)3, (int)5).toString());
    }
}

